/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.marble.util;

import com.jtech.marble.exception.ToolBoxException;
import com.jtech.marble.util.CollectionUtil;
import com.jtech.marble.util.text.StrUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.springframework.util.ClassUtils;

public class ClassUtil {
    private ClassUtil() {
    }

    public static boolean isNormalClass(Class<?> clazz) {
        return null != clazz && !clazz.isInterface() && !ClassUtil.isAbstract(clazz) && !clazz.isEnum() && !clazz.isArray() && !clazz.isAnnotation() && !clazz.isSynthetic() && !clazz.isPrimitive();
    }

    public static boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static <T> T newInstance(String clazz) {
        if (null == clazz) {
            return null;
        }
        try {
            return (T)Class.forName(clazz).newInstance();
        }
        catch (Exception e) {
            throw new ToolBoxException(StrUtil.format("Instance class [{}] error!", clazz), e);
        }
    }

    public static <T> T newInstance(Class<T> clazz) {
        if (null == clazz) {
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new ToolBoxException(StrUtil.format("Instance class [{}] error!", clazz), e);
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object ... params) {
        if (null == clazz) {
            return null;
        }
        if (CollectionUtil.isEmpty(params)) {
            return ClassUtil.newInstance(clazz);
        }
        try {
            return clazz.getDeclaredConstructor(ClassUtil.getClasses(params)).newInstance(params);
        }
        catch (Exception e) {
            throw new ToolBoxException(StrUtil.format("Instance class [{}] error!", clazz), e);
        }
    }

    public static Class<?>[] getClasses(Object ... objects) {
        Class[] classes = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            classes[i] = objects[i].getClass();
        }
        return classes;
    }

    public static Method setAccessible(Method method) {
        if (null != method && ClassUtil.isNotPublic(method)) {
            method.setAccessible(true);
        }
        return method;
    }

    public static boolean isNotPublic(Class<?> clazz) {
        return !ClassUtil.isPublic(clazz);
    }

    public static boolean isNotPublic(Method method) {
        return !ClassUtil.isPublic(method);
    }

    public static boolean isPublic(Class<?> clazz) {
        if (null == clazz) {
            throw new NullPointerException("Class to provided is null.");
        }
        return Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isPublic(Method method) {
        if (null == method) {
            throw new NullPointerException("Method to provided is null.");
        }
        return ClassUtil.isPublic(method.getDeclaringClass());
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable ex) {
            // empty catch block
        }
        if (cl == null && (cl = ClassUtils.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }
}

