/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.marble.shiro.freemarker.auth;

import com.jtech.marble.shiro.freemarker.auth.SecureTag;
import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModelException;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.Map;

public class PrincipalTag
extends SecureTag {
    String getType(Map params) {
        return this.getParam(params, "type");
    }

    String getProperty(Map params) {
        return this.getParam(params, "property");
    }

    @Override
    public void render(Environment env, Map params, TemplateDirectiveBody body) throws IOException, TemplateException {
        Object principal;
        String result = null;
        if (this.getSubject() != null && (principal = this.getType(params) == null ? this.getSubject().getPrincipal() : this.getPrincipalFromClassName(params)) != null) {
            String property = this.getProperty(params);
            result = property == null ? principal.toString() : this.getPrincipalProperty(principal, property);
        }
        if (result != null) {
            try {
                env.getOut().write(result);
            }
            catch (IOException ex) {
                throw new TemplateException("Error writing [" + result + "] to Freemarker.", (Exception)ex, env);
            }
        }
    }

    Object getPrincipalFromClassName(Map params) {
        String type = this.getType(params);
        try {
            Class<?> cls = Class.forName(type);
            return this.getSubject().getPrincipals().oneByType(cls);
        }
        catch (ClassNotFoundException ex) {
            this._logger.error("Unable to find class for name [" + type + "]", (Throwable)ex);
            return null;
        }
    }

    String getPrincipalProperty(Object principal, String property) throws TemplateModelException {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(principal.getClass());
            for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                if (!propertyDescriptor.getName().equals(property)) continue;
                Object value = propertyDescriptor.getReadMethod().invoke(principal, (Object[])null);
                return String.valueOf(value);
            }
            throw new TemplateModelException("Property [" + property + "] not found in principal of type [" + principal.getClass().getName() + "]");
        }
        catch (Exception ex) {
            throw new TemplateModelException("Error reading property [" + property + "] from principal of type [" + principal.getClass().getName() + "]", ex);
        }
    }
}

