/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.marble.util.number;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class NumberFormatUtil {
    public static String keepRandomPoint(Double value, int n) {
        if (value == null) {
            value = 0.0;
            return new BigDecimal(value).setScale(n, RoundingMode.HALF_UP).toString();
        }
        return new BigDecimal(value).setScale(n, RoundingMode.HALF_UP).toString();
    }

    public static String keep2Point(double value) {
        return NumberFormatUtil.keepRandomPoint(value, 2);
    }

    public static String keep1Point(double value) {
        return NumberFormatUtil.keepRandomPoint(value, 1);
    }

    public static String keepRandomPointZero(double value, int n) {
        DecimalFormat df = new DecimalFormat("#0.00");
        return df.format(Double.valueOf(NumberFormatUtil.keepRandomPoint(value, n)));
    }

    public static String keep2PointZero(double value) {
        return NumberFormatUtil.keepRandomPointZero(value, 2);
    }

    public static String percentRandomPoint(double value, int n) {
        NumberFormat percent = NumberFormat.getPercentInstance();
        percent.setGroupingUsed(false);
        percent.setMaximumFractionDigits(n);
        return percent.format(value);
    }

    public static String percent2Point(double value) {
        return NumberFormatUtil.percentRandomPoint(value, 2);
    }

    public static String latLngPoint(double value) {
        return NumberFormatUtil.keepRandomPoint(value, 3);
    }
}

