/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.marble.error;

import com.jtech.marble.error.ErrorCode;

public class ErrorModel {
    private final int code;
    private final String message;

    private ErrorModel(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public static ErrorModel build(ErrorCode code) {
        Builder builder = new Builder();
        builder.setCode(code.getCode());
        builder.setMessage("");
        return builder.createErrorModel();
    }

    public static ErrorModel build(ErrorCode code, String message) {
        Builder builder = new Builder();
        builder.setCode(code.getCode());
        builder.setMessage(message);
        return builder.createErrorModel();
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public static class Builder {
        private int code;
        private String message;

        public Builder setCode(int code) {
            this.code = code;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public ErrorModel createErrorModel() {
            return new ErrorModel(this.code, this.message);
        }
    }
}

