/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.marble.shiro.freemarker.auth;

import freemarker.core.Environment;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.util.Map;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SecureTag
implements TemplateDirectiveModel {
    protected final Logger _logger = LoggerFactory.getLogger(this.getClass());

    protected SecureTag() {
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        this.verifyParameters(params);
        this.verifyLoopVars(loopVars);
        this.render(env, params, body);
    }

    protected void verifyLoopVars(TemplateModel[] loopVars) throws TemplateModelException {
        if (loopVars.length != 0) {
            throw new TemplateModelException("Shiro directive doesn't allow loop variables!");
        }
    }

    public abstract void render(Environment var1, Map var2, TemplateDirectiveBody var3) throws IOException, TemplateException;

    protected String getParam(Map params, String name) {
        Object value = params.get(name);
        if (value instanceof SimpleScalar) {
            return ((SimpleScalar)value).getAsString();
        }
        return null;
    }

    protected Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    protected void verifyParameters(Map params) throws TemplateModelException {
    }

    protected void renderBody(Environment env, TemplateDirectiveBody body) throws IOException, TemplateException {
        if (body != null) {
            body.render(env.getOut());
        }
    }
}

