/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.marble.util.number;

import com.google.common.math.IntMath;
import com.google.common.math.LongMath;
import java.math.RoundingMode;

public class MathUtil {
    public static int nextPowerOfTwo(int value) {
        return IntMath.ceilingPowerOfTwo((int)value);
    }

    public static long nextPowerOfTwo(long value) {
        return LongMath.ceilingPowerOfTwo((long)value);
    }

    public static int previousPowerOfTwo(int value) {
        return IntMath.floorPowerOfTwo((int)value);
    }

    public static long previousPowerOfTwo(long value) {
        return LongMath.floorPowerOfTwo((long)value);
    }

    public static boolean isPowerOfTwo(int value) {
        return IntMath.isPowerOfTwo((int)value);
    }

    public static boolean isPowerOfTwo(long value) {
        return LongMath.isPowerOfTwo((long)value);
    }

    public static int modByPowerOfTwo(int value, int mod) {
        return value & mod - 1;
    }

    public static int gcd(int a, int b) {
        return IntMath.gcd((int)a, (int)b);
    }

    public static long gcd(long a, long b) {
        return LongMath.gcd((long)a, (long)b);
    }

    public static int mod(int x, int m) {
        return IntMath.mod((int)x, (int)m);
    }

    public static long mod(long x, long m) {
        return LongMath.mod((long)x, (long)m);
    }

    public static long mod(long x, int m) {
        return LongMath.mod((long)x, (int)m);
    }

    public static int divide(int p, int q, RoundingMode mode) {
        return IntMath.divide((int)p, (int)q, (RoundingMode)mode);
    }

    public static long divide(long p, long q, RoundingMode mode) {
        return LongMath.divide((long)p, (long)q, (RoundingMode)mode);
    }

    public static int pow(int b, int k) {
        return IntMath.pow((int)b, (int)k);
    }

    public static long pow(long b, int k) {
        return LongMath.pow((long)b, (int)k);
    }

    public static int sqrt(int x, RoundingMode mode) {
        return IntMath.sqrt((int)x, (RoundingMode)mode);
    }

    public static long sqrt(long x, RoundingMode mode) {
        return LongMath.sqrt((long)x, (RoundingMode)mode);
    }
}

