/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.marble.util.number;

import com.jtech.marble.util.base.MoreValidate;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.Validate;

public class RandomUtil {
    public static Random threadLocalRandom() {
        return ThreadLocalRandom.current();
    }

    public static SecureRandom secureRandom() {
        try {
            return SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            return new SecureRandom();
        }
    }

    public static int nextInt() {
        return RandomUtil.nextInt(RandomUtil.threadLocalRandom());
    }

    public static int nextInt(Random random) {
        int n = random.nextInt();
        n = n == Integer.MIN_VALUE ? 0 : Math.abs(n);
        return n;
    }

    public static int nextInt(int max) {
        return RandomUtil.nextInt(RandomUtil.threadLocalRandom(), max);
    }

    public static int nextInt(Random random, int max) {
        return random.nextInt(max);
    }

    public static int nextInt(int min, int max) {
        return RandomUtil.nextInt(RandomUtil.threadLocalRandom(), min, max);
    }

    public static int nextInt(Random random, int min, int max) {
        Validate.isTrue((max >= min ? 1 : 0) != 0, (String)"Start value must be smaller or equal to end value.", (Object[])new Object[0]);
        MoreValidate.nonNegative("min", min);
        if (min == max) {
            return min;
        }
        return min + random.nextInt(max - min);
    }

    public static long nextLong() {
        return RandomUtil.nextLong(RandomUtil.threadLocalRandom());
    }

    public static long nextLong(Random random) {
        long n = random.nextLong();
        n = n == Long.MIN_VALUE ? 0L : Math.abs(n);
        return n;
    }

    public static long nextLong(long max) {
        return RandomUtil.nextLong(RandomUtil.threadLocalRandom(), 0L, max);
    }

    public static long nextLong(Random random, long max) {
        return RandomUtil.nextLong(random, 0L, max);
    }

    public static long nextLong(long min, long max) {
        return RandomUtil.nextLong(RandomUtil.threadLocalRandom(), min, max);
    }

    public static long nextLong(Random random, long min, long max) {
        Validate.isTrue((max >= min ? 1 : 0) != 0, (String)"Start value must be smaller or equal to end value.", (Object[])new Object[0]);
        MoreValidate.nonNegative("min", min);
        if (min == max) {
            return min;
        }
        return (long)((double)min + (double)(max - min) * random.nextDouble());
    }

    public static double nextDouble() {
        return RandomUtil.nextDouble(RandomUtil.threadLocalRandom(), 0.0, Double.MAX_VALUE);
    }

    public static double nextDouble(Random random) {
        return RandomUtil.nextDouble(random, 0.0, Double.MAX_VALUE);
    }

    public static double nextDouble(double max) {
        return RandomUtil.nextDouble(RandomUtil.threadLocalRandom(), 0.0, max);
    }

    public static double nextDouble(Random random, double max) {
        return RandomUtil.nextDouble(random, 0.0, max);
    }

    public static double nextDouble(double min, double max) {
        return RandomUtil.nextDouble(RandomUtil.threadLocalRandom(), min, max);
    }

    public static double nextDouble(Random random, double min, double max) {
        Validate.isTrue((max >= min ? 1 : 0) != 0, (String)"Start value must be smaller or equal to end value.", (Object[])new Object[0]);
        MoreValidate.nonNegative("min", min);
        if (min == max) {
            return min;
        }
        return min + (max - min) * random.nextDouble();
    }

    public static String randomStringFixLength(int length) {
        return RandomStringUtils.random((int)length, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)RandomUtil.threadLocalRandom());
    }

    public static String randomStringFixLength(Random random, int length) {
        return RandomStringUtils.random((int)length, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)random);
    }

    public static String randomStringRandomLength(int minLength, int maxLength) {
        return RandomStringUtils.random((int)RandomUtil.nextInt(minLength, maxLength), (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)RandomUtil.threadLocalRandom());
    }

    public static String randomStringRandomLength(Random random, int minLength, int maxLength) {
        return RandomStringUtils.random((int)RandomUtil.nextInt(random, minLength, maxLength), (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)random);
    }

    public static String randomLetterFixLength(int length) {
        return RandomStringUtils.random((int)length, (int)0, (int)0, (boolean)true, (boolean)false, null, (Random)RandomUtil.threadLocalRandom());
    }

    public static String randomLetterFixLength(Random random, int length) {
        return RandomStringUtils.random((int)length, (int)0, (int)0, (boolean)true, (boolean)false, null, (Random)random);
    }

    public static String randomLetterRandomLength(int minLength, int maxLength) {
        return RandomStringUtils.random((int)RandomUtil.nextInt(minLength, maxLength), (int)0, (int)0, (boolean)true, (boolean)false, null, (Random)RandomUtil.threadLocalRandom());
    }

    public static String randomLetterRandomLength(Random random, int minLength, int maxLength) {
        return RandomStringUtils.random((int)RandomUtil.nextInt(random, minLength, maxLength), (int)0, (int)0, (boolean)true, (boolean)false, null, (Random)random);
    }

    public static String randomAsciiFixLength(int length) {
        return RandomStringUtils.random((int)length, (int)32, (int)127, (boolean)false, (boolean)false, null, (Random)RandomUtil.threadLocalRandom());
    }

    public static String randomAsciiFixLength(Random random, int length) {
        return RandomStringUtils.random((int)length, (int)32, (int)127, (boolean)false, (boolean)false, null, (Random)random);
    }

    public static String randomAsciiRandomLength(int minLength, int maxLength) {
        return RandomStringUtils.random((int)RandomUtil.nextInt(minLength, maxLength), (int)32, (int)127, (boolean)false, (boolean)false, null, (Random)RandomUtil.threadLocalRandom());
    }

    public static String randomAsciiRandomLength(Random random, int minLength, int maxLength) {
        return RandomStringUtils.random((int)RandomUtil.nextInt(random, minLength, maxLength), (int)32, (int)127, (boolean)false, (boolean)false, null, (Random)random);
    }
}

