/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.marble.util.text;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.ocpsoft.prettytime.PrettyTime;

public class PrettyTimeUtil {
    public static final String prettySeconds(int totalSeconds) {
        StringBuilder s = new StringBuilder();
        int second = totalSeconds % 60;
        if (totalSeconds > 0) {
            s.append("\u79d2");
            s.append(StringUtils.reverse((String)String.valueOf(second)));
        }
        int minute = (totalSeconds /= 60) % 60;
        if (totalSeconds > 0) {
            s.append("\u5206");
            s.append(StringUtils.reverse((String)String.valueOf(minute)));
        }
        int hour = (totalSeconds /= 60) % 24;
        if (totalSeconds > 0) {
            s.append(StringUtils.reverse((String)"\u5c0f\u65f6"));
            s.append(StringUtils.reverse((String)String.valueOf(hour)));
        }
        int day = (totalSeconds /= 24) % 31;
        if (totalSeconds > 0) {
            s.append("\u5929");
            s.append(StringUtils.reverse((String)String.valueOf(day)));
        }
        int month = (totalSeconds /= 31) % 12;
        if (totalSeconds > 0) {
            s.append("\u6708");
            s.append(StringUtils.reverse((String)String.valueOf(month)));
        }
        int year = totalSeconds /= 12;
        if (totalSeconds > 0) {
            s.append("\u5e74");
            s.append(StringUtils.reverse((String)String.valueOf(year)));
        }
        return s.reverse().toString();
    }

    public static String prettyTime(Date date) {
        PrettyTime p = new PrettyTime();
        return p.format(date);
    }

    public static String prettyTime(long millisecond) {
        PrettyTime p = new PrettyTime();
        return p.format(new Date(millisecond));
    }
}

