/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.marble.util.text;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.jtech.marble.util.CollectionUtil;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class StrUtil {
    public static List<String> split(String str, char separator) {
        Splitter splitter = StrUtil.createSplitter(separator);
        return splitter.splitToList((CharSequence)str);
    }

    public static List<String> split(String str, String separator) {
        Splitter splitter = StrUtil.createSplitter(separator);
        return splitter.splitToList((CharSequence)str);
    }

    public static Splitter createSplitter(char separator) {
        return Splitter.on((char)separator).omitEmptyStrings().trimResults();
    }

    public static Splitter createSplitter(String separator) {
        return Splitter.on((String)separator).omitEmptyStrings().trimResults();
    }

    public static Joiner createJoiner(String separator) {
        return Joiner.on((String)separator).skipNulls();
    }

    public static <T> String join(String separator, List<T> objs) {
        Joiner joiner = StrUtil.createJoiner(separator);
        return joiner.join(objs);
    }

    public static <T> String join(String separator, T[] objs) {
        Joiner joiner = StrUtil.createJoiner(separator);
        return joiner.join((Object[])objs);
    }

    public static String sub(String string, int fromIndex, int toIndex) {
        int len = string.length();
        if (fromIndex < 0) {
            if ((fromIndex = len + fromIndex) < 0) {
                fromIndex = 0;
            }
        } else if (fromIndex >= len) {
            fromIndex = len - 1;
        }
        if (toIndex < 0) {
            if ((toIndex = len + toIndex) < 0) {
                toIndex = len;
            }
        } else if (toIndex > len) {
            toIndex = len;
        }
        if (toIndex < fromIndex) {
            int tmp = fromIndex;
            fromIndex = toIndex;
            toIndex = tmp;
        }
        if (fromIndex == toIndex) {
            return "";
        }
        char[] strArray = string.toCharArray();
        char[] newStrArray = Arrays.copyOfRange(strArray, fromIndex, toIndex);
        return new String(newStrArray);
    }

    public static String format(String template, Object ... values) {
        if (CollectionUtil.isEmpty(values)) {
            return template;
        }
        StringBuilder sb = new StringBuilder();
        int length = template.length();
        int valueIndex = 0;
        for (int i = 0; i < length; ++i) {
            if (valueIndex >= values.length) {
                sb.append(StrUtil.sub(template, i, length));
                break;
            }
            char currentChar = template.charAt(i);
            if (currentChar == '{') {
                char nextChar;
                if ((nextChar = template.charAt(++i)) == '}') {
                    sb.append(values[valueIndex++]);
                    continue;
                }
                sb.append('{').append(nextChar);
                continue;
            }
            sb.append(currentChar);
        }
        return sb.toString();
    }

    public static String format(String template, Map<?, ?> map) {
        if (null == map || map.isEmpty()) {
            return template;
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            template = template.replace("{" + entry.getKey() + "}", entry.getValue().toString());
        }
        return template;
    }

    public static byte[] bytes(String str, String charset) {
        return StrUtil.bytes(str, StringUtils.isBlank((CharSequence)charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static byte[] bytes(String str, Charset charset) {
        if (str == null) {
            return null;
        }
        if (null == charset) {
            return str.getBytes();
        }
        return str.getBytes(charset);
    }

    public static String str(byte[] bytes, String charset) {
        return StrUtil.str(bytes, StringUtils.isBlank((CharSequence)charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String str(byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        if (null == charset) {
            return new String(data);
        }
        return new String(data, charset);
    }

    public static String str(ByteBuffer data, String charset) {
        if (data == null) {
            return null;
        }
        return StrUtil.str(data, Charset.forName(charset));
    }

    public static String str(ByteBuffer data, Charset charset) {
        if (null == charset) {
            charset = Charset.defaultCharset();
        }
        return charset.decode(data).toString();
    }

    public static ByteBuffer byteBuffer(String str, String charset) {
        return ByteBuffer.wrap(StrUtil.bytes(str, charset));
    }

    public static byte[] getBytes(String str, Charset charset) {
        if (null == str) {
            return null;
        }
        return null == charset ? str.getBytes() : str.getBytes(charset);
    }

    public static String firstCharToLowerCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    public static String firstCharToUpperCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] - 32);
            return new String(arr);
        }
        return str;
    }
}

