/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.marble.util.number;

import java.math.BigDecimal;

public class ArithUtil {
    private ArithUtil() {
    }

    public static BigDecimal add(BigDecimal b1, BigDecimal ... bn) {
        if (null == b1) {
            b1 = BigDecimal.ZERO;
        }
        if (null != bn) {
            for (BigDecimal b : bn) {
                b1 = b1.add(null == b ? BigDecimal.ZERO : b);
            }
        }
        return b1;
    }

    public static BigDecimal subtract(BigDecimal b1, BigDecimal ... bn) {
        return ArithUtil.subtract(true, b1, bn);
    }

    public static BigDecimal subtract(Boolean isZero, BigDecimal b1, BigDecimal ... bn) {
        if (null == b1) {
            b1 = BigDecimal.ZERO;
        }
        BigDecimal r = b1;
        if (null != bn) {
            for (BigDecimal b : bn) {
                r = r.subtract(null == b ? BigDecimal.ZERO : b);
            }
        }
        return isZero.booleanValue() ? (r.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : r) : r;
    }

    public static <T extends Number> BigDecimal divide(T b1, T b2) {
        return ArithUtil.divide(b1, b2, BigDecimal.ZERO);
    }

    public static <T extends Number> BigDecimal divide(T b1, T b2, BigDecimal defaultValue) {
        if (null == b1 || null == b2) {
            return defaultValue;
        }
        try {
            return BigDecimal.valueOf(b1.doubleValue()).divide(BigDecimal.valueOf(b2.doubleValue()), 2, 4);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static <T extends Number> BigDecimal multiply(T b1, T b2) {
        if (null == b1 || null == b2) {
            return BigDecimal.ZERO;
        }
        return BigDecimal.valueOf(b1.doubleValue()).multiply(BigDecimal.valueOf(b2.doubleValue())).setScale(2, 4);
    }

    public static double div(double v1, double v2) {
        return ArithUtil.div(v1, v2, 2);
    }

    public static double div(double v1, double v2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("scale must not be negetive");
        }
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.divide(b2, scale, 4).doubleValue();
    }

    public static double round(double v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("scale must not be negetive");
        }
        BigDecimal b = new BigDecimal(Double.toString(v));
        BigDecimal one = new BigDecimal("1");
        return b.divide(one, scale, 4).doubleValue();
    }

    public static double round(BigDecimal v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("scale must not be negetive");
        }
        BigDecimal one = new BigDecimal("1");
        return v.divide(one, scale, 4).doubleValue();
    }
}

