/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.marble.web.cookie;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Cookies {
    public static int defaultCookieLife = 604800;

    public static void addCookie(HttpServletResponse response, String name, String value) {
        Cookies.addCookie(response, name, value, defaultCookieLife, false);
    }

    public static void addCookieByHttpOnly(HttpServletResponse response, String name, String value) {
        Cookies.addCookie(response, name, value, defaultCookieLife, true);
    }

    public static void addCookie(HttpServletResponse response, String name, String value, int maxAge) {
        Cookies.addCookie(response, name, value, maxAge, false);
    }

    public static void deleteCookie(HttpServletRequest request, HttpServletResponse response, String name) {
        Cookie cookie = Cookies.getCookieByName(request, name);
        if (null == cookie) {
            return;
        }
        cookie.setMaxAge(0);
        response.addCookie(cookie);
    }

    public static void addCookie(HttpServletResponse response, String name, String value, int maxAge, boolean httpOnly) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        cookie.setHttpOnly(httpOnly);
        cookie.setMaxAge(maxAge);
        response.addCookie(cookie);
    }

    public static Cookie getCookieByName(HttpServletRequest request, String name) {
        Map<String, Cookie> cookieMap = Cookies.readCookieMap(request);
        if (cookieMap.containsKey(name)) {
            return cookieMap.get(name);
        }
        return null;
    }

    public static String getCookieValue(HttpServletRequest request, String name) {
        String cookieValue = "";
        Cookie c = Cookies.getCookieByName(request, name);
        if (null != c) {
            cookieValue = c.getValue();
        }
        return cookieValue;
    }

    public static Map<String, Cookie> readCookieMap(HttpServletRequest request) {
        HashMap cookieMap = Maps.newHashMap();
        Cookie[] cookies = request.getCookies();
        if (null != cookies) {
            for (Cookie cookie : cookies) {
                cookieMap.put(cookie.getName(), cookie);
            }
        }
        return cookieMap;
    }
}

