/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.marble.util.number;

import com.google.common.base.Strings;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.math.BigDecimal;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class NumberUtil {
    public static byte[] toBytes(int value) {
        return Ints.toByteArray((int)value);
    }

    public static byte[] toBytes(long value) {
        return Longs.toByteArray((long)value);
    }

    public static byte[] toBytes(double val) {
        return NumberUtil.toBytes(Double.doubleToRawLongBits(val));
    }

    public static int toInt(byte[] bytes) {
        return Ints.fromByteArray((byte[])bytes);
    }

    public static long toLong(byte[] bytes) {
        return Longs.fromByteArray((byte[])bytes);
    }

    public static double toDouble(byte[] bytes) {
        return Double.longBitsToDouble(NumberUtil.toLong(bytes));
    }

    public static boolean isNumber(String str) {
        return NumberUtils.isCreatable((String)str);
    }

    public static boolean isHexNumber(String value) {
        int index = value.startsWith("-") ? 1 : 0;
        return value.startsWith("0x", index) || value.startsWith("0X", index) || value.startsWith("#", index);
    }

    public static int toInt(String str) {
        return NumberUtils.toInt((String)str, (int)0);
    }

    public static int toInt(String str, int defaultValue) {
        return NumberUtils.toInt((String)str, (int)defaultValue);
    }

    public static long toLong(String str) {
        return NumberUtils.toLong((String)str, (long)0L);
    }

    public static long toLong(String str, long defaultValue) {
        return NumberUtils.toLong((String)str, (long)defaultValue);
    }

    public static double toDouble(String str) {
        return NumberUtils.toDouble((String)str, (double)0.0);
    }

    public static double toDouble(String str, double defaultValue) {
        return NumberUtils.toDouble((String)str, (double)defaultValue);
    }

    public static Integer toIntObject(String str) {
        return NumberUtil.toIntObject(str, null);
    }

    public static Integer toIntObject(String str, Integer defaultValue) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static Long toLongObject(String str) {
        return NumberUtil.toLongObject(str, null);
    }

    public static Long toLongObject(String str, Long defaultValue) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return defaultValue;
        }
        try {
            return Long.valueOf(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static Double toDoubleObject(String str) {
        return NumberUtil.toDoubleObject(str, null);
    }

    public static Double toDoubleObject(String str, Double defaultValue) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return defaultValue;
        }
        try {
            return Double.valueOf(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static Integer hexToIntObject(String str) {
        return NumberUtil.hexToIntObject(str, null);
    }

    public static Integer hexToIntObject(String str, Integer defaultValue) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return defaultValue;
        }
        try {
            return Integer.decode(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static Long hexToLongObject(String str) {
        return NumberUtil.hexToLongObject(str, null);
    }

    public static Long hexToLongObject(String str, Long defaultValue) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return defaultValue;
        }
        try {
            return Long.decode(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static String toString(int i) {
        return Integer.toString(i);
    }

    public static String toString(Integer i) {
        return i.toString();
    }

    public static String toString(long l) {
        return Long.toString(l);
    }

    public static String toString(Long l) {
        return l.toString();
    }

    public static String toString(double d) {
        return Double.toString(d);
    }

    public static String toString(Double d) {
        return d.toString();
    }

    public static String to2DigitString(double d) {
        return String.format(Locale.ROOT, "%.2f", d);
    }

    public static int toInt32(long x) {
        if ((long)((int)x) == x) {
            return (int)x;
        }
        throw new IllegalArgumentException("Int " + x + " out of range");
    }

    public static boolean compare(String amount, double compare) {
        if (Strings.isNullOrEmpty((String)amount)) {
            return false;
        }
        BigDecimal lenth = new BigDecimal(amount);
        return lenth.compareTo(BigDecimal.valueOf(compare)) >= 0;
    }

    public static boolean compare(BigDecimal amount, BigDecimal compare) {
        return amount != null && compare != null && amount.compareTo(compare) >= 0;
    }
}

