/*
 * The Hefei JingTong RDC(Research and Development Centre) Group.
 * __________________
 *
 *    Copyright 2015-2017
 *    All Rights Reserved.
 *
 *    NOTICE:  All information contained herein is, and remains
 *    the property of JingTong Company and its suppliers,
 *    if any.
 */

package com.jtech.marble.shiro.freemarker.auth;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;

import java.io.IOException;
import java.util.Map;

/**
 * <p> . </p>
 *
 * @author poplar.yfyang
 * @version 1.0 2012-10-27 10:32 AM
 * @since JDK 1.5
 */
public class AuthenticatedTag extends SecureTag {

    @Override
    public void render(Environment env, Map params, TemplateDirectiveBody body)
            throws IOException, TemplateException {

        if (getSubject() != null && getSubject().isAuthenticated()) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Subject exists and is authenticated.  Tag body will be evaluated.");
            }

            renderBody(env, body);
        } else {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Subject does not exist or is not authenticated.  Tag body will not be evaluated.");
            }
        }
    }
}
