package com.jtech.marble.vo;

import java.io.Serializable;
import java.util.List;

import lombok.Builder;
import lombok.Data;

/**
 * <p>ztree类
 </p>
 *
 * @author sog
 * @version 1.0
 * @since JDK 1.7
 */
@SuppressWarnings("unused")
@Data
@Builder
public class ZTreeVO<D extends Serializable> implements Serializable {
    private static final long serialVersionUID = 4858257964310637000L;
    /**
     * 结点编号
     */
    private String id;

    /**
     * 父级id
     */
    private String pid;

    /**
     * 结点名称
     */
    private String name;

    /**
     * 是否勾选
     */
    private boolean checked;
    /**
     * 设置节点是否隐藏 checkbox / radio
     */
    private boolean nocheck;

    /**
     * 是否是叶子节点
     */
    @Builder.Default
    private boolean open = true ;

    /**
     * 是否禁止勾选
     */
    private boolean chkDisabled;

    /**
     * 是否半选
     */
    private boolean halfCheck;

    /**
     * 是否隐藏
     */
    private boolean hidden;

    /**
     * 是否是父结点
     */
    private boolean parent;

    /**
     * 结点的子结点，如果是父结点，则存在子结点
     */
    private List<ZTreeVO<D>> children;

    /**
     * 结点点击跳转的地址
     */
    private String url;

    /**
     * 结点点击跳转目标
     */
    private String target;

    /**
     * 结点上的应用数据
     */
    private D data;
}
