/*
 * The Hefei JingTong RDC(Research and Development Centre) Group.
 * __________________
 *
 *    Copyright 2015-$today.yea
 *    All Rights Reserved.
 *
 *    NOTICE:  All information contained herein is, and remains
 *    the property of JingTong Company and its suppliers,
 *    if any.
 */

package com.jtech.marble.web.cookie;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;

import static com.jtech.marble.StringPool.AMPERSAND;
import static com.jtech.marble.StringPool.EQUALS;
import static com.jtech.marble.StringPool.UTF_8;

/**
 * CookieDataCodec and CookieDataCodecTest are imported from Play Framework.
 *
 * Enables us to use the same sessions as Play Framework if
 * the secret is the same.
 *
 * Also really important because we want to make sure that our client
 * side session mechanism is widely used and stable.
 * We don't want to reinvent
 * the wheel of securely encoding / decoding and signing cookie data.
 *
 * All praise goes to Play Framework and their awesome work.
 */
public class CookieDataCodec {

    /**
     * @param map  the map to decode data into.
     * @param data the data to decode.
     * @throws UnsupportedEncodingException
     */
    public static void decode(Map<String, String> map, String data) throws UnsupportedEncodingException {
        String[] keyValues = data.split(AMPERSAND);
        for (String keyValue : keyValues) {
            String[] splitted = keyValue.split(EQUALS, 2);
            if (splitted.length == 2) {
                final String decodeKey = URLDecoder.decode(splitted[0], UTF_8);
                final String decodeVal = URLDecoder.decode(splitted[1], UTF_8);
                map.put(decodeKey, decodeVal);
            }
        }
    }

    /**
     * @param map the data to encode.
     * @return the encoded data.
     * @throws UnsupportedEncodingException
     */
    public static String encode(Map<String, String> map) throws UnsupportedEncodingException {
        StringBuilder data = new StringBuilder();
        String separator = "";
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getValue() != null) {
                data.append(separator)
                        .append(URLEncoder.encode(entry.getKey(), UTF_8))
                        .append(EQUALS)
                        .append(URLEncoder.encode(entry.getValue(), UTF_8));
                separator = AMPERSAND;
            }
        }
        return data.toString();
    }

    /**
     * Constant time for same length String comparison, to prevent timing attacks
     */
    public static boolean safeEquals(String a, String b) {
        if (a.length() != b.length()) {
            return false;
        } else {
            char equal = 0;
            for (int i = 0; i < a.length(); i++) {
                equal |= a.charAt(i) ^ b.charAt(i);
            }
            return equal == 0;
        }
    }
}
