/*
 * The Hefei JingTong RDC(Research and Development Centre) Group.
 * __________________
 *
 *    Copyright 2015-2017
 *    All Rights Reserved.
 *
 *    NOTICE:  All information contained herein is, and remains
 *    the property of JingTong Company and its suppliers,
 *    if any.
 */

package com.jtech.marble.exception;


import com.jtech.marble.error.ErrorCode;

/**
 * <p> 参数验证异常 </p>
 *
 * @author sog
 * @version 1.0
 * @since JDK 1.7
 */
public class ParamCheckException extends RuntimeException {

    private static final long serialVersionUID = 7842501935220560306L;

    private final ErrorCode code;


    public ParamCheckException(ErrorCode code) {
        super();
        this.code = code;
    }


    public ParamCheckException(ErrorCode code, String message) {
        super(message);
        this.code = code;
    }

    public ParamCheckException(ErrorCode code, String message, Throwable cause) {
        super(message, cause);
        this.code = code;
    }

    public ParamCheckException(ErrorCode code, Throwable cause) {
        super(cause);
        this.code = code;
    }


    public ErrorCode getCode() {
        return code;
    }
}
