/*
 * The Hefei JingTong RDC(Research and Development Centre) Group.
 * __________________
 *
 *    Copyright 2015-2017
 *    All Rights Reserved.
 *
 *    NOTICE:  All information contained herein is, and remains
 *    the property of JingTong Company and its suppliers,
 *    if any.
 */

package com.jtech.marble.freemarker.layout;


import com.jtech.marble.freemarker.util.DirectiveUtil;
import com.jtech.marble.freemarker.util.TemplateDirectiveBodyOverrideWraper;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;

import java.io.IOException;
import java.util.Map;

/**
 * <p> Freemarker的覆盖自定义标记，用来覆盖模板中的指定区域. </p>
 *
 * @author poplar.yfyang
 * @version 1.0 2012-04-20 上午7:32
 * @since JDK 1.5
 */
public class OverrideDirective implements TemplateDirectiveModel {
    /**
     * 覆盖模板的自定义指令名称
     */
    public final static String DIRECTIVE_NAME = "override";

    @SuppressWarnings("rawtypes")
    @Override
    public void execute(Environment env, Map params, TemplateModel[] loopVars,
                        TemplateDirectiveBody body) throws TemplateException, IOException {
        String name = DirectiveUtil.getRequiredParam(params, "name");
        String overrideVariableName = DirectiveUtil.getOverrideVariableName(name);

        TemplateDirectiveBodyOverrideWraper override = DirectiveUtil.getOverrideBody(env, name);
        TemplateDirectiveBodyOverrideWraper current = new TemplateDirectiveBodyOverrideWraper(body, env);
        if (override == null) {
            env.setVariable(overrideVariableName, current);
        } else {
            DirectiveUtil.setTopBodyForParentBody(current, override);
        }
    }

}
