/*
 * The Hefei JingTong RDC(Research and Development Centre) Group.
 * __________________
 *
 *    Copyright 2015-2017
 *    All Rights Reserved.
 *
 *    NOTICE:  All information contained herein is, and remains
 *    the property of JingTong Company and its suppliers,
 *    if any.
 */

package com.jtech.marble.shiro.freemarker;


import com.jtech.marble.shiro.freemarker.auth.AuthenticatedTag;
import com.jtech.marble.shiro.freemarker.auth.GuestTag;
import com.jtech.marble.shiro.freemarker.auth.NotAuthenticatedTag;
import com.jtech.marble.shiro.freemarker.auth.PrincipalTag;
import com.jtech.marble.shiro.freemarker.auth.UserTag;
import com.jtech.marble.shiro.freemarker.permission.HasAnyPermissionsTag;
import com.jtech.marble.shiro.freemarker.permission.HasPermissionTag;
import com.jtech.marble.shiro.freemarker.permission.LacksPermissionTag;
import com.jtech.marble.shiro.freemarker.role.HasAnyRolesTag;
import com.jtech.marble.shiro.freemarker.role.HasRoleTag;
import com.jtech.marble.shiro.freemarker.role.LacksRoleTag;

import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;

/**
 * <p> Apache Shirio authentication Freemarker instructions. </p>
 *
 * @author poplar.yfyang
 * @version 1.0 2012-10-27 10:42 AM
 * @since JDK 1.5
 */
public class ShiroTags extends SimpleHash {

    private static final long serialVersionUID = -7857361083450860303L;

    /**
     * Constructs an empty hash that uses the default wrapper set in
     */
    public ShiroTags() {
        super((ObjectWrapper) null);
        put("authenticated", new AuthenticatedTag());
        put("guest", new GuestTag());
        put("hasAnyRoles", new HasAnyRolesTag());
        put("hasPermission", new HasPermissionTag());
        put("hasAnyPermissions", new HasAnyPermissionsTag());
        put("hasRole", new HasRoleTag());
        put("lacksPermission", new LacksPermissionTag());
        put("lacksRole", new LacksRoleTag());
        put("notAuthenticated", new NotAuthenticatedTag());
        put("principal", new PrincipalTag());
        put("user", new UserTag());
    }
}
