/*
 * The Hefei JingTong RDC(Research and Development Centre) Group.
 * __________________
 *
 *    Copyright 2015-2017
 *    All Rights Reserved.
 *
 *    NOTICE:  All information contained herein is, and remains
 *    the property of JingTong Company and its suppliers,
 *    if any.
 */

package com.jtech.marble.shiro.freemarker.role;


import com.jtech.marble.shiro.freemarker.auth.SecureTag;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;

import java.io.IOException;
import java.util.Map;

/**
 * <p> 角色标签，用于判定当前登录人的角色信息. </p>
 *
 * @author poplar.yfyang
 * @version 1.0 2012-10-27 10:34 AM
 * @since JDK 1.5
 */
public abstract class RoleTag extends SecureTag {

    /**
     * 获取角色名称，从但前的参数信息中.
     *
     * @param params 参数信息
     * @return 角色名称
     */
    private String getName(Map params) {
        return getParam(params, "name");
    }

    @Override
    public void render(Environment env, Map params, TemplateDirectiveBody body) throws IOException, TemplateException {
        boolean show = showTagBody(getName(params));
        if (show) {
            renderBody(env, body);
        }
    }

    protected abstract boolean showTagBody(String roleName);
}