/*
 * The Hefei JingTong RDC(Research and Development Centre) Group.
 * __________________
 *
 *    Copyright 2015-2017
 *    All Rights Reserved.
 *
 *    NOTICE:  All information contained herein is, and remains
 *    the property of JingTong Company and its suppliers,
 *    if any.
 */

package com.jtech.marble.util;

import org.apache.commons.lang3.tuple.Pair;

/**
 * <p>分页工具类 </p>
 *
 * @author sog
 * @version 1.0
 * @since JDK 1.7
 */
@SuppressWarnings("unused")
public class PageUtil {


    /**
     * 将页数和每页条目数转换为开始位置和结束位置<br>
     * 此方法用于不包括结束位置的分页方法<br>
     * 例如：<br>
     * 页码：1，每页10 -> [0, 10]<br>
     * 页码：2，每页10 -> [10, 20]<br>
     * 。。。<br>
     *
     * @param pageNo       页码（从1计数）
     * @param countPerPage 每页条目数
     * @return left为开始位置，right为结束位置
     */
    public static Pair<Integer, Integer> transToStartEnd(int pageNo, int countPerPage) {
        if (pageNo < 1) {
            pageNo = 1;
        }

        if (countPerPage < 1) {
            countPerPage = 0;
//			LogKit.warn("Count per page  [" + countPerPage + "] is not valid!");
        }

        int start = (pageNo - 1) * countPerPage;
        int end = start + countPerPage;

        return Pair.of(start, end);
    }

    /**
     * 根据总数计算总页数
     *
     * @param totalCount 总数
     * @param numPerPage 每页数
     * @return 总页数
     */
    public static int totalPage(int totalCount, int numPerPage) {
        if (numPerPage == 0) {
            return 0;
        }
        return totalCount % numPerPage == 0 ? (totalCount / numPerPage)
                : (totalCount / numPerPage + 1);
    }
}
