package com.jtech.marble.util;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.StringTokenizer;

/**
 * <p> </p>
 *
 * @author sog
 * @version 1.0
 * @since JDK 1.7
 */
public class SqlUtil {


    /**
     * 功能描述: 生成sql占位符 ?,?,?
     *
     * @return String    返回类型
     */
    public static String sqlHolder(int size) {
        String[] paras = new String[size];
        Arrays.fill(paras, "?");
        return StringUtils.join(paras, ',');
    }


    private String delSQlString(String sql) {
        StringBuilder delSql = new StringBuilder("in(");
        StringTokenizer Tokenizer = new StringTokenizer(sql, "|");

        // 标记本身等于分隔符的特殊情况
        delSql.append(Tokenizer.nextToken());
        while (Tokenizer.hasMoreTokens()) {
            delSql.append(Tokenizer.nextToken()).append(",");
        }
        delSql = new StringBuilder(delSql.substring(0, delSql.length() - 1) + ")");
        return delSql.toString();
    }

    private String delNewSQlString(String sql) {
        return "in (" + sql.replace('|', ',') + ")";
    }
}
