/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.marble.libs;

import com.jtech.marble.libs.CronExpression;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Time {
    private static final Pattern p = Pattern.compile("(([0-9]+?)((d|h|mi|min|mn|s)))+?");
    private static final Integer MINUTE = 60;
    private static final Integer HOUR = 60 * MINUTE;
    private static final Integer DAY = 24 * HOUR;

    public static int parseDuration(String duration) {
        if (duration == null) {
            return 30 * DAY;
        }
        Matcher matcher = p.matcher(duration);
        int seconds = 0;
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid duration pattern : " + duration);
        }
        matcher.reset();
        while (matcher.find()) {
            if (matcher.group(3).equals("d")) {
                seconds += Integer.parseInt(matcher.group(2)) * DAY;
                continue;
            }
            if (matcher.group(3).equals("h")) {
                seconds += Integer.parseInt(matcher.group(2)) * HOUR;
                continue;
            }
            if (matcher.group(3).equals("mi") || matcher.group(3).equals("min") || matcher.group(3).equals("mn")) {
                seconds += Integer.parseInt(matcher.group(2)) * MINUTE;
                continue;
            }
            seconds += Integer.parseInt(matcher.group(2));
        }
        return seconds;
    }

    public static Date parseCRONExpression(String cron) {
        try {
            return new CronExpression(cron).getNextValidTimeAfter(new Date());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid CRON pattern : " + cron, e);
        }
    }

    public static long cronInterval(String cron) {
        return Time.cronInterval(cron, new Date());
    }

    public static long cronInterval(String cron, Date date) {
        try {
            return new CronExpression(cron).getNextInterval(date);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid CRON pattern : " + cron, e);
        }
    }
}

