/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.marble.sap;

import com.google.common.collect.Maps;
import com.jtech.marble.sap.SapProp;
import com.sap.conn.jco.ext.DestinationDataEventListener;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DestinationDataProvider
implements com.sap.conn.jco.ext.DestinationDataProvider {
    private static Logger log = LoggerFactory.getLogger(DestinationDataProvider.class);
    private static Map<String, Properties> destinations;
    private static Properties ABAP_AS_properties;
    private static DestinationDataProvider provider;

    private DestinationDataProvider() {
        if (provider == null) {
            log.info("Creating MyDestinationDataProvider ...");
            destinations = Maps.newHashMap();
        }
    }

    public static DestinationDataProvider getInstance() {
        log.info("Creating MyDestinationDataProvider ...");
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDestination(String destinationName, Properties properties) {
        Map<String, Properties> map = destinations;
        synchronized (map) {
            if (destinations.containsKey(destinationName)) {
                destinations.remove(destinationName);
            }
            destinations.put(destinationName, properties);
        }
    }

    public void addSystem(SapProp system) {
        String peakLimit;
        String saprouter;
        Properties properties = new Properties();
        properties.setProperty("jco.client.ashost", system.getHost());
        properties.setProperty("jco.client.sysnr", system.getSystemNumber());
        properties.setProperty("jco.client.client", system.getClient());
        String r3name = system.getR3name();
        if (StringUtils.isNotEmpty((CharSequence)r3name)) {
            properties.setProperty("jco.client.r3name", r3name);
        }
        if (StringUtils.isNotEmpty((CharSequence)(saprouter = system.getSaprouter()))) {
            properties.setProperty("jco.client.saprouter", saprouter);
        }
        properties.setProperty("jco.client.lang", system.getLanguage());
        properties.setProperty("jco.client.user", system.getUser());
        properties.setProperty("jco.client.passwd", system.getPassword());
        String poolCapacity = system.getPoolCapacity();
        if (StringUtils.isNotEmpty((CharSequence)poolCapacity)) {
            properties.setProperty("jco.destination.pool_capacity", poolCapacity);
        }
        if (StringUtils.isNotEmpty((CharSequence)(peakLimit = system.getPeakLimit()))) {
            properties.setProperty("jco.destination.peak_limit", peakLimit);
        }
        ABAP_AS_properties = properties;
        this.addDestination(system.getName(), ABAP_AS_properties);
    }

    public Properties getDestinationProperties(String destinationName) {
        if (destinations.containsKey(destinationName)) {
            return destinations.get(destinationName);
        }
        throw new RuntimeException("Destination " + destinationName + " is not available");
    }

    public void setDestinationDataEventListener(DestinationDataEventListener eventListener) {
    }

    public boolean supportsEvents() {
        return false;
    }

    static {
        provider = new DestinationDataProvider();
    }
}

