/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.marble.sap;

import com.jtech.marble.error.BasisCode;
import com.jtech.marble.error.ErrorCode;
import com.jtech.marble.exception.BussinessException;
import com.jtech.marble.sap.DestinationDataProvider;
import com.jtech.marble.sap.SapProp;
import com.sap.conn.jco.JCoContext;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.ext.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(SapConnection.class);
    private JCoRepository repos;
    private JCoDestination dest;

    public SapConnection(SapProp sapProp) {
        DestinationDataProvider myProvider = DestinationDataProvider.getInstance();
        if (!Environment.isDestinationDataProviderRegistered()) {
            Environment.registerDestinationDataProvider((com.sap.conn.jco.ext.DestinationDataProvider)myProvider);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("the sap connection is : {}", (Object)sapProp);
        }
        try {
            myProvider.addSystem(sapProp);
            this.dest = JCoDestinationManager.getDestination((String)sapProp.getName());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Attributes: {}", (Object)this.dest.getAttributes());
            }
            this.repos = this.dest.getRepository();
        }
        catch (Exception e) {
            LOGGER.info("====connection error!!!====", (Throwable)e);
            throw new BussinessException(e, (ErrorCode)BasisCode.SAP_CONNECTION_ERROR);
        }
    }

    public JCoFunction getFunction(String functionStr) {
        JCoFunction function;
        try {
            function = this.repos.getFunction(functionStr);
        }
        catch (Exception e) {
            LOGGER.error("Problem retrieving JCoFunction object.", (Throwable)e);
            throw new BussinessException(e, (ErrorCode)BasisCode.SAP_FUNC_DEFINE_ERROR);
        }
        if (function == null) {
            LOGGER.warn("Not possible to receive function.");
        }
        return function;
    }

    public void execute(JCoFunction function) {
        try {
            JCoContext.begin((JCoDestination)this.dest);
            function.execute(this.dest);
        }
        catch (JCoException e) {
            LOGGER.error("Problem execute JCoFunction.", (Throwable)e);
            throw new BussinessException(e, (ErrorCode)BasisCode.SAP_FUNC_EXEC_ERROR);
        }
        finally {
            try {
                JCoContext.end((JCoDestination)this.dest);
            }
            catch (JCoException e) {
                LOGGER.error("Problem end of execute JCoFunction ", (Throwable)e);
            }
        }
    }
}

