/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.marble.sap;

import com.google.common.collect.Lists;
import com.jtech.marble.sap.info.TransferInfo;
import com.jtech.marble.sap.info.TransferParameter;
import com.jtech.marble.sap.info.TransferStructure;
import com.jtech.marble.sap.info.TransferTable;
import com.jtech.marble.sap.model.MarTransferInfo;
import com.jtech.marble.sap.model.MarTransferParameter;
import com.jtech.marble.sap.model.MarTransferStructure;
import com.jtech.marble.sap.model.MarTransferTable;
import com.jtech.marble.sap.param.MarRfcException;
import com.jtech.marble.sap.param.MarRfcParam;
import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCoField;
import com.sap.conn.jco.JCoFieldIterator;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoListMetaData;
import com.sap.conn.jco.JCoMetaData;
import com.sap.conn.jco.JCoParameterFieldIterator;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import com.xiaoleilu.hutool.util.NumberUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SapFunctionUtil {
    private static final String SAP_TYPE_BCD = "BCD";
    private static final String SAP_TYPE_INT = "INT";
    private static final String SAP_TYPE_INT_1 = "INT1";
    private static final String SAP_TYPE_INT_2 = "INT2";
    private static final String SAP_TYPE_DECF_16 = "DECF16";
    private static final String SAP_TYPE_DECF_34 = "DECF34";
    private static final String SAP_TYPE_FLOAT = "FLOAT";
    private static final String SORT_NO_FORMAT = "000";

    private SapFunctionUtil() {
    }

    public static List<MarRfcParam> getTableList(JCoParameterList paralist, String rfcId) {
        ArrayList rfcImportParameterList = Lists.newArrayList();
        JCoParameterFieldIterator itor = paralist.getParameterFieldIterator();
        int i = 0;
        while (itor.hasNextField()) {
            JCoField tableFiled = itor.nextField();
            String tableName = tableFiled.getName();
            JCoTable returnuTable = paralist.getTable(tableName);
            JCoFieldIterator it = returnuTable.getFieldIterator();
            String classNameOfValue = tableFiled.getClassNameOfValue();
            String description = tableFiled.getDescription();
            int length = tableFiled.getLength();
            String sortno = NumberUtil.decimalFormat((String)SORT_NO_FORMAT, (long)(i + 1));
            String paraId = rfcId + sortno;
            MarRfcParam rfcParam = MarRfcParam.builder().rfcId(rfcId).paraName(tableName).marName(tableName).paraType(classNameOfValue).marType(classNameOfValue).paraDesc(description).marDesc(description).paraLength(length).marLength(length).leaf(false).sortno(sortno).paraId(paraId).parentId(0).build();
            rfcImportParameterList.add(rfcParam);
            ++i;
            ArrayList rfcParams = Lists.newArrayList();
            int j = 0;
            while (it.hasNextField()) {
                int fieldDecimals;
                JCoField field = it.nextField();
                String fieldClassNameOfValue = field.getClassNameOfValue();
                String fieldDescription = field.getDescription();
                String fieldName = field.getName();
                MarRfcParam.MarRfcParamBuilder rfcParamBuilder = MarRfcParam.builder().rfcId(rfcId).paraName(fieldName).marName(fieldName).paraDesc(fieldDescription).marDesc(fieldDescription).paraType(fieldClassNameOfValue).marType(fieldClassNameOfValue);
                int paraLength = field.getLength();
                String ftype = field.getTypeAsString();
                if (ftype.equals(SAP_TYPE_BCD)) {
                    paraLength = paraLength * 2 - 1;
                }
                if (ftype.equals(SAP_TYPE_INT) || ftype.equals(SAP_TYPE_INT_1) || ftype.equals(SAP_TYPE_INT_2)) {
                    paraLength *= 2;
                }
                if (ftype.equals(SAP_TYPE_DECF_16) || ftype.equals(SAP_TYPE_DECF_34)) {
                    paraLength = paraLength * 2 - 1;
                }
                if (ftype.equals(SAP_TYPE_FLOAT)) {
                    paraLength = paraLength * 2 - 1;
                }
                if (paraLength >= (fieldDecimals = field.getDecimals())) {
                    rfcParamBuilder.paraLength(paraLength).marLength(paraLength);
                } else {
                    rfcParamBuilder.paraLength(fieldDecimals).marLength(fieldDecimals);
                }
                String fieldSortno = NumberUtil.decimalFormat((String)SORT_NO_FORMAT, (long)(j + 1));
                String nextparaId = paraId + fieldSortno;
                MarRfcParam fileRfcParam = rfcParamBuilder.paraLength(length).marLength(length).leaf(true).sortno(fieldSortno).paraId(nextparaId).parentId(0).paraDecimals(fieldDecimals).marDecimals(fieldDecimals).build();
                rfcParams.add(rfcParam);
                rfcImportParameterList.add(rfcParam);
                ++j;
            }
            rfcParam.setChildrens(rfcParams);
        }
        return rfcImportParameterList;
    }

    public static List<MarRfcException> getParaExceptions(AbapException[] abapExceptionArray, String rfcId) {
        ArrayList rfcExceptionsrList = Lists.newArrayList();
        if (abapExceptionArray != null) {
            for (int i = 0; i < abapExceptionArray.length; ++i) {
                AbapException exception = abapExceptionArray[i];
                String paraId = NumberUtil.decimalFormat((String)SORT_NO_FORMAT, (long)(i + 1));
                MarRfcException rfcException = MarRfcException.builder().paraId(paraId).paraName(exception.getKey()).paraDesc(exception.getMessage()).sortno(i).optional(false).build();
                rfcExceptionsrList.add(rfcException);
            }
        }
        return rfcExceptionsrList;
    }

    public static List<MarRfcParam> getParaList(JCoParameterList paralist, String rfcId) {
        if (paralist == null) {
            return null;
        }
        ArrayList rfcParameterList = Lists.newArrayList();
        for (int i = 0; i < paralist.getFieldCount(); ++i) {
            JCoMetaData metaData = paralist.getMetaData();
            JCoListMetaData listMetaData = paralist.getListMetaData();
            boolean structure = metaData.isStructure(i);
            MarRfcParam marRfcParam = SapFunctionUtil.metaToParam(rfcId, i, metaData, listMetaData);
            rfcParameterList.add(marRfcParam);
            if (!structure) continue;
            ArrayList childrens = Lists.newArrayList();
            JCoRecordMetaData jcometadata = metaData.getRecordMetaData(i);
            for (int j = 0; j < jcometadata.getFieldCount(); ++j) {
                MarRfcParam fileParam = SapFunctionUtil.metaToParam(rfcId, j, (JCoMetaData)jcometadata, listMetaData);
                String sortno = NumberUtil.decimalFormat((String)SORT_NO_FORMAT, (long)(j + 1));
                fileParam.setSortno(sortno);
                String nextparaId = marRfcParam.getParaId() + sortno;
                fileParam.setLeaf(true);
                fileParam.setParaId(nextparaId);
                childrens.add(fileParam);
                rfcParameterList.add(fileParam);
            }
            marRfcParam.setChildrens(childrens);
        }
        return rfcParameterList;
    }

    public static void setFunctionParas(MarTransferInfo rfctransferinfo, JCoFunction function) {
        JCoParameterList paras = function.getImportParameterList();
        MarTransferParameter rfcimport = rfctransferinfo.getImportPara();
        for (int i = 0; i < rfcimport.getStructureList().size(); ++i) {
            MarTransferStructure rfcStructure = rfcimport.getStructureList().get(i);
            String string = rfcStructure.getStructureName();
            JCoStructure structure = paras.getStructure(string);
            Map<String, Object> map = rfcStructure.getStructureMap();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                structure.setValue(entry.getKey().toString(), entry.getValue());
            }
        }
        Map<String, Object> inputs = rfcimport.getParameters();
        for (Map.Entry entry : inputs.entrySet()) {
            paras.setValue((String)entry.getKey(), entry.getValue());
        }
        for (int t = 0; t < rfctransferinfo.getTableList().size(); ++t) {
            String string = rfctransferinfo.getTableList().get(t).getName();
            JCoTable table = function.getTableParameterList().getTable(string);
            table.deleteAllRows();
            MarTransferTable transRfctable = rfctransferinfo.getTableList().get(t);
            for (int i = 0; i < transRfctable.getMetaData().size(); ++i) {
                table.appendRow();
                Map<String, Object> map = transRfctable.getMetaData().get(i);
                for (Map.Entry<String, Object> mapValue : map.entrySet()) {
                    table.setValue(mapValue.getKey().toString(), mapValue.getValue());
                }
            }
        }
    }

    public static TransferInfo functionExectue(JCoFunction function, MarTransferInfo inTransferInfo) {
        JCoParameterList export = function.getExportParameterList();
        TransferParameter rfcExport = new TransferParameter();
        TransferInfo outFunctionInfo = new TransferInfo();
        if (export != null) {
            for (int i = 0; i < export.getFieldCount(); ++i) {
                String exportName = export.getMetaData().getName(i);
                if (!export.getMetaData().isStructure(i)) {
                    rfcExport.setParameter(exportName, export.getString(exportName));
                    continue;
                }
                TransferStructure rfcstructure = new TransferStructure();
                JCoRecordMetaData jcometadata = export.getMetaData().getRecordMetaData(i);
                rfcstructure.setStructureName(exportName);
                JCoStructure returnStructure = (JCoStructure)export.getValue(exportName);
                for (int j = 0; j < jcometadata.getFieldCount(); ++j) {
                    rfcstructure.setValue(jcometadata.getName(j), returnStructure.getString(jcometadata.getName(j)));
                }
                rfcExport.appendStructure(rfcstructure);
            }
        }
        outFunctionInfo.setExportPara(rfcExport);
        if (function.getTableParameterList() != null && function.getTableParameterList().getFieldCount() > 0) {
            for (int k = 0; k < function.getTableParameterList().getFieldCount(); ++k) {
                TransferTable outRfctable = new TransferTable();
                String tablename = function.getTableParameterList().getMetaData().getName(k);
                JCoTable returnuTable = function.getTableParameterList().getTable(tablename);
                outRfctable.setName(tablename);
                if (returnuTable.getNumRows() > 0) {
                    do {
                        JCoFieldIterator e = returnuTable.getFieldIterator();
                        while (e.hasNextField()) {
                            JCoField field = e.nextField();
                            String fieldValue = field.getString();
                            outRfctable.setValue(field.getName(), fieldValue);
                            SapFunctionUtil.isCheckSelect(inTransferInfo, outRfctable, field.getName());
                        }
                        outRfctable.appendRow();
                    } while (returnuTable.nextRow());
                }
                outFunctionInfo.appendTable(outRfctable);
            }
        }
        return outFunctionInfo;
    }

    private static MarRfcParam metaToParam(String rfcId, int i, JCoMetaData metaData, JCoListMetaData listMetaData) {
        int decimals;
        String name = metaData.getName(i);
        String classNameOfField = metaData.getClassNameOfField(i);
        String description = metaData.getDescription(i);
        boolean optional = listMetaData.isOptional(i);
        MarRfcParam.MarRfcParamBuilder paramBuilder = MarRfcParam.builder().rfcId(rfcId).paraName(name).marName(name).paraType(classNameOfField).marName(classNameOfField).paraDesc(description).marDesc(description).paraOptional(optional).leaf(metaData.isStructure(i));
        int paraLength = metaData.getLength(i);
        String ftype = metaData.getTypeAsString(i);
        if (ftype.equals(SAP_TYPE_BCD)) {
            paraLength = paraLength * 2 - 1;
        }
        if (ftype.equals(SAP_TYPE_INT) || ftype.equals(SAP_TYPE_INT_1) || ftype.equals(SAP_TYPE_INT_2)) {
            paraLength *= 2;
        }
        if (ftype.equals(SAP_TYPE_DECF_16) || ftype.equals(SAP_TYPE_DECF_34)) {
            paraLength = paraLength * 2 - 1;
        }
        if (ftype.equals(SAP_TYPE_FLOAT)) {
            paraLength = paraLength * 2 - 1;
        }
        if (paraLength >= (decimals = metaData.getDecimals(i))) {
            paramBuilder.paraLength(paraLength).marLength(paraLength);
        } else {
            paramBuilder.paraLength(decimals).marLength(decimals);
        }
        String sortNo = NumberUtil.decimalFormat((String)SORT_NO_FORMAT, (long)(i + 1));
        String paraId = rfcId + sortNo;
        return paramBuilder.paraDecimals(decimals).marDecimals(decimals).parentId(0).sortno(sortNo).paraId(paraId).build();
    }

    private static void isCheckSelect(MarTransferInfo inTransferInfo, TransferTable outRfctable, String tableFiledName) {
        if (inTransferInfo != null) {
            MarTransferParameter rfcimport = inTransferInfo.getImportPara();
            Map<String, Object> inputs = rfcimport.getParameters();
            Set<String> set = inputs.keySet();
            for (String keyName : set) {
                Object value = inputs.get(keyName);
                if (!keyName.equals("I_" + tableFiledName)) continue;
                outRfctable.setValue(tableFiledName, value);
            }
        }
    }
}

