/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.marble.util;

import com.google.common.base.Throwables;
import com.jtech.marble.util.text.EncodeUtil;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import org.apache.commons.lang3.StringUtils;

public class PasswordUtil {
    public static final String HASH_ALGORITHM = "SHA-1";
    public static final int HASH_INTERATIONS = 1024;
    private static final int SALT_SIZE = 8;
    private static SecureRandom random = new SecureRandom();

    public static String salt(byte[] salts) {
        String strSalt = EncodeUtil.encodeHex(salts);
        return StringUtils.lowerCase((String)strSalt);
    }

    public static boolean checkPassword(String salt, String password, String plainPassword) {
        byte[] saltHex = EncodeUtil.decodeHex(salt);
        byte[] hashPassword = PasswordUtil.sha1(plainPassword.getBytes(), saltHex);
        String hexPassword = EncodeUtil.encodeHex(hashPassword);
        return StringUtils.equals((CharSequence)StringUtils.lowerCase((String)hexPassword), (CharSequence)password);
    }

    public static String password(byte[] salt, String password) {
        byte[] passwordBytes = PasswordUtil.sha1(password.getBytes(), salt);
        String saltPassword = EncodeUtil.encodeHex(passwordBytes);
        return StringUtils.lowerCase((String)saltPassword);
    }

    public static byte[] sha1(byte[] input, byte[] salt) {
        return PasswordUtil.digest(input, salt, 1024);
    }

    private static byte[] digest(byte[] input, byte[] salt, int iterations) {
        try {
            MessageDigest digest = MessageDigest.getInstance(HASH_ALGORITHM);
            if (salt != null) {
                digest.update(salt);
            }
            byte[] result = digest.digest(input);
            for (int i = 1; i < iterations; ++i) {
                digest.reset();
                result = digest.digest(result);
            }
            return result;
        }
        catch (GeneralSecurityException e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new AssertionError((Object)e);
        }
    }

    public static byte[] generateSalt() {
        return PasswordUtil.generateSalt(8);
    }

    public static byte[] generateSalt(int size) {
        byte[] bytes = new byte[size];
        random.nextBytes(bytes);
        return bytes;
    }
}

