/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.marble.util.number;

import java.math.BigDecimal;
import java.text.DecimalFormat;

public class MoneyUtil {
    public static final BigDecimal ZERO = BigDecimal.valueOf(0.0);
    public static final BigDecimal HUNDRED = new BigDecimal(100.0);
    public static BigDecimal POINT_BILLION = new BigDecimal("100000000");
    public static BigDecimal TEN_THOUSANDS = new BigDecimal("10000");

    private MoneyUtil() {
    }

    public static BigDecimal decimal1ByUp(BigDecimal amount) {
        return amount.setScale(1, 6);
    }

    public static BigDecimal decimal2ByUp(BigDecimal amount) {
        return amount.setScale(2, 6);
    }

    public static BigDecimal decimal4ByUp(BigDecimal amount) {
        return amount.setScale(4, 6);
    }

    public static BigDecimal divide2ByUp(BigDecimal divideAmount, BigDecimal dividedAmount) {
        return divideAmount.divide(dividedAmount, 2, 6);
    }

    public static BigDecimal divide4ByUp(BigDecimal divideAmount, BigDecimal dividedAmount) {
        return divideAmount.divide(dividedAmount, 4, 6);
    }

    public static boolean isGreaterThanZero(BigDecimal amount) {
        return amount.compareTo(BigDecimal.ZERO) > 0;
    }

    public static boolean isLessThanZero(BigDecimal amount) {
        return amount.compareTo(BigDecimal.ZERO) < 0;
    }

    public static boolean isEqualZero(BigDecimal amount) {
        return amount.compareTo(BigDecimal.ZERO) == 0;
    }

    public static boolean isGreaterThan(BigDecimal first, BigDecimal second) {
        return first.compareTo(second) > 0;
    }

    public static boolean isLessThan(BigDecimal first, BigDecimal second) {
        return first.compareTo(second) < 0;
    }

    public static boolean isEqual(BigDecimal first, BigDecimal second) {
        return first.compareTo(second) == 0;
    }

    public static String formatAmountAsString(BigDecimal amount) {
        return amount != null ? new DecimalFormat(",##0.00").format(amount) : "0.00";
    }

    public static BigDecimal parseAmount(String amount) {
        return new BigDecimal(amount.replaceAll(",", ""));
    }
}

