/*
 * Decompiled with CFR 0.152.
 */
package com.github.sogyf.rabbitmq.consumer;

import com.github.sogyf.rabbitmq.RabbitMQInitialize;
import com.github.sogyf.rabbitmq.consumer.RabbitMQMessageConsumerJob;
import com.google.common.base.Throwables;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.QueueingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RabbitMQConsumer<T> {
    private static final Logger logger = LoggerFactory.getLogger(RabbitMQConsumer.class);
    private static int retries = RabbitMQInitialize.me.retries();

    protected abstract void consume(T var1);

    protected Channel createChannel() throws Exception {
        return RabbitMQInitialize.me.createChannel(this.queue(), this.routingKey());
    }

    protected QueueingConsumer createConsumer(Channel channel) throws Exception {
        QueueingConsumer consumer = new QueueingConsumer(channel);
        channel.basicConsume(this.queue(), RabbitMQInitialize.me.isAutoAck(), (Consumer)consumer);
        logger.info("RabbitMQ Consumer - Channel: {}, Consumer: {} ", (Object)channel, (Object)consumer);
        return consumer;
    }

    public void doJob() {
        this.goGetHerSon();
    }

    protected abstract Class getMessageType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void goGetHerSon() {
        channel = null;
        consumer = null;
        deliveryTag = null;
        while (true) lbl-1000:
        // 10 sources

        {
            if (RabbitMQConsumer.logger.isDebugEnabled()) {
                RabbitMQConsumer.logger.debug("Entering main loop on consumer: " + this);
            }
            if (active = RabbitMQInitialize.me.areConsumersActive()) {
                try {
                    if (channel == null || channel != null && !channel.isOpen()) {
                        consumer = null;
                        channel = this.createChannel();
                    }
                    if (consumer == null) {
                        consumer = this.createConsumer(channel);
                    }
                    if ((task = consumer.nextDelivery()) == null || task.getBody() == null) ** GOTO lbl-1000
                    try {
                        deliveryTag = task.getEnvelope().getDeliveryTag();
                        message = this.toObject(task.getBody());
                        rabbitMQMessageConsumerJob = new RabbitMQMessageConsumerJob<T>(channel, deliveryTag, this.queue(), this, message, this.retries());
                        rabbitMQMessageConsumerJob.doJob();
                    }
                    catch (Throwable t) {
                        RabbitMQConsumer.logger.error(t.getMessage(), t);
                    }
                }
                catch (Throwable t) {
                    RabbitMQConsumer.logger.error("Error creating consumer channel to RabbitMQ, retrying in a few seconds.", t);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        RabbitMQConsumer.logger.error(t.getMessage(), t);
                    }
                }
                finally {
                    if (channel == null) ** GOTO lbl-1000
                    try {
                        if (deliveryTag != null && channel.isOpen()) {
                            channel.basicAck(deliveryTag.longValue(), false);
                        }
                    }
                    catch (Throwable e) {
                        RabbitMQConsumer.logger.error("Error doing a basicAck for tag: " + deliveryTag, e);
                    }
                    try {
                        try {
                            if (channel.getConnection() != null && channel.getConnection().isOpen()) {
                                channel.getConnection().close();
                            }
                            if (channel.isOpen()) {
                                channel.close();
                            }
                            channel = null;
                        }
                        catch (Throwable t) {
                            RabbitMQConsumer.logger.error(t.getMessage(), t);
                            channel = null;
                        }
                    }
                    catch (Throwable var8_16) {
                        channel = null;
                        throw var8_16;
                    }
                }
            }
            RabbitMQConsumer.logger.warn("RabbitMQ consumers are paused and napping for 10 secs...");
            try {
                Thread.sleep(10000L);
            }
            catch (Throwable t) {
                Throwables.throwIfUnchecked((Throwable)t);
                throw new AssertionError((Object)t);
            }
        }
    }

    protected abstract String queue();

    protected String routingKey() {
        return this.queue();
    }

    protected int retries() {
        return retries;
    }

    protected T toObject(byte[] bytes) throws Exception {
        return (T)RabbitMQInitialize.me.mapper().getObject(this.getMessageType(), bytes);
    }
}

