/*
 * Decompiled with CFR 0.152.
 */
package com.github.sogyf.rabbitmq.producer;

import com.github.sogyf.rabbitmq.RabbitMQInitialize;
import com.github.sogyf.rabbitmq.producer.RabbitMQProducer;
import com.rabbitmq.client.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RabbitMQPublisher {
    private static final Logger logger = LoggerFactory.getLogger(RabbitMQPublisher.class);

    public static void publish(String queueName, Object message) {
        try {
            new RabbitMQPublisherJob(queueName, message).doJob();
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public static void publish(String queueName, String routingKey, Object message) {
        try {
            new RabbitMQPublisherJob(queueName, routingKey, message).doJob();
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    protected static class RabbitMQPublisherJob {
        private Object message;
        private String routingKey;
        private String queueName;

        public RabbitMQPublisherJob(String queueName, Object message) {
            this(queueName, queueName, message);
        }

        public RabbitMQPublisherJob(String queueName, String routingKey, Object message) {
            this.queueName = queueName;
            this.routingKey = routingKey;
            this.message = message;
        }

        public void doJob() {
            Channel channel = null;
            try {
                RabbitMQProducer producer = this.getClass().getAnnotation(RabbitMQProducer.class);
                if (producer == null && this.queueName == null) {
                    throw new RuntimeException("Please define annotation @RabbitMQProducer.");
                }
                channel = RabbitMQInitialize.me.createChannel(this.queueName, this.routingKey);
                if (channel == null) {
                    throw new RuntimeException("Error creating a communication channel with RabbitMQ. Please verify the health of your RabbitMQ node and check your configuration.");
                }
                channel.basicPublish(this.queueName, this.routingKey, RabbitMQInitialize.me.getBasicProperties(), this.getBytes());
            }
            catch (Throwable t) {
                logger.error(t.getMessage(), t);
            }
            finally {
                if (channel != null) {
                    try {
                        if (channel.getConnection() != null && channel.getConnection().isOpen()) {
                            channel.getConnection().close();
                        }
                        if (channel.isOpen()) {
                            channel.close();
                        }
                    }
                    catch (Throwable t) {
                        logger.error(t.getMessage(), t);
                    }
                    channel = null;
                }
            }
        }

        private byte[] getBytes() throws Exception {
            return RabbitMQInitialize.me.mapper().getBytes(this.message);
        }
    }
}

