/*
 * Decompiled with CFR 0.152.
 */
package com.github.sogyf.rabbitmq.util;

import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.protobuf.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface MsgMapper {
    public byte[] getBytes(Object var1) throws Exception;

    public Object getObject(Class var1, byte[] var2) throws Exception;

    public static class PROTO
    implements MsgMapper {
        private static final Logger logger = LoggerFactory.getLogger(PROTO.class);

        @Override
        public byte[] getBytes(Object object) throws Exception {
            Message proto = (Message)object;
            proto.toByteArray();
            return proto.toByteArray();
        }

        @Override
        public Object getObject(Class clazz, byte[] object) throws Exception {
            Object retobj = null;
            try {
                Class[] partypes = new Class[]{object.getClass()};
                Method meth = clazz.getMethod("parseFrom", partypes);
                Object methobj = clazz.newInstance();
                Object[] arglist = new Object[]{object};
                retobj = meth.invoke(methobj, arglist);
            }
            catch (Throwable e) {
                logger.error(e.getMessage(), e);
            }
            return retobj;
        }
    }

    public static class JSON
    implements MsgMapper {
        @Override
        public byte[] getBytes(Object object) throws Exception {
            String value = com.alibaba.fastjson.JSON.toJSONString((Object)object, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteNullBooleanAsFalse});
            return value.getBytes();
        }

        @Override
        public Object getObject(Class clazz, byte[] object) throws Exception {
            return com.alibaba.fastjson.JSON.parseObject((String)new String(object), (Class)clazz);
        }
    }

    public static class POJO
    implements MsgMapper {
        @Override
        public byte[] getBytes(Object object) throws Exception {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(object);
            out.close();
            byte[] bytes = bos.toByteArray();
            bos.close();
            return bytes;
        }

        @Override
        public Object getObject(Class clazz, byte[] object) throws Exception {
            ByteArrayInputStream bis = new ByteArrayInputStream(object);
            ObjectInputStream ois = new ObjectInputStream(bis);
            return ois.readObject();
        }
    }

    public static enum Type {
        pojo(POJO.class),
        json(JSON.class),
        proto(PROTO.class);

        private static final Logger logger;
        private Class clazz;

        private Type(Class clazz) {
            this.clazz = clazz;
        }

        public MsgMapper get() {
            try {
                return (MsgMapper)this.clazz.newInstance();
            }
            catch (Throwable t) {
                logger.error("Type Can't found!", t);
                throw new RuntimeException(t.fillInStackTrace());
            }
        }

        static {
            logger = LoggerFactory.getLogger(Type.class);
        }
    }
}

