/*
 * Decompiled with CFR 0.152.
 */
package com.kintiger.platform.framework.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FileUtil {
    private static final Logger logger = Logger.getLogger(FileUtil.class);
    private static final int BUFFER_SIZE = 16384;

    public static boolean saveFile(String path, String content) {
        boolean flag;
        block12: {
            flag = false;
            OutputStream out = null;
            try {
                try {
                    out = new BufferedOutputStream(new FileOutputStream(path), 16384);
                    out.write(content.getBytes("GBK"));
                    flag = true;
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    if (out == null) break block12;
                    try {
                        out.close();
                    }
                    catch (IOException e2) {
                        logger.error((Object)e2);
                    }
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)e);
                    }
                }
            }
        }
        return flag;
    }

    public static boolean saveAsFile(File source, File target) {
        boolean flag;
        block21: {
            flag = false;
            InputStream in = null;
            OutputStream out = null;
            try {
                try {
                    in = new BufferedInputStream(new FileInputStream(source), 16384);
                    out = new BufferedOutputStream(new FileOutputStream(target), 16384);
                    byte[] buffer = new byte[16384];
                    while (in.read(buffer) > 0) {
                        out.write(buffer);
                    }
                    flag = true;
                }
                catch (Exception e) {
                    logger.error((Object)"\u6587\u4ef6\u53e6\u5b58\u4e3a\u5931\u8d25\uff01", (Throwable)e);
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e2) {
                            logger.error((Object)e2);
                        }
                    }
                    if (out == null) break block21;
                    try {
                        out.close();
                    }
                    catch (IOException e3) {
                        logger.error((Object)e3);
                    }
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)e);
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)e);
                    }
                }
            }
        }
        return flag;
    }

    public static String readFile(String filePath) {
        StringBuffer fileContent;
        block24: {
            fileContent = new StringBuffer();
            InputStreamReader isr = null;
            BufferedReader br = null;
            try {
                try {
                    isr = new InputStreamReader((InputStream)new FileInputStream(filePath), "GBK");
                    br = new BufferedReader(isr);
                    String tempStr = br.readLine();
                    while (tempStr != null) {
                        fileContent.append(tempStr);
                        tempStr = br.readLine();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    if (isr != null) {
                        try {
                            isr.close();
                        }
                        catch (IOException e2) {
                            logger.error((Object)e2);
                        }
                    }
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e3) {
                            logger.error((Object)e3);
                        }
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (isr != null) {
                    try {
                        isr.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)e);
                    }
                }
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)e);
                    }
                }
                throw throwable;
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException e) {
                    logger.error((Object)e);
                }
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    logger.error((Object)e);
                }
            }
        }
        return fileContent.toString();
    }

    public static String getFileExtention(String fileName) {
        if (StringUtils.isEmpty((String)fileName)) {
            return null;
        }
        return fileName.substring(fileName.lastIndexOf("."));
    }

    public static String getFileName(String fileName) {
        if (StringUtils.isEmpty((String)fileName)) {
            return null;
        }
        if (fileName.lastIndexOf(".") == -1) {
            return fileName;
        }
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    public static String getFileSuffix(String fileName) {
        if (StringUtils.isEmpty((String)fileName)) {
            return null;
        }
        if (fileName.lastIndexOf(".") == -1) {
            return "";
        }
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }
}

