/*
 * Decompiled with CFR 0.152.
 */
package com.kintiger.platform.framework.util;

import com.kintiger.platform.framework.annotations.JsonResult;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.util.OgnlUtil;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.sql.Date;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONResult
implements Result {
    private String APPLICATION_JSON = "application/json";
    protected String charset;
    private static final long serialVersionUID = -4293657447642850227L;

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void execute(ActionInvocation invocation) throws Exception {
        HttpServletResponse response = ServletActionContext.getResponse();
        StringBuffer contentType = new StringBuffer();
        contentType.append(this.APPLICATION_JSON);
        contentType.append(this.isLegalCharSet() ? "; charset=" + this.charset : "; charset=GBK");
        response.setContentType(contentType.toString());
        Object action = invocation.getAction();
        Method method = null;
        try {
            method = action.getClass().getDeclaredMethod(invocation.getProxy().getMethod(), new Class[0]);
        }
        catch (Exception e) {
            method = action.getClass().getDeclaredMethod("do" + invocation.getProxy().getMethod().substring(0, 1).toUpperCase() + invocation.getProxy().getMethod().substring(1), new Class[0]);
        }
        StringBuffer json = new StringBuffer();
        JsonResult result = method.getAnnotation(JsonResult.class);
        if (result != null) {
            Field field = action.getClass().getDeclaredField(result.field());
            field.setAccessible(true);
            Object obj = this.transToJSONObject(field.getType(), field.get(action), result);
            if (obj != null) {
                if (String.class.isAssignableFrom(obj.getClass())) {
                    obj = JSONObject.quote((String)((String)obj));
                }
                json.append(obj);
            }
            String fieldName = result.total();
            String type = result.type();
            if (!"".equals(fieldName)) {
                Field total = action.getClass().getDeclaredField(result.total());
                total.setAccessible(true);
                json.insert(0, "\"rows\":");
                json.insert(0, "{\"total\":" + total.get(action) + ",");
                json.append("}");
            }
            if (!"".equals(type)) {
                StringBuffer typesb = new StringBuffer();
                typesb.append("{").append(type).append(":true,data:").append(json).append("}");
                json = typesb;
            }
        }
        PrintWriter writer = null;
        try {
            writer = response.getWriter();
            writer.write(json.toString());
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
    }

    private Object transToJSONObject(Class<?> cls, Object value) throws Exception {
        return this.transToJSONObject(cls, value, null);
    }

    private Object transToJSONObject(Class<?> cls, Object value, JsonResult tojson) throws Exception {
        Object json = null;
        if (value != null) {
            if (Collection.class.isAssignableFrom(cls)) {
                Iterator iter = ((Collection)value).iterator();
                JSONArray array = new JSONArray();
                while (iter.hasNext()) {
                    Object element = iter.next();
                    if (element == null) continue;
                    array.put(this.transToJSONObject(element.getClass(), element, tojson));
                }
                json = array;
            } else if (cls.isArray()) {
                JSONArray array = new JSONArray();
                int length = Array.getLength(value);
                int i = 0;
                while (i < length) {
                    Object element = Array.get(value, i);
                    if (element != null) {
                        array.put(this.transToJSONObject(element.getClass(), element, tojson));
                    }
                    ++i;
                }
                json = array;
            } else if (Map.class.isAssignableFrom(cls)) {
                Iterator iter = ((Map)value).entrySet().iterator();
                JSONObject object = new JSONObject();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    Object v = entry.getValue();
                    if (v == null) continue;
                    object.put(entry.getKey().toString(), this.transToJSONObject(v.getClass(), v, tojson));
                }
                json = object;
            } else if (cls.isPrimitive() || Boolean.class == cls || CharSequence.class.isAssignableFrom(cls) || Number.class.isAssignableFrom(cls)) {
                json = cls == Boolean.TYPE || cls == Integer.TYPE || cls == Float.TYPE || cls == Double.TYPE || cls == Long.TYPE || cls == Short.TYPE || cls == Byte.TYPE || cls.isAssignableFrom(Number.class) ? value : value.toString();
            } else if (java.util.Date.class.isAssignableFrom(cls) || Date.class.isAssignableFrom(cls)) {
                json = value.toString();
            } else {
                HashMap map = OgnlUtil.getBeanMap((Object)value);
                JSONObject object = new JSONObject();
                if (map != null) {
                    if (tojson != null) {
                        String[] include = tojson.include();
                        String[] exclude = tojson.exclude();
                        if (include.length > 0) {
                            HashMap elements = new HashMap();
                            int i = 0;
                            while (i < include.length) {
                                elements.put(include[i], map.get(include[i]));
                                ++i;
                            }
                            map = elements;
                        } else if (exclude.length > 0) {
                            int i = 0;
                            while (i < exclude.length) {
                                map.remove(exclude[i]);
                                ++i;
                            }
                        }
                    }
                    for (Map.Entry element : map.entrySet()) {
                        Object v = element.getValue();
                        if (v == null) continue;
                        object.put((String)element.getKey(), this.transToJSONObject(v.getClass(), v));
                    }
                    json = object;
                }
            }
        }
        return json == null ? "" : json;
    }

    protected boolean isLegalCharSet() {
        Charset tmp = null;
        if (this.charset != null) {
            tmp = Charset.isSupported(this.charset) ? Charset.forName(this.charset) : null;
        }
        return tmp != null;
    }
}

