/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.sdk.plugin.desktop.category.internal;

import com.businessobjects.sdk.plugin.desktop.category.ICategory;
import com.businessobjects.sdk.plugin.desktop.personalcategory.internal.PersonalCategory;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.ObjectID_Ex;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.ICategoryContent;
import com.crystaldecisions.sdk.occa.infostore.IContainer;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.IInfoStore;
import com.crystaldecisions.sdk.occa.infostore.ISortDimension;
import com.crystaldecisions.sdk.occa.infostore.SearchPattern;
import com.crystaldecisions.sdk.occa.infostore.SortType;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObjectEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoObjectEvent;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoObjectEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoStore;
import com.crystaldecisions.sdk.occa.infostore.internal.InfoStoreFactory;
import com.crystaldecisions.sdk.occa.infostore.internal.InternalInfoStoreFactory;
import com.crystaldecisions.sdk.occa.infostore.internal.ObjectRelatives;
import com.crystaldecisions.sdk.occa.infostore.internal.QuerySettings;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.IProperty;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.Set;

public class Category
extends AbstractInfoObject
implements ICategory,
IContainer {
    private Set m_documentIDSet;

    public IInfoObjectEventListener getInfoObjectEventListener(int type) {
        final IInfoObjectEventListener superListener = super.getInfoObjectEventListener(type);
        if (type == 2) {
            return new AbstractInfoObjectEventListener(){

                protected void processEvent(IInfoObjectEvent event) throws SDKException {
                    if (Category.this.isNew()) {
                        Category.this.getDocuments();
                    }
                }

                protected IInfoObjectEventListener getSuperEventListener() {
                    return superListener;
                }
            };
        }
        return superListener;
    }

    public void initialize(ISecuritySession session, IInfoObjects collection, ObjectID_Ex id, short type) throws SDKException {
        super.initialize(session, collection, id, type);
        this.setParentID(45);
    }

    public Set getDocuments() throws SDKException {
        if (this.m_documentIDSet == null) {
            this.m_documentIDSet = new ObjectRelatives();
            ((ObjectRelatives)this.m_documentIDSet).initialize((Object)PropertyIDs.SI_DOCUMENTS, this.properties(), false, this.isNew());
        }
        return this.m_documentIDSet;
    }

    public String[] getPath() throws SDKException {
        int numFolders;
        IProperty prop = this.getProperty(PropertyIDs.SI_PATH);
        if (prop == null) {
            throw new SDKException.PropertyNotFound(PropertyIDs.SI_PATH);
        }
        IProperties p = (IProperties)prop.getValue();
        if (p == null) {
            return null;
        }
        Integer nFolders = (Integer)p.getProperty(PropertyIDs.SI_NUM_FOLDERS).getValue();
        if (nFolders == null || (numFolders = nFolders.intValue()) <= 0) {
            return new String[0];
        }
        String[] paths = new String[numFolders];
        int baseIndex = PropertyIDs.SI_FOLDER_NAME0 + 1;
        for (int i = 0; i < numFolders; ++i) {
            paths[i] = (String)p.getProperty(new Integer(baseIndex + i)).getValue();
        }
        return paths;
    }

    public IInfoObjects getChildren() throws SDKException {
        return this.getChildren(1, null, null);
    }

    public IInfoObjects getChildren(int propertySet, SearchPattern searchPattern, SortType sortType) throws SDKException {
        if (propertySet != 7 && propertySet != 1 && propertySet != 4 && propertySet != 2) {
            throw new SDKException.InvalidArg("propertySet");
        }
        SearchPattern mySearch = new SearchPattern(searchPattern);
        SortType mySort = new SortType(sortType);
        if (!mySort.contains(ISortDimension.NAME_ASC) && !mySort.contains(ISortDimension.NAME_DESC)) {
            mySort.addSortDimension(ISortDimension.NAME_ASC);
        }
        mySearch.setParentID(this.getID());
        String subCategoriesWhereClause = QuerySettings.generateWhereClause(mySearch);
        String contentsWhereClause = this.getDocumentsWhereClause(mySearch);
        StringBuffer whereClause = new StringBuffer("((");
        whereClause.append(subCategoriesWhereClause);
        whereClause.append(") OR (");
        whereClause.append(contentsWhereClause);
        whereClause.append("))");
        IInternalInfoStore is = (IInternalInfoStore)InternalInfoStoreFactory.getFactory().makeOCCA("", this.getSession());
        QuerySettings query = new QuerySettings(is, "CI_INFOOBJECTS", QuerySettings.ToFields(propertySet), whereClause.toString(), QuerySettings.getOrderClause(mySort));
        IInfoObjects col = query.executeQuery();
        return col;
    }

    public IInfoObject add(String kind) throws SDKException {
        IInfoStore is = (IInfoStore)InfoStoreFactory.getFactory().makeOCCA("", this.getSession());
        IInfoObjects objs = is.newInfoObjectCollection();
        IInfoObject obj = objs.add(is.getPluginMgr().getPluginInfo(kind));
        if (this.getKind().equals("Category") && kind.equals("PersonalCategory")) {
            throw new SDKException.InvalidArg(kind);
        }
        if (this.getKind().equals("PersonalCategory") && kind.equals("Category")) {
            throw new SDKException.InvalidArg(kind);
        }
        if (kind.equals("Category") || kind.equals("PersonalCategory")) {
            obj.setParentID(this.getID());
        } else {
            if (!(obj instanceof ICategoryContent)) {
                throw new SDKException.InvalidArg(kind);
            }
            ICategoryContent content = (ICategoryContent)((Object)obj);
            Set categories = this instanceof PersonalCategory ? content.getPersonalCategories() : content.getCorporateCategories();
            categories.add(new Integer(this.getID()));
        }
        return obj;
    }

    public IInfoObjects getContents() throws SDKException {
        return this.getContents(1, null, null);
    }

    public IInfoObjects getContents(int propertySet, SearchPattern searchPattern, SortType sortType) throws SDKException {
        if (propertySet != 7 && propertySet != 1 && propertySet != 4 && propertySet != 2) {
            throw new SDKException.InvalidArg("propertySet");
        }
        SortType mySort = new SortType(sortType);
        if (!mySort.contains(ISortDimension.NAME_ASC) && !mySort.contains(ISortDimension.NAME_DESC)) {
            mySort.addSortDimension(ISortDimension.NAME_ASC);
        }
        String mySearch = this.getDocumentsWhereClause(searchPattern);
        IInternalInfoStore is = (IInternalInfoStore)InternalInfoStoreFactory.getFactory().makeOCCA("", this.getSession());
        if (mySearch.length() == 0) {
            return is.newInfoObjectCollection();
        }
        QuerySettings query = new QuerySettings(is, "CI_INFOOBJECTS", QuerySettings.ToFields(propertySet), mySearch, QuerySettings.getOrderClause(mySort));
        return query.executeQuery();
    }

    private String getDocumentsWhereClause(SearchPattern searchPattern) throws SDKException {
        SearchPattern mySearchPattern = new SearchPattern(searchPattern);
        mySearchPattern.setParentID(-1);
        String searchPatternStr = QuerySettings.generateWhereClause(mySearchPattern);
        String relationSearchStr = "children(\"SI_NAME='Category-Document'\", \"SI_ID=";
        relationSearchStr = relationSearchStr + this.getID();
        relationSearchStr = relationSearchStr + "\")";
        if (searchPatternStr.length() == 0) {
            return relationSearchStr;
        }
        StringBuffer whereClause = new StringBuffer("((");
        whereClause.append(searchPatternStr);
        whereClause.append(") AND ");
        whereClause.append(relationSearchStr);
        whereClause.append(")");
        return whereClause.toString();
    }
}

