/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.sdk.plugin.desktop.common.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.sdk.plugin.desktop.common.IConfigProperties;
import com.businessobjects.sdk.plugin.desktop.common.IConfigProperty;
import com.businessobjects.sdk.plugin.desktop.common.internal.ConfigProperty;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.properties.internal.AbstractSDKSet;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.ArrayList;
import java.util.Iterator;

public class ConfigProperties
extends AbstractSDKSet
implements IConfigProperties {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.plugin.desktop.common.internal.ConfigProperties");

    public ConfigProperties(PropertyBag bag) {
        super(bag, PropertyIDs.SI_TOTAL, PropertyIDs.SI_NAME, false);
    }

    public String[] getPropNames() {
        try {
            ArrayList<String> keys = new ArrayList<String>();
            Iterator it = this.iterator();
            while (it.hasNext()) {
                IConfigProperty obj = (IConfigProperty)it.next();
                String name = obj.getName();
                keys.add(name);
            }
            return keys.toArray(new String[keys.size()]);
        }
        catch (Throwable e) {
            return new String[0];
        }
    }

    public IConfigProperty addProp(String name) {
        IConfigProperty prop = this.getProp(name);
        if (prop == null) {
            prop = new ConfigProperty(new PropertyBag());
            prop.setName(name);
            this.addNewObjectToCollection(prop);
        }
        return prop;
    }

    public boolean addProp(ConfigProperty src) {
        return this.addNewObjectToCollection(src);
    }

    protected Object createCollectionObject(int index) {
        return new ConfigProperty((PropertyBag)this.m_bag.get(index));
    }

    public IConfigProperty getProp(String name) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            IConfigProperty prop = (IConfigProperty)it.next();
            String propName = prop.getName();
            if (!propName.equals(name)) continue;
            return prop;
        }
        return null;
    }

    protected void reset() throws SDKException {
        String[] propNames = null;
        ConfigProperties props = null;
        ConfigProperty prop = null;
        ArrayList<Object> configPropsArr = new ArrayList<Object>();
        configPropsArr.add(this);
        while (configPropsArr.size() > 0) {
            props = (ConfigProperties)configPropsArr.remove(0);
            propNames = props.getPropNames();
            for (int i = 0; i < propNames.length; ++i) {
                prop = (ConfigProperty)props.getProp(propNames[i]);
                if (prop.isFinal()) continue;
                Object value = prop.getValue();
                if (value instanceof ConfigProperties) {
                    configPropsArr.add(value);
                    continue;
                }
                Object val = prop.getDefaultValue();
                if (val != null) {
                    prop.setValue(val);
                    continue;
                }
                LOG.error((Object)("reset(): SI_DEFAULT_VALUE missing from ConfigProperty=" + prop.getName()));
            }
        }
    }
}

