/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.sdk.plugin.desktop.customrole.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.sdk.plugin.desktop.common.internal.StringProps;
import com.businessobjects.sdk.plugin.desktop.customrole.ICustomRole;
import com.businessobjects.sdk.plugin.desktop.customrole.IRoleRights;
import com.businessobjects.sdk.plugin.desktop.customrole.internal.RoleRights;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.ObjectID_Ex;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.IPluginBasedRightIDs;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObjectEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoObjectEvent;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoObjectEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.ObjectRelatives;
import com.crystaldecisions.sdk.occa.infostore.internal.PluginBasedRightIDs;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginMgr;
import com.crystaldecisions.sdk.occa.security.ISecCacheControllerAdmin;
import com.crystaldecisions.sdk.occa.security.ISecRightsAdmin;
import com.crystaldecisions.sdk.occa.security.ISecurityResult;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.occamgr.internal.OCCAMgrFactory;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CustomRole
extends AbstractInfoObject
implements ICustomRole {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.businessobjects.sdk.plugin.desktop.customrole.internal.CustomRole");
    private RoleRights m_roleRights = null;
    private StringProps m_intendedPlugins = null;
    private Set m_assignedObjects = null;
    private Map m_knownRights;
    private Map m_uniqueRightIDs;
    private static final Map s_cachedKnownRights = new HashMap();
    private static final int CMS_ID = 4;

    public IInfoObjectEventListener getInfoObjectEventListener(int type) {
        final IInfoObjectEventListener superListener = super.getInfoObjectEventListener(type);
        if (type == 2) {
            return new AbstractInfoObjectEventListener(){

                protected void processEvent(IInfoObjectEvent event) throws SDKException {
                    Property rightsProp;
                    if (CustomRole.this.m_roleRights != null || null != (rightsProp = (Property)CustomRole.this.properties().getProperty(PropertyIDs.SI_ROLE_RIGHTS)) && rightsProp.isDirty()) {
                        IRoleRights rights = CustomRole.this.getRoleRights();
                        HashSet rightSet = new HashSet(rights.size());
                        Iterator iter = rights.iterator();
                        while (iter.hasNext()) {
                            Object roleRight = iter.next();
                            if (rightSet.add(roleRight)) continue;
                            throw new SDKException.DuplicateEntry();
                        }
                    }
                }

                protected IInfoObjectEventListener getSuperEventListener() {
                    return superListener;
                }
            };
        }
        return superListener;
    }

    public void initialize(ISecuritySession session, IInfoObjects collection, ObjectID_Ex id, short type) throws SDKException {
        super.initialize(session, collection, id, type);
        this.setProperty((Object)PropertyIDs.SI_SYSTEM_OBJECT, Boolean.TRUE);
        this.setProperty((Object)PropertyIDs.SI_PARENTID, 57);
        ((PropertyBag)this.properties()).addArray((Object)PropertyIDs.SI_ROLE_RIGHTS);
    }

    public synchronized IRoleRights getRoleRights() {
        if (this.m_roleRights == null) {
            IPluginMgr pluginMgr;
            PropertyBag roleRightsBag;
            block8: {
                block7: {
                    PropertyBag propertyBag = (PropertyBag)this.properties();
                    roleRightsBag = propertyBag.getPropertyBag((Object)PropertyIDs.SI_ROLE_RIGHTS);
                    if (roleRightsBag == null) {
                        Property prop = propertyBag.addArray((Object)PropertyIDs.SI_ROLE_RIGHTS);
                        roleRightsBag = prop.getPropertyBag();
                    }
                    pluginMgr = null;
                    if (this.getSession() != null) {
                        try {
                            pluginMgr = (IPluginMgr)OCCAMgrFactory.getOCCAMgr().getOCCAFactory("PluginDistribution").makeOCCA(this.getSession().getAPSName(), this.getSession());
                        }
                        catch (SDKException e) {
                            if (!LOG.isErrorEnabled()) break block7;
                            LOG.error((Object)"CustomRole.getRoleRight - error creating the plugin manager", (Throwable)((Object)e));
                        }
                    }
                }
                try {
                    this.getKnownRights();
                }
                catch (SDKException e) {
                    if (!LOG.isDebugEnabled()) break block8;
                    LOG.debug((Object)"CustomRole.getRoleRights: failed to get known rights", (Throwable)((Object)e));
                }
            }
            this.m_roleRights = new RoleRights(pluginMgr, roleRightsBag, this.m_knownRights, this.m_uniqueRightIDs == null ? null : this.m_uniqueRightIDs.values());
        }
        return this.m_roleRights;
    }

    public synchronized Set getIntendedPluginKinds() {
        if (this.m_intendedPlugins == null) {
            Property intendedPlugins = (Property)this.properties().getProperty(PropertyIDs.SI_INTENDED_PLUGINS);
            if (intendedPlugins == null) {
                intendedPlugins = (Property)this.properties().add(PropertyIDs.SI_INTENDED_PLUGINS, null, 0x8000000);
            }
            this.m_intendedPlugins = new StringProps(intendedPlugins.getPropertyBag());
        }
        return this.m_intendedPlugins;
    }

    public synchronized Set getAssignedObjects() throws SDKException {
        if (this.m_assignedObjects == null) {
            this.m_assignedObjects = new ObjectRelatives();
            ((ObjectRelatives)this.m_assignedObjects).initialize(PropertyIDs.SI_OBJECTS_ASSIGNED_ROLE, PropertyIDs.idToName(PropertyIDs.SI_OBJECTS_ASSIGNED_ROLE), this.properties(), false, this.isNew());
        }
        return this.m_assignedObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getKnownRights() throws SDKException {
        if (this.m_knownRights == null || this.m_uniqueRightIDs == null) {
            Map map = s_cachedKnownRights;
            synchronized (map) {
                IPluginBasedRightIDs knownRights = (IPluginBasedRightIDs)s_cachedKnownRights.get(this.getSession().getClusterName());
                if (knownRights == null) {
                    ISecCacheControllerAdmin cache = this.getSession().getSecCacheAdminEx();
                    cache.batch();
                    try {
                        cache.cacheKnownRightsByPlugin(4);
                        cache.commit();
                    }
                    catch (SDKException e) {
                        cache.rollback();
                        throw e;
                    }
                    catch (Throwable e) {
                        cache.rollback();
                        SDKException.ExceptionWrapper sdke = new SDKException.ExceptionWrapper(e);
                        throw sdke;
                    }
                    ISecRightsAdmin rightsAdmin = this.getSession().getRightsAdminEx();
                    ISecurityResult result = rightsAdmin.getKnownRightsByPlugin(4);
                    knownRights = (IPluginBasedRightIDs)result.getResult();
                    s_cachedKnownRights.put(this.getSession().getClusterName(), knownRights);
                }
                this.m_knownRights = knownRights.getPluginRights();
                this.m_uniqueRightIDs = ((PluginBasedRightIDs)knownRights).getUniqueRights();
            }
        }
    }
}

