/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.sdk.plugin.desktop.customrole.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.sdk.plugin.desktop.customrole.IRoleRight;
import com.businessobjects.sdk.plugin.desktop.customrole.IRoleRights;
import com.businessobjects.sdk.plugin.desktop.customrole.internal.RoleRight;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IRightID;
import com.crystaldecisions.sdk.occa.infostore.IRightsView;
import com.crystaldecisions.sdk.occa.infostore.RightDescriptor;
import com.crystaldecisions.sdk.occa.infostore.RightsFilterCriteria;
import com.crystaldecisions.sdk.occa.infostore.RightsSortCriteria;
import com.crystaldecisions.sdk.occa.infostore.internal.IPersistRightID;
import com.crystaldecisions.sdk.occa.infostore.internal.RightsFilterHelper;
import com.crystaldecisions.sdk.occa.infostore.internal.SecurityRight2Comparator;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginMgr;
import com.crystaldecisions.sdk.occa.security.internal.SecurityValidator;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.internal.AbstractSDKSet;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RoleRights
extends AbstractSDKSet
implements IRoleRights,
IRightsView {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.businessobjects.sdk.plugin.desktop.customrole.internal.RoleRights");
    public static final boolean DEFAULT_BOOLVAL = true;
    private IPluginMgr m_pluginMgr;
    private Map m_persistRights;
    private HashSet m_uniqueRightIDs;

    public RoleRights(IPluginMgr pluginMgr, PropertyBag bag, Map pluginRightsMap, Collection uniqueRightIDs) {
        super(bag, PropertyIDs.SI_TOTAL, false);
        this.m_pluginMgr = pluginMgr;
        HashSet hashSet = this.m_uniqueRightIDs = uniqueRightIDs == null ? new HashSet() : new HashSet(uniqueRightIDs);
        if (pluginRightsMap != null) {
            this.m_persistRights = new HashMap(pluginRightsMap.size());
            Iterator iter = pluginRightsMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String progID = (String)entry.getKey();
                Set pluginRights = (Set)entry.getValue();
                HashMap<Integer, IRightID> thisPluginRightsMap = new HashMap<Integer, IRightID>(pluginRights.size());
                Iterator iter1 = pluginRights.iterator();
                while (iter1.hasNext()) {
                    IRightID rightID = (IRightID)iter1.next();
                    thisPluginRightsMap.put(new Integer(rightID.getID()), rightID);
                }
                this.m_persistRights.put(progID, thisPluginRightsMap);
            }
        } else {
            this.m_persistRights = new HashMap();
        }
    }

    public IRoleRight addRoleRight(RightDescriptor right, boolean granted) throws SDKException {
        RoleRight roleRight = new RoleRight(this.m_pluginMgr, right.id, right.kind, right.isOwner, right.applicableObjectType, right.scope, granted, true);
        Map relevantPersistRights = (Map)this.m_persistRights.get(RoleRight.getRealProgID(this.m_pluginMgr, roleRight.getCategoryType()));
        roleRight.makePersistRightID(relevantPersistRights);
        if (this.addNewObjectToCollection(roleRight)) {
            return roleRight;
        }
        throw new SDKException.DuplicateEntry();
    }

    public IRoleRight getRoleRight(RightDescriptor right) throws SDKException {
        Iterator iter = super.iterator();
        while (iter.hasNext()) {
            RoleRight rr = (RoleRight)iter.next();
            if (rr.getID() != right.id || !SecurityValidator.getRealKind(this.m_pluginMgr, right.kind).equalsIgnoreCase(rr.getKind()) || rr.getOwnerRight() != right.isOwner || !RoleRight.getRealApplicableKind(this.m_pluginMgr, right.applicableObjectType).equalsIgnoreCase(rr.getApplicableKind()) || !rr.getScope().equalsIgnoreCase(SecurityValidator.validateScope(right.scope))) continue;
            return rr;
        }
        return null;
    }

    public boolean removeRoleRight(RightDescriptor right) throws SDKException {
        IRoleRight roleRight = this.getRoleRight(right);
        if (roleRight != null) {
            return super.remove(roleRight);
        }
        return false;
    }

    protected Object createCollectionObject(int index) {
        try {
            RoleRight roleRight = new RoleRight(this.m_pluginMgr, (IProperties)this.m_bag.get(index));
            Map relevantPersistRights = (Map)this.m_persistRights.get(RoleRight.getRealProgID(this.m_pluginMgr, roleRight.getCategoryType()));
            roleRight.makePersistRightID(relevantPersistRights);
            return roleRight;
        }
        catch (SDKException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"unable to get create custom role rights", (Throwable)((Object)e));
            }
            return null;
        }
    }

    public List getView(RightsFilterCriteria filterCriteria, RightsSortCriteria sortCriteria) {
        ArrayList view = new ArrayList();
        this.filterSpecified(filterCriteria, view);
        if (RightsFilterHelper.isFilterUnspecifiedRights(filterCriteria)) {
            if (filterCriteria.getHelper().isUnspecifiedRightsIncludeTypeSpecific()) {
                this.filterUnspecifiedAll(filterCriteria, view);
            } else {
                this.filterUnspecifiedUnique(filterCriteria, view);
            }
        }
        if (sortCriteria != null) {
            Collections.sort(view, new SecurityRight2Comparator(sortCriteria));
        }
        return Collections.unmodifiableList(view);
    }

    private void filterSpecified(RightsFilterCriteria filterCriteria, List view) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            RoleRight right = (RoleRight)iter.next();
            if (right == null || !RightsFilterHelper.match(right, filterCriteria)) continue;
            view.add(right);
        }
    }

    private void filterUnspecifiedAll(RightsFilterCriteria filterCriteria, List view) {
        LOG.assertNotNull((Object)this.m_persistRights);
        Map unspecifiedRights = this.m_persistRights;
        if (unspecifiedRights != null) {
            Iterator iter = unspecifiedRights.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String progID = (String)entry.getKey();
                Map pluginRights = (Map)entry.getValue();
                Iterator iter1 = pluginRights.values().iterator();
                while (iter1.hasNext()) {
                    IRightID right = (IRightID)iter1.next();
                    try {
                        String actualKind = right.getRightPluginType() > 0 ? "Any" : progID;
                        RoleRight unspecifiedRight = new RoleRight(this.m_pluginMgr, right.getBaseID(), right.getRightPluginKind(), right.isOwner(), actualKind, "", false, false);
                        unspecifiedRight.setPersistRight((IPersistRightID)right);
                        RightDescriptor desc = unspecifiedRight.getRightDescriptor();
                        RightDescriptor thisDesc = new RightDescriptor(desc);
                        thisDesc.scope = "this";
                        RightDescriptor descendantsDesc = new RightDescriptor(desc);
                        descendantsDesc.scope = "descendants";
                        if (this.getRoleRight(thisDesc) != null || this.getRoleRight(descendantsDesc) != null || !RightsFilterHelper.match(unspecifiedRight, filterCriteria)) continue;
                        view.add(unspecifiedRight);
                    }
                    catch (SDKException e) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Failed to add unspecified right " + right), (Throwable)((Object)e));
                    }
                }
            }
        }
    }

    private void filterUnspecifiedUnique(RightsFilterCriteria filterCriteria, List view) {
        LOG.assertNotNull((Object)this.m_uniqueRightIDs);
        HashSet unspecifiedRights = this.m_uniqueRightIDs;
        if (unspecifiedRights != null) {
            IRightID right;
            HashSet<Integer> specifiedRights = new HashSet<Integer>(this.size());
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                right = (RoleRight)iter.next();
                if (!((RoleRight)right).isSpecified()) continue;
                specifiedRights.add(new Integer(((RoleRight)right).getID()));
            }
            iter = unspecifiedRights.iterator();
            while (iter.hasNext()) {
                right = (IRightID)iter.next();
                if (specifiedRights.contains(new Integer(right.getID()))) continue;
                try {
                    RoleRight unspecifiedRight = new RoleRight(this.m_pluginMgr, right.getBaseID(), right.getRightPluginKind(), right.isOwner(), "Any", "", false, false);
                    unspecifiedRight.setPersistRight((IPersistRightID)right);
                    if (!RightsFilterHelper.match(unspecifiedRight, filterCriteria)) continue;
                    view.add(unspecifiedRight);
                }
                catch (SDKException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Failed to add unspecified right " + right), (Throwable)((Object)e));
                }
            }
        }
    }
}

