/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.sdk.plugin.desktop.federation.internal;

import com.businessobjects.sdk.plugin.desktop.federation.IFederation;
import com.businessobjects.sdk.plugin.desktop.federation.IFederationRules;
import com.businessobjects.sdk.plugin.desktop.federation.ISupportedDependencies;
import com.businessobjects.sdk.plugin.desktop.federation.internal.FederationRules;
import com.businessobjects.sdk.plugin.desktop.federation.internal.SupportedDependencies;
import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObject;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

class Federation
extends AbstractInfoObject
implements IFederation {
    SupportedDependencies m_deps;
    FederationRules m_federationRules;
    Collection m_nonReplicablePlugins;
    Map m_stringTable;

    Federation() {
    }

    public ISupportedDependencies getSupportedDependencies() throws SDKException {
        if (this.m_deps == null) {
            PropertyBag supportedBag = this.getPropertyBag(PropertyIDs.SI_SUPPORTED_DEPENDENCIES);
            this.m_deps = new SupportedDependencies(supportedBag, this);
        }
        return this.m_deps;
    }

    public IFederationRules getFederationRules() throws SDKException {
        if (this.m_federationRules == null) {
            PropertyBag rulesBag = this.getPropertyBag(PropertyIDs.SI_DEFAULT_OBJECTS);
            this.m_federationRules = new FederationRules(rulesBag, this);
        }
        return this.m_federationRules;
    }

    public Collection getNonReplicablePlugins() throws SDKException {
        if (this.m_nonReplicablePlugins == null) {
            PropertyBag nonReplicableBag = ((PropertyBag)this.properties()).getPropertyBag((Object)PropertyIDs.SI_NON_REPLICABLE_PLUGINS);
            if (nonReplicableBag == null) {
                return new ArrayList();
            }
            this.m_nonReplicablePlugins = new PropertyArrayHelper(nonReplicableBag, PropertyIDs.SI_TOTAL);
        }
        return this.m_nonReplicablePlugins;
    }

    private PropertyBag getPropertyBag(Integer prop) throws SDKException {
        PropertyBag mainBag = (PropertyBag)this.properties();
        PropertyBag propBag = mainBag.getPropertyBag((Object)prop);
        if (propBag == null) {
            throw new SDKException.PropertyNotFound(prop);
        }
        return propBag;
    }

    private Map buildStringMap(PropertyBag stringTable) {
        HashMap<Integer, PropertyBag> tempTable = new HashMap<Integer, PropertyBag>();
        int total = stringTable.getInt((Object)PropertyIDs.SI_TOTAL);
        for (int i = 0; i < total; ++i) {
            PropertyBag entryBag = stringTable.getPropertyBag((Object)Integer.toString(i + 1));
            if (entryBag == null) continue;
            int id = entryBag.getInt((Object)PropertyIDs.SI_ID);
            PropertyBag descriptionBag = entryBag.getPropertyBag((Object)PropertyIDs.SI_ML_DESCRIPTION);
            if (id == 0 || descriptionBag == null) continue;
            tempTable.put(new Integer(id), descriptionBag);
        }
        return tempTable;
    }

    String lookupString(int stringId, Locale locale) throws SDKException {
        Integer stringID;
        PropertyBag stringBag;
        if (this.m_stringTable == null) {
            PropertyBag mainBag = (PropertyBag)this.properties();
            PropertyBag stringTable = mainBag.getPropertyBag((Object)PropertyIDs.SI_STRING_TABLE);
            if (stringTable == null) {
                throw new SDKException.PropertyNotFound(PropertyIDs.SI_STRING_TABLE);
            }
            Map tempTable = this.buildStringMap(stringTable);
            if (tempTable != null && tempTable.size() > 0) {
                this.m_stringTable = tempTable;
            }
        }
        if (this.m_stringTable != null && (stringBag = (PropertyBag)this.m_stringTable.get(stringID = new Integer(stringId))) != null) {
            try {
                String rval = stringBag.getString(locale);
                return rval;
            }
            catch (Exception e) {
                throw new SDKException.PropertyNotFound(locale.toString());
            }
        }
        throw new SDKException.PropertyNotFound("SI_STRING_TABLE.SI_ID=" + stringId);
    }
}

