/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.sdk.plugin.desktop.install.internal;

import com.businessobjects.sdk.plugin.desktop.common.IInstalledObjects;
import com.businessobjects.sdk.plugin.desktop.common.INameValuePairs;
import com.businessobjects.sdk.plugin.desktop.common.internal.InstalledObjects;
import com.businessobjects.sdk.plugin.desktop.common.internal.NameValuePairs;
import com.businessobjects.sdk.plugin.desktop.install.IInstall;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.ObjectID_Ex;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObjectEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoObjectEvent;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoObjectEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoStore;
import com.crystaldecisions.sdk.occa.infostore.internal.ObjectRelatives;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class Install
extends AbstractInfoObject
implements IInstall {
    private InstalledObjects m_installedServices;
    private InstalledObjects m_installedContainers;
    private Set m_entNodeSet;
    private NameValuePairs m_placeholders;
    private Set m_objRels = new HashSet();

    Install() {
    }

    public void initialize(ISecuritySession session, IInfoObjects collection, ObjectID_Ex id, short type) throws SDKException {
        super.initialize(session, collection, id, type);
        this.setProperty((Object)PropertyIDs.SI_SYSTEM_OBJECT, Boolean.TRUE);
        this.setProperty((Object)PropertyIDs.SI_PARENTID, 53);
    }

    public IInfoObjectEventListener getInfoObjectEventListener(int type) {
        final IInfoObjectEventListener superListener = super.getInfoObjectEventListener(type);
        if (type == 2) {
            return new AbstractInfoObjectEventListener(){

                protected void processEvent(IInfoObjectEvent event) throws SDKException {
                    if (!Install.this.isNew()) {
                        Install.this.processObjectRelatives(Install.this.m_objRels);
                        IInternalInfoStore infoStore = event.getInfoStore();
                        Install.this.propagateInstalledServiceRemoval(infoStore);
                        Install.this.propagateInstalledContainerRemoval(infoStore);
                    }
                }

                protected IInfoObjectEventListener getSuperEventListener() {
                    return superListener;
                }
            };
        }
        return superListener;
    }

    void propagateInstalledServiceRemoval(IInternalInfoStore infoStore) throws SDKException {
        Property prop = (Property)this.properties().get(PropertyIDs.SI_ADM_DEL_INSTALLED_SERVICE);
        if (prop != null) {
            PropertyBag bag = prop.getPropertyBag();
            Iterator iter = bag.allIterator();
            HashSet<Integer> ids = new HashSet<Integer>();
            while (iter.hasNext()) {
                Property p = (Property)iter.next();
                if ((p.getFlags() & 0x8000000) == 0) continue;
                PropertyBag pb = p.getPropertyBag();
                ids.add(new Integer(pb.getInt((Object)PropertyIDs.SI_ID)));
            }
            Iterator iter2 = ids.iterator();
            while (iter2.hasNext()) {
                Integer serviceID = (Integer)iter2.next();
                String query = "select SI_HOSTED_SERVICES from CI_SYSTEMOBJECTS where CHILDREN(\"SI_NAME='EnterpriseNode-Server'\",\"CHILDREN('SI_NAME=''Install-EnterpriseNode''', 'SI_ID=" + this.getID() + "')\") AND CHILDREN(\"SI_NAME='Service-Server'\", \"SI_ID=" + serviceID + "\")";
                IInfoObjects infoObjs = infoStore.query(query);
                if (infoObjs.size() <= 0) continue;
                throw new SDKException.ServiceInUse(serviceID);
            }
        }
    }

    void propagateInstalledContainerRemoval(IInternalInfoStore infoStore) throws SDKException {
        Property prop = (Property)this.properties().get(PropertyIDs.SI_ADM_DEL_INSTALLED_CONTAINER);
        if (prop != null) {
            PropertyBag bag = prop.getPropertyBag();
            Iterator iter = bag.allIterator();
            HashSet<Integer> ids = new HashSet<Integer>();
            while (iter.hasNext()) {
                Property p = (Property)iter.next();
                if ((p.getFlags() & 0x8000000) == 0) continue;
                PropertyBag pb = p.getPropertyBag();
                ids.add(new Integer(pb.getInt((Object)PropertyIDs.SI_ID)));
            }
            String query = "select SI_CONFIGURED_CONTAINERS from CI_SYSTEMOBJECTS where CHILDREN(\"SI_NAME='EnterpriseNode-Server'\",\"CHILDREN('SI_NAME=''Install-EnterpriseNode''', 'SI_ID=" + this.getID() + "')\")";
            Iterator iter2 = ids.iterator();
            while (iter2.hasNext()) {
                Integer containerID = (Integer)iter2.next();
                IInfoObjects infoObjs = infoStore.query(query);
                if (infoObjs.size() <= 1) continue;
                throw new SDKException.ServiceContainerInUse(containerID);
            }
        }
    }

    public IInstalledObjects getInstalledContainers() throws SDKException {
        if (this.m_installedContainers == null) {
            this.m_installedContainers = new InstalledObjects();
            this.m_installedContainers.initialize(PropertyIDs.SI_INSTALLED_CONTAINERS, "INSTALLED_CONTAINER", this);
        }
        return this.m_installedContainers;
    }

    public IInstalledObjects getInstalledServices() throws SDKException {
        if (this.m_installedServices == null) {
            this.m_installedServices = new InstalledObjects();
            this.m_installedServices.initialize(PropertyIDs.SI_INSTALLED_SERVICES, "INSTALLED_SERVICE", this);
        }
        return this.m_installedServices;
    }

    public Set getEnterpriseNodes() throws SDKException {
        if (this.m_entNodeSet == null) {
            this.m_entNodeSet = new ObjectRelatives();
            ((ObjectRelatives)this.m_entNodeSet).initialize((Object)PropertyIDs.SI_INSTALL_ENTNODE, this.properties(), false, this.isNew());
        }
        return this.m_entNodeSet;
    }

    public INameValuePairs getPlaceholders() {
        if (this.m_placeholders == null) {
            PropertyBag bag = (PropertyBag)this.properties().getProperties(PropertyIDs.SI_PLACEHOLDERS);
            if (bag == null) {
                bag = ((PropertyBag)this.properties()).addArray((Object)PropertyIDs.SI_PLACEHOLDERS).getPropertyBag();
            }
            this.m_placeholders = new NameValuePairs(bag);
        }
        return this.m_placeholders;
    }

    public Set getObjectRelatives() {
        return this.m_objRels;
    }
}

