/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.sdk.plugin.desktop.publication.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.sdk.plugin.desktop.publication.IPublication;
import com.businessobjects.sdk.plugin.desktop.publication.IPublicationDocumentProfileTarget;
import com.businessobjects.sdk.plugin.desktop.publication.IPublicationDocumentProfileTargets;
import com.businessobjects.sdk.plugin.desktop.publication.IPublicationDynaRecipientProfileValueMappings;
import com.businessobjects.sdk.plugin.desktop.publication.IPublicationEventHandlers;
import com.businessobjects.sdk.plugin.desktop.publication.IPublicationPerDocProcessingInfo;
import com.businessobjects.sdk.plugin.desktop.publication.IPublicationPerDocProcessingInfos;
import com.businessobjects.sdk.plugin.desktop.publication.IPublicationProfileTarget;
import com.businessobjects.sdk.plugin.desktop.publication.IPublicationProfileTargets;
import com.businessobjects.sdk.plugin.desktop.publication.IPublicationState;
import com.businessobjects.sdk.plugin.desktop.publication.internal.ProfileResolutionEngine;
import com.businessobjects.sdk.plugin.desktop.publication.internal.PublicationDocumentProfileTargets;
import com.businessobjects.sdk.plugin.desktop.publication.internal.PublicationDynaRecipientProfileValueMappings;
import com.businessobjects.sdk.plugin.desktop.publication.internal.PublicationDynamicRecipientsReRun;
import com.businessobjects.sdk.plugin.desktop.publication.internal.PublicationEventHandlers;
import com.businessobjects.sdk.plugin.desktop.publication.internal.PublicationExcludedDynamicRecipients;
import com.businessobjects.sdk.plugin.desktop.publication.internal.PublicationPerDocProcessingInfo;
import com.businessobjects.sdk.plugin.desktop.publication.internal.PublicationPerDocProcessingInfos;
import com.businessobjects.sdk.plugin.desktop.publication.internal.PublicationProfileTargets;
import com.businessobjects.sdk.plugin.desktop.publication.internal.PublicationState;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.celib.stringhandler.StringHandlerFactory;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.ObjectID_Ex;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.exception.SDKRuntimeException;
import com.crystaldecisions.sdk.occa.infostore.IDestination;
import com.crystaldecisions.sdk.occa.infostore.IDestinationFormat;
import com.crystaldecisions.sdk.occa.infostore.IDestinationFormats;
import com.crystaldecisions.sdk.occa.infostore.IDestinationPluginArtifactFormats;
import com.crystaldecisions.sdk.occa.infostore.IDestinationStaticDocument;
import com.crystaldecisions.sdk.occa.infostore.IDestinationStaticDocuments;
import com.crystaldecisions.sdk.occa.infostore.IDestinations;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.IProcessingInfo;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObjectEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractSchedulableObject;
import com.crystaldecisions.sdk.occa.infostore.internal.DestinationPluginArtifactFormats;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoObjectEvent;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoObjectEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoStore;
import com.crystaldecisions.sdk.occa.infostore.internal.InternalInfoStoreFactory;
import com.crystaldecisions.sdk.occa.infostore.internal.ObjectRelatives;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.plugin.desktop.common.IFormatInfo;
import com.crystaldecisions.sdk.plugin.desktop.common.IFormatInfos;
import com.crystaldecisions.sdk.plugin.desktop.common.IPublicationDocumentVariableMapping;
import com.crystaldecisions.sdk.plugin.desktop.common.IPublicationDynamicRecipients;
import com.crystaldecisions.sdk.plugin.desktop.common.internal.ProcessingPublicationInfoHelper;
import com.crystaldecisions.sdk.plugin.desktop.common.internal.PublicationDynamicRecipients;
import com.crystaldecisions.sdk.plugin.desktop.user.IUser;
import com.crystaldecisions.sdk.plugin.desktop.usergroup.IUserGroup;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.IProperty;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import com.crystaldecisions.sdk.properties.internal.SDKPropertyBag;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Publication
extends AbstractSchedulableObject
implements IPublication {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.businessobjects.sdk.plugin.desktop.publication.internal.Publication");
    private static final String[] s_deprecatedFormats = new String[]{"FullClient", "PDF", "HTML", "Excel"};
    private static final int[] s_deprecatedToSupportedFormats = new int[]{0, 2, 5, 1};
    private static final int BackwardCompatibilityProcessingIndex = 0;
    private Collection m_documents;
    private Collection m_profiles;
    private Collection m_principals;
    private Collection m_excludedPrincipals;
    private Collection m_principalsReRun;
    private IPublicationDynamicRecipients m_dynamicRecipients;
    private IPublicationDynamicRecipients m_excludedDynamicRecipients;
    private IPublicationDynamicRecipients m_dynamicRecipientsReRun;
    private IPublicationDynaRecipientProfileValueMappings m_dynaRecipientsProfValMapping;
    private IPublicationPerDocProcessingInfos m_perDocProcessingInfos;
    private IPublicationProfileTargets m_targets;
    private IPublicationDocumentProfileTargets m_documentProfileTargets;
    private IPublicationEventHandlers m_handlers;
    private IDestinationPluginArtifactFormats m_defaultDestinationPlugins;
    private IPublicationState m_publicationState;
    private Map m_documentObjs;
    Set m_originalProfiles = null;
    private static final int TOP_N = 10000;

    public void initialize(ISecuritySession session, IInfoObjects collection, ObjectID_Ex id, short type) throws SDKException {
        super.initialize(session, collection, id, type);
        this.setProperty((Object)PropertyIDs.SI_PSS_SERVICE, "PublicationSchedulingService");
        this.setProperty((Object)PropertyIDs.SI_TYPE, 0);
    }

    public Collection getDocuments() throws SDKException {
        if (this.m_documents == null) {
            this.m_documents = new ObjectRelatives();
            ((ObjectRelatives)this.m_documents).initialize((Object)PropertyIDs.SI_PUBLICATION_DOCUMENTS, this.properties(), true, this.isNew());
        }
        return this.m_documents;
    }

    public Collection getProfiles() throws SDKException {
        if (this.m_profiles == null) {
            this.m_profiles = new ObjectRelatives();
            ((ObjectRelatives)this.m_profiles).initialize((Object)PropertyIDs.SI_PUBLICATION_PROFILES, this.properties(), false, this.isNew());
        }
        return this.m_profiles;
    }

    public Collection getPrincipals() throws SDKException {
        if (this.m_principals == null) {
            this.m_principals = new ObjectRelatives();
            ((ObjectRelatives)this.m_principals).initialize((Object)PropertyIDs.SI_PRINCIPALS, this.properties(), false, this.isNew());
        }
        return this.m_principals;
    }

    public Collection getExcludedPrincipals() throws SDKException {
        if (this.m_excludedPrincipals == null) {
            this.m_excludedPrincipals = new ObjectRelatives();
            ((ObjectRelatives)this.m_excludedPrincipals).initialize((Object)PropertyIDs.SI_EXCLUDED_PRINCIPALS, this.properties(), false, this.isNew());
        }
        return this.m_excludedPrincipals;
    }

    public Collection getPrincipalsReRun() throws SDKException {
        if (this.m_principalsReRun == null) {
            this.m_principalsReRun = new ObjectRelatives();
            ((ObjectRelatives)this.m_principalsReRun).initialize((Object)PropertyIDs.SI_PRINCIPALS_RERUN, this.properties(), false, this.isNew());
        }
        return this.m_principalsReRun;
    }

    public IPublicationDynamicRecipients getDynamicRecipients() throws SDKException {
        if (this.m_dynamicRecipients == null) {
            PropertyBag dynRecipientsBag = ((PropertyBag)this.properties()).getPropertyBag((Object)PropertyIDs.SI_DYNAMIC_RECIPIENTS);
            if (dynRecipientsBag == null) {
                dynRecipientsBag = ((PropertyBag)this.properties()).addArray((Object)PropertyIDs.SI_DYNAMIC_RECIPIENTS).getPropertyBag();
            }
            this.m_dynamicRecipients = new PublicationDynamicRecipients(dynRecipientsBag);
        }
        return this.m_dynamicRecipients;
    }

    public IPublicationDynamicRecipients getExcludedDynamicRecipients() throws SDKException {
        if (this.m_excludedDynamicRecipients == null) {
            PropertyBag exlDynRecipientsBag = ((PropertyBag)this.properties()).getPropertyBag((Object)PropertyIDs.SI_EXCLUDED_DYNAMIC_RECIPIENTS);
            if (exlDynRecipientsBag == null) {
                exlDynRecipientsBag = ((PropertyBag)this.properties()).addArray((Object)PropertyIDs.SI_EXCLUDED_DYNAMIC_RECIPIENTS).getPropertyBag();
            }
            this.m_excludedDynamicRecipients = new PublicationExcludedDynamicRecipients(exlDynRecipientsBag);
        }
        return this.m_excludedDynamicRecipients;
    }

    public IPublicationDynamicRecipients getDynamicRecipientsReRun() throws SDKException {
        if (this.m_dynamicRecipientsReRun == null) {
            PropertyBag dynRecipientsBag = ((PropertyBag)this.properties()).getPropertyBag((Object)PropertyIDs.SI_DYNAMIC_RECIPIENTS_RERUN);
            if (dynRecipientsBag == null) {
                dynRecipientsBag = ((PropertyBag)this.properties()).addArray((Object)PropertyIDs.SI_DYNAMIC_RECIPIENTS_RERUN).getPropertyBag();
            }
            this.m_dynamicRecipientsReRun = new PublicationDynamicRecipientsReRun(dynRecipientsBag);
        }
        return this.m_dynamicRecipientsReRun;
    }

    public boolean isDynamicRecipientsReRunAll() throws SDKException {
        return this.properties().getBoolean(PropertyIDs.SI_DYNAMIC_RECIPIENTS_RERUN_ALL);
    }

    public void setDynamicRecipientsReRunAll(boolean value) throws SDKException {
        this.setProperty((Object)PropertyIDs.SI_DYNAMIC_RECIPIENTS_RERUN_ALL, value);
    }

    public IPublicationDynaRecipientProfileValueMappings getDynamicRecipientsProfileValueMappings() throws SDKException {
        if (this.m_dynaRecipientsProfValMapping == null) {
            PropertyBag dynRecipientsProfValMapping = (PropertyBag)this.properties().getProperties(PropertyIDs.SI_DYNAMIC_RECIPIENTS_PROFILE_VALUE_MAPPINGS, true);
            this.m_dynaRecipientsProfValMapping = new PublicationDynaRecipientProfileValueMappings(dynRecipientsProfValMapping);
        }
        return this.m_dynaRecipientsProfValMapping;
    }

    public int getOutputFormat() {
        IFormatInfo formatInfo;
        ProcessingPublicationInfoHelper publicationInfo;
        String format;
        PropertyBag propbag = ((PropertyBag)this.getProcessingInfo().properties()).getPropertyBag((Object)PropertyIDs.SI_FORMAT_INFO);
        if (propbag != null && (format = propbag.getString((Object)PropertyIDs.SI_FORMAT)) != null) {
            for (int i = 0; i < s_deprecatedFormats.length; ++i) {
                if (!s_deprecatedFormats[i].equalsIgnoreCase(format)) continue;
                return i;
            }
        }
        try {
            IPublicationPerDocProcessingInfo perDocProcessingInfo = (IPublicationPerDocProcessingInfo)this.getPerDocProcessingInfos().get(new Integer(0));
            if (perDocProcessingInfo != null) {
                IProperties processingInfoProperties = perDocProcessingInfo.getDocProcessingInfo();
                publicationInfo = new ProcessingPublicationInfoHelper(processingInfoProperties, null);
                if (processingInfoProperties != null && publicationInfo.getFormatInfos() != null && !publicationInfo.getFormatInfos().isEmpty() && (formatInfo = (IFormatInfo)publicationInfo.getFormatInfos().get(0)) != null) {
                    return formatInfo.getFormat(formatInfo.getSourceDocumentKind());
                }
            }
        }
        catch (SDKException e) {
            // empty catch block
        }
        try {
            Iterator perDocProcessingInfos = this.getPerDocProcessingInfos().iterator();
            if (perDocProcessingInfos.hasNext()) {
                IProperties processingInfoProperties = ((IPublicationPerDocProcessingInfo)perDocProcessingInfos.next()).getDocProcessingInfo();
                publicationInfo = new ProcessingPublicationInfoHelper(processingInfoProperties, null);
                if (processingInfoProperties != null && publicationInfo.getFormatInfos() != null && !publicationInfo.getFormatInfos().isEmpty() && (formatInfo = (IFormatInfo)publicationInfo.getFormatInfos().get(0)) != null) {
                    return formatInfo.getFormat(formatInfo.getSourceDocumentKind());
                }
            }
        }
        catch (SDKException sDKException) {
            // empty catch block
        }
        return 0;
    }

    public void setOutputFormat(int format) throws SDKException {
        if (format < 0 || format >= s_deprecatedFormats.length) {
            throw new SDKException.InvalidArg(format);
        }
        PropertyBag propbag = ((PropertyBag)this.getProcessingInfo().properties()).getPropertyBag((Object)PropertyIDs.SI_FORMAT_INFO);
        if (propbag == null) {
            IProperty newProp = this.getProcessingInfo().properties().add(PropertyIDs.SI_FORMAT_INFO, null, 0x8000000);
            propbag = (PropertyBag)newProp.getValue();
        }
        propbag.setProperty((Object)PropertyIDs.SI_FORMAT, (Object)s_deprecatedFormats[format]);
    }

    public IPublicationProfileTargets getProfileTargets() throws SDKException {
        if (this.m_targets == null) {
            PropertyArrayHelper docProfileTargetsHelper;
            PropertyBag targetBag = ((PropertyBag)this.properties()).getPropertyBag((Object)PropertyIDs.SI_PUBLICATION_DOCUMENTPROFILE_TARGETS);
            if (targetBag == null) {
                targetBag = ((PropertyBag)this.properties()).addArray((Object)PropertyIDs.SI_PUBLICATION_DOCUMENTPROFILE_TARGETS).getPropertyBag();
            }
            if ((docProfileTargetsHelper = new PropertyArrayHelper(targetBag, PropertyIDs.SI_TOTAL, new Integer(0))).size() == 0) {
                docProfileTargetsHelper.add((Object)new SDKPropertyBag());
            }
            PropertyBag docProfileTargetBag = (PropertyBag)docProfileTargetsHelper.get(0);
            docProfileTargetBag.setProperty((Object)PropertyIDs.SI_SOURCE_DOC_ID, 0);
            PropertyBag docProfileTargetVariableMappingsBag = docProfileTargetBag.getPropertyBag((Object)PropertyIDs.SI_VARIABLE_MAPPINGS);
            if (docProfileTargetVariableMappingsBag == null) {
                docProfileTargetVariableMappingsBag = docProfileTargetBag.addArray((Object)PropertyIDs.SI_VARIABLE_MAPPINGS).getPropertyBag();
            }
            this.m_targets = new PublicationProfileTargets(docProfileTargetVariableMappingsBag);
        }
        return this.m_targets;
    }

    public IInfoObjectEventListener getInfoObjectEventListener(int type) {
        final IInfoObjectEventListener superListener = super.getInfoObjectEventListener(type);
        if (type == 2 || type == 7) {
            return new AbstractInfoObjectEventListener(){

                protected void processEvent(IInfoObjectEvent event) throws SDKException {
                    if (Publication.this.isNew()) {
                        Publication.this.getDocuments();
                        Publication.this.getProfiles();
                        Publication.this.getPrincipals();
                        Publication.this.getExcludedPrincipals();
                        Publication.this.getPrincipalsReRun();
                    }
                    Publication.this.checkBackwardCompatibility();
                }

                protected IInfoObjectEventListener getSuperEventListener() {
                    return superListener;
                }
            };
        }
        if (type == 3) {
            return new AbstractInfoObjectEventListener(){

                protected void processEvent(IInfoObjectEvent event) throws SDKException {
                    if (Publication.this.isNew()) {
                        Publication.this.getDocuments();
                        Publication.this.getProfiles();
                        Publication.this.getPrincipals();
                        Publication.this.getExcludedPrincipals();
                        Publication.this.getPrincipalsReRun();
                    }
                    Publication.this.checkBackwardCompatibility();
                    Publication.this.checkSchedulableDocuments();
                }

                protected IInfoObjectEventListener getSuperEventListener() {
                    return superListener;
                }
            };
        }
        return superListener;
    }

    public Set getCorporateCategories() throws SDKException {
        return super.getCorporateCategories();
    }

    public Set getPersonalCategories() throws SDKException {
        return super.getPersonalCategories();
    }

    public void refreshProcessingInfo(IProcessingInfo procInfo) throws SDKException {
        this.setDocumentProcessingInfo(0, "FullClient", procInfo.properties());
    }

    public boolean subscribe(int principalID) throws SDKException {
        Integer newSubscriberID = new Integer(principalID);
        this.getExcludedPrincipals().remove(newSubscriberID);
        return this.getPrincipals().add(newSubscriberID);
    }

    public boolean unsubscribe(int principalID) throws SDKException {
        Integer subscriberID = new Integer(principalID);
        this.getPrincipals().remove(subscriberID);
        return this.getExcludedPrincipals().add(subscriberID);
    }

    public boolean isSubscribed(int principalID) throws SDKException {
        String inList;
        Integer intPrincipalID = new Integer(principalID);
        Set excluded = (Set)this.getExcludedPrincipals();
        if (excluded.contains(intPrincipalID)) {
            return false;
        }
        Set included = (Set)this.getPrincipals();
        if (included.isEmpty()) {
            return false;
        }
        if (included.contains(intPrincipalID)) {
            return true;
        }
        Iterator iter = included.iterator();
        String string = inList = iter.hasNext() ? iter.next().toString() : "";
        while (iter.hasNext()) {
            inList = inList + ",";
            inList = inList + iter.next();
        }
        IInfoObjects col = this.getInfoStore().query("select top 1 si_id from ci_systemobjects where si_kind = 'UserGroup' and si_id in (" + inList + ") and Ancestors(\"SI_NAME = 'UserGroup-User'\", \"SI_ID = " + principalID + "\")");
        return col.size() > 0;
    }

    public int getProfileResolutionType() throws SDKException {
        IProperty prop = this.getProperty(PropertyIDs.SI_TYPE);
        if (prop == null) {
            return 0;
        }
        return (Integer)prop.getValue();
    }

    public void setProfileResolutionType(int type) throws SDKException {
        if (type != 0 && type != 1) {
            throw new SDKException.InvalidArg(type);
        }
        this.setProperty((Object)PropertyIDs.SI_TYPE, type);
    }

    public Set getNoProfileUsers() throws SDKException {
        Set recipients = this.getRecipients();
        Set profiledRecipients = this.filterProfiledRecipients(recipients);
        Iterator iter = profiledRecipients.iterator();
        while (iter.hasNext()) {
            Integer id = (Integer)iter.next();
            recipients.remove(id);
        }
        return recipients;
    }

    public Set getScopes() throws SDKException {
        return new ProfileResolutionEngine(this, this.getInfoStore()).findScopes();
    }

    public long getMultiPassBursting() throws SDKException {
        return this.getBurstingMode();
    }

    public void setMultiPassBursting(long value) throws SDKException {
        this.setBurstingMode(value);
    }

    public long getBurstingMode() throws SDKException {
        if (this.properties().get(PropertyIDs.SI_MULTIPASSBURSTING) != null) {
            return this.properties().getLong(PropertyIDs.SI_MULTIPASSBURSTING);
        }
        return 0L;
    }

    public void setBurstingMode(long burstingMode) throws SDKException {
        if (burstingMode < 0L || burstingMode > 2L) {
            throw new SDKException.InvalidArg(burstingMode);
        }
        this.setProperty((Object)PropertyIDs.SI_MULTIPASSBURSTING, new Integer((int)burstingMode));
    }

    public int getScopeBatchSize() throws SDKException {
        IProperty prop = this.getProperty(PropertyIDs.SI_SCOPE_BATCH_SIZE);
        if (prop == null) {
            return 50;
        }
        return (Integer)prop.getValue();
    }

    public void setScopeBatchSize(int value) throws SDKException {
        this.setProperty((Object)PropertyIDs.SI_SCOPE_BATCH_SIZE, value);
    }

    public IPublicationState getPublicationState() {
        if (this.m_publicationState == null) {
            PropertyBag stateBag = ((PropertyBag)this.properties()).getPropertyBag((Object)PropertyIDs.SI_PUBLICATION_LAST_STATE);
            if (stateBag == null) {
                stateBag = ((PropertyBag)this.properties()).addItem((Object)PropertyIDs.SI_PUBLICATION_LAST_STATE, null, 0x8000000).getPropertyBag();
            }
            this.m_publicationState = new PublicationState(stateBag);
        }
        return this.m_publicationState;
    }

    private Set extractProfilesFromProfileTargets() {
        if (this.m_documentProfileTargets == null) {
            return null;
        }
        HashSet<Integer> profiles = new HashSet<Integer>();
        Iterator it = this.m_documentProfileTargets.iterator();
        while (it.hasNext()) {
            IPublicationDocumentProfileTarget target = (IPublicationDocumentProfileTarget)it.next();
            Iterator it2 = target.getVariableMappings().iterator();
            while (it2.hasNext()) {
                IPublicationDocumentVariableMapping mapping = (IPublicationDocumentVariableMapping)it2.next();
                int profileID = mapping.getProfileID();
                if (profileID == 0) continue;
                profiles.add(new Integer(profileID));
            }
        }
        return profiles;
    }

    private void updateProfiles() {
        Set currentProfiles = this.extractProfilesFromProfileTargets();
        HashSet addedProfiles = new HashSet(currentProfiles);
        addedProfiles.removeAll(this.m_originalProfiles);
        HashSet deletedProfiles = new HashSet(this.m_originalProfiles);
        deletedProfiles.removeAll(currentProfiles);
        try {
            Collection profilesRelation = this.getProfiles();
            profilesRelation.addAll(addedProfiles);
            profilesRelation.removeAll(deletedProfiles);
        }
        catch (SDKException e) {
            // empty catch block
        }
        this.m_originalProfiles = currentProfiles;
    }

    public IPublicationDocumentProfileTargets getPublicationDocumentProfileTargets() throws SDKException {
        if (this.m_documentProfileTargets == null) {
            PropertyBag targetBag = ((PropertyBag)this.properties()).getPropertyBag((Object)PropertyIDs.SI_PUBLICATION_DOCUMENTPROFILE_TARGETS);
            if (targetBag == null) {
                targetBag = ((PropertyBag)this.properties()).addArray((Object)PropertyIDs.SI_PUBLICATION_DOCUMENTPROFILE_TARGETS).getPropertyBag();
            }
            this.m_documentProfileTargets = new PublicationDocumentProfileTargets(targetBag, new IProfileChangeListener(){

                public void profileChanged() {
                    Publication.this.updateProfiles();
                }
            });
            this.m_originalProfiles = this.extractProfilesFromProfileTargets();
        }
        return this.m_documentProfileTargets;
    }

    private void handlePluginRemoved(Integer eventHandlerID) {
        if (eventHandlerID == PropertyIDs.SI_ON_READ_RECIPIENTS) {
            try {
                this.getDynamicRecipients().clear();
                this.getExcludedDynamicRecipients().clear();
                this.getDynamicRecipientsReRun().clear();
                PropertyBag profileValueMappings = (PropertyBag)this.properties().getProperties(PropertyIDs.SI_DYNAMIC_RECIPIENTS_PROFILE_VALUE_MAPPINGS, true);
                profileValueMappings.clear();
            }
            catch (SDKException sDKException) {
                // empty catch block
            }
        }
    }

    public IPublicationEventHandlers getPublicationEventHandlers() {
        if (this.m_handlers == null) {
            IProperties props = this.properties().getProperties(PropertyIDs.SI_PUBLICATION_EVENT_HANDLERS);
            if (props == null) {
                props = this.properties().addProperties(PropertyIDs.SI_PUBLICATION_EVENT_HANDLERS);
            }
            this.m_handlers = new PublicationEventHandlers(props, new IEventHandlerChangeListener(){

                public void pluginRemoved(Integer eventHandlerID) {
                    Publication.this.handlePluginRemoved(eventHandlerID);
                }
            });
        }
        return this.m_handlers;
    }

    public int getGlobalDeliveryRuleDocID() {
        IProperty prop = this.getProperty(PropertyIDs.SI_GLOBAL_DELIVERY_RULE_DOC_OBJECT_ID);
        if (prop == null) {
            return -1;
        }
        return (Integer)prop.getValue();
    }

    public void setGlobalDeliveryRuleDocID(int value) throws SDKException {
        this.setProperty((Object)PropertyIDs.SI_GLOBAL_DELIVERY_RULE_DOC_OBJECT_ID, value);
    }

    public String getGlobalDeliveryRuleExpression() {
        IProperty prop = this.getProperty(PropertyIDs.SI_GLOBAL_DELIVERY_RULE_EXPRESSION);
        if (prop == null) {
            return null;
        }
        return (String)prop.getValue();
    }

    public void setGlobalDeliveryRuleExpression(String value) throws SDKException {
        this.setProperty((Object)PropertyIDs.SI_GLOBAL_DELIVERY_RULE_EXPRESSION, value);
    }

    public boolean isGlobalDeliverIfAlertIsTrue() throws SDKException {
        IProperty prop = this.getProperty(PropertyIDs.SI_DELIVER_IF_ALERT_IS_TRUE);
        if (prop == null) {
            return true;
        }
        return (Boolean)prop.getValue();
    }

    public void setGlobalDeliverIfAlertIsTrue(boolean value) throws SDKException {
        this.setProperty((Object)PropertyIDs.SI_DELIVER_IF_ALERT_IS_TRUE, value);
    }

    public boolean isShowAllDataForNullProfileValues() {
        IProperty prop = this.getProperty(PropertyIDs.SI_SHOW_ALL_DATA_FOR_NULL_PROFILE_VALUES);
        if (prop == null) {
            return false;
        }
        return (Boolean)prop.getValue();
    }

    public void setShowAllDataForNullProfileValues(boolean value) throws SDKException {
        this.setProperty((Object)PropertyIDs.SI_SHOW_ALL_DATA_FOR_NULL_PROFILE_VALUES, value);
    }

    private Collection getDocumentsByKind(boolean wantSchedulable) throws SDKException {
        Vector<IInfoObject> returnDocuments = new Vector<IInfoObject>();
        Collection allDocuments = this.getDocuments();
        this.updateDocumentMap(allDocuments);
        Iterator documentsIter = allDocuments.iterator();
        while (documentsIter.hasNext()) {
            Integer document = (Integer)documentsIter.next();
            IInfoObject obj = (IInfoObject)this.m_documentObjs.get(document);
            String kind = obj.getKind();
            boolean documentIsSchedulable = kind != null && this.isSchedulableKind(kind);
            if (documentIsSchedulable != wantSchedulable) continue;
            returnDocuments.add(obj);
        }
        return Collections.unmodifiableCollection(returnDocuments);
    }

    public Collection getSchedulableDocuments() throws SDKException {
        boolean wantSchedulable = true;
        return this.getDocumentsByKind(wantSchedulable);
    }

    public Collection getStaticDocuments() throws SDKException {
        boolean wantSchedulable = false;
        return this.getDocumentsByKind(wantSchedulable);
    }

    private void updateDocumentMap(Collection documentIDs) throws SDKException {
        if (this.m_documentObjs == null) {
            this.m_documentObjs = new HashMap();
        }
        Vector<Integer> documentsToQuery = new Vector<Integer>();
        Iterator documentsIter = documentIDs.iterator();
        while (documentsIter.hasNext()) {
            Integer documentID = (Integer)documentsIter.next();
            IInfoObject obj = (IInfoObject)this.m_documentObjs.get(documentID);
            if (obj != null) continue;
            documentsToQuery.add(documentID);
        }
        if (documentsToQuery.size() > 0) {
            StringBuffer queryString = new StringBuffer("select top " + documentsToQuery.size() + " static from CI_INFOOBJECTS where SI_ID in (");
            boolean needComma = false;
            Iterator iter = documentsToQuery.iterator();
            while (iter.hasNext()) {
                Integer documentID = (Integer)iter.next();
                if (needComma) {
                    queryString.append(",");
                } else {
                    needComma = true;
                }
                queryString.append(documentID);
            }
            queryString.append(")");
            IInfoObjects objs = this.getInfoStore().query(queryString.toString());
            if (objs.size() == 0 || objs.size() != documentsToQuery.size()) {
                throw new SDKRuntimeException.PublicationDocumentNotFound((Integer)documentsToQuery.iterator().next());
            }
            for (int i = 0; i < objs.size(); ++i) {
                IInfoObject obj = (IInfoObject)objs.get(i);
                if (obj == null) continue;
                this.m_documentObjs.put(new Integer(obj.getID()), obj);
            }
        }
    }

    private boolean isSchedulableKind(String kind) {
        return kind.equals("CrystalReport") || kind.equals("Webi") || kind.equals("FullClient") || kind.equals("FullClientAddin") || kind.equals("FullClientTemplate");
    }

    public IPublicationPerDocProcessingInfos getPerDocProcessingInfos() {
        if (this.m_perDocProcessingInfos == null) {
            PropertyBag processingProps = (PropertyBag)this.getProcessingInfo().properties();
            Property processExtensions = processingProps.getItem((Object)PropertyIDs.SI_PROCESSINFO_PER_DOC);
            if (processExtensions == null) {
                processExtensions = processingProps.addArray((Object)PropertyIDs.SI_PROCESSINFO_PER_DOC);
            }
            this.m_perDocProcessingInfos = new PublicationPerDocProcessingInfos(processExtensions.getPropertyBag());
        }
        return this.m_perDocProcessingInfos;
    }

    public IProperties getDocumentProcessingInfo(int docID) throws SDKException {
        PublicationPerDocProcessingInfo docProcInfo = (PublicationPerDocProcessingInfo)this.getPerDocProcessingInfos().get(new Integer(docID));
        if (docProcInfo == null) {
            return null;
        }
        return docProcInfo.getDocProcessingInfo();
    }

    public Object getDocumentProcessingInfoObject(int documentID) throws SDKException {
        PublicationPerDocProcessingInfo docProcInfo = (PublicationPerDocProcessingInfo)this.getPerDocProcessingInfos().get(new Integer(documentID));
        if (docProcInfo == null) {
            return null;
        }
        String kind = docProcInfo.getSourceDocumentKind();
        IProperties properties = docProcInfo.getDocProcessingInfo();
        IInfoObject processingInfoObject = (IInfoObject)this.getInfoStore().getPluginMgr().getPluginInterface(kind, "desktop");
        if (processingInfoObject.getProcessingInfo() != null && processingInfoObject.getProcessingInfo().properties() != null) {
            PropertyBag props = (PropertyBag)processingInfoObject.getProcessingInfo().properties();
            props.putAllWithoutEncryption((Map)properties);
            if (props.getStringHandler() == null) {
                if (properties != null) {
                    PropertyBag orgBag = (PropertyBag)properties;
                    if (orgBag.getStringHandler() != null) {
                        props.setStringHandler(orgBag.getStringHandler());
                    }
                } else {
                    props.setStringHandler(StringHandlerFactory.getDefaultStringHandler());
                }
            }
        }
        return processingInfoObject;
    }

    public void setDocumentProcessingInfo(int documentID, String documentKind, IProperties inputProcessingInfo) throws SDKException {
        PublicationPerDocProcessingInfo info = (PublicationPerDocProcessingInfo)this.getPerDocProcessingInfos().get(new Integer(documentID));
        if (info == null) {
            this.getPerDocProcessingInfos().add(documentID, documentKind, inputProcessingInfo);
        } else {
            PropertyBag pubDocumentProcessingInfo = (PropertyBag)info.getDocProcessingInfo();
            pubDocumentProcessingInfo.clear();
            info.setDocProcessingInfo(inputProcessingInfo);
            info.setSourceDocumentID(documentID);
            info.setSourceDocumentKind(documentKind);
        }
        this.setProperty((Object)PropertyIDs.SI_PUBLICATION_TYPE, documentKind);
    }

    public void removeDocumentProcessingInfo(int documentID) {
        PublicationPerDocProcessingInfos perDocProcInfos = (PublicationPerDocProcessingInfos)this.getPerDocProcessingInfos();
        if (documentID != -1) {
            perDocProcInfos.remove(new Integer(documentID));
        } else {
            perDocProcInfos.clear();
        }
    }

    Set getEffectiveProfiles() throws SDKException {
        Collection profiles = this.getProfiles();
        IPublicationProfileTargets profileTargets = this.getProfileTargets();
        HashSet<Integer> effective = new HashSet<Integer>(profiles);
        Iterator iter = profileTargets.iterator();
        while (iter.hasNext()) {
            IPublicationProfileTarget target = (IPublicationProfileTarget)iter.next();
            Integer id = new Integer(target.getProfileID());
            if (effective.contains(id)) continue;
            effective.add(id);
        }
        return effective;
    }

    private Set getRecipients() throws SDKException {
        Collection included = this.getPrincipals();
        Collection excluded = this.getExcludedPrincipals();
        HashSet explicitSubscribers = new HashSet(included);
        Iterator iter = excluded.iterator();
        while (iter.hasNext()) {
            Integer id = (Integer)iter.next();
            if (!explicitSubscribers.contains(id)) continue;
            LOG.assertTrue(false, "Principal " + id + " is in both SI_PRINCIPALS list and SI_EXCLUDED_PRINCIPALS list");
            explicitSubscribers.remove(id);
        }
        HashSet<Integer> allRecipients = new HashSet<Integer>();
        if (explicitSubscribers.size() > 0) {
            IInfoObjects objs;
            String recipientsInList = this.convertToQueryInList(explicitSubscribers);
            String select = "select top 10000 si_kind, si_group_members from ci_systemobjects";
            String where = "si_id in (" + recipientsInList + ") ";
            where = where + "or (Descendents('si_name = ''UserGroup-User''', 'si_id in (" + recipientsInList + ")') and si_kind = '" + "UserGroup" + "') ";
            int nextStartIndex = 0;
            do {
                objs = this.queryNextBatchOfObjects(select, where, nextStartIndex);
                Iterator iter2 = objs.iterator();
                while (iter2.hasNext()) {
                    IInfoObject obj = (IInfoObject)iter2.next();
                    if (obj.getKind().equalsIgnoreCase("User")) {
                        allRecipients.add(new Integer(obj.getID()));
                        continue;
                    }
                    LOG.assertTrue(obj instanceof IUserGroup, "The retrieved object " + obj.getID() + " is not a user group");
                    allRecipients.addAll(((IUserGroup)obj).getUsers());
                }
            } while ((nextStartIndex = objs.size() < objs.getResultSize() ? ((IInfoObject)objs.get(objs.size() - 1)).getID() : 0) > 0);
            Iterator iter3 = excluded.iterator();
            while (iter3.hasNext()) {
                Integer id = (Integer)iter3.next();
                if (!allRecipients.contains(id)) continue;
                allRecipients.remove(id);
            }
        }
        return allRecipients;
    }

    private Set filterProfiledRecipients(Set allRecipients) throws SDKException {
        Set effectiveProfiles = this.getEffectiveProfiles();
        if (allRecipients == null) {
            allRecipients = this.getRecipients();
        }
        if (effectiveProfiles.size() == 0) {
            return new HashSet();
        }
        HashSet<Integer> profiledRecipients = new HashSet<Integer>();
        if (allRecipients.size() > 0) {
            IInfoObjects allProfiledRecipients;
            String select = "select top 10000 si_id from ci_systemobjects";
            String nested = "Descendents('si_name = ''Profile-Principal''', 'si_id in (" + this.convertToQueryInList(effectiveProfiles) + ")')";
            String where = "si_id in (" + this.convertToQueryInList(allRecipients) + ") and ";
            where = where + "((Descendents(\"si_name = 'UserGroup-User'\", \"" + nested + "\")";
            where = where + " or " + nested + ")";
            where = where + " and si_kind = 'User')";
            int nextStartIndex = 0;
            do {
                allProfiledRecipients = this.queryNextBatchOfObjects(select, where, nextStartIndex);
                Iterator iter = allProfiledRecipients.iterator();
                while (iter.hasNext()) {
                    IInfoObject obj = (IInfoObject)iter.next();
                    LOG.assertTrue(obj instanceof IUser, "The retrieved object " + obj.getID() + " is not a user");
                    profiledRecipients.add(new Integer(obj.getID()));
                }
            } while ((nextStartIndex = allProfiledRecipients.size() < allProfiledRecipients.getResultSize() ? ((IInfoObject)allProfiledRecipients.get(allProfiledRecipients.size() - 1)).getID() : 0) > 0);
        }
        return profiledRecipients;
    }

    private IInfoObjects queryNextBatchOfObjects(String select, String where, int nextStartIndex) throws SDKException {
        String query = select + " where " + "(" + where + ") and si_id > " + nextStartIndex + " order by si_id";
        return this.getInfoStore().query(query);
    }

    private String convertToQueryInList(Set idSet) {
        String profilesInList = "";
        boolean bIsInitID = true;
        Iterator iter = idSet.iterator();
        while (iter.hasNext()) {
            Integer id = (Integer)iter.next();
            if (!bIsInitID) {
                profilesInList = profilesInList + ",";
            } else {
                bIsInitID = false;
            }
            profilesInList = profilesInList + id;
        }
        return profilesInList;
    }

    private void checkBackwardCompatibility() throws SDKException {
        IProperties bwcProcessingInfo = null;
        if (this.m_perDocProcessingInfos != null) {
            bwcProcessingInfo = this.getDocumentProcessingInfo(0);
        }
        IProperty outputFormatProperty = this.getProcessingInfo().properties().getProperty(PropertyIDs.SI_FORMAT_INFO);
        if (!(bwcProcessingInfo == null && outputFormatProperty == null || this.isNew())) {
            IInfoObjects objs;
            boolean requireDestinations = false;
            IProperty destinations = this.getSchedulingInfo().properties().getProperty(PropertyIDs.SI_DESTINATIONS);
            if (destinations == null) {
                requireDestinations = true;
            }
            StringBuffer selectStatement = new StringBuffer("SI_PROCESSINFO.SI_PROCESSINFO_PER_DOC");
            if (requireDestinations) {
                selectStatement.append(", SI_SCHEDULEINFO.SI_DESTINATIONS");
            }
            if ((objs = this.getInfoStore().query("select " + selectStatement + " from CI_INFOOBJECTS where SI_ID=" + this.getID())) == null || objs.size() != 1) {
                throw new IllegalStateException("Publication no longer exists at InfoStore");
            }
            Publication updatedPublication = (Publication)objs.get(0);
            Iterator updatedProcessingInfos = updatedPublication.getPerDocProcessingInfos().iterator();
            while (updatedProcessingInfos.hasNext()) {
                IPublicationPerDocProcessingInfo updatedProcessingInfo = (IPublicationPerDocProcessingInfo)updatedProcessingInfos.next();
                if (updatedProcessingInfo == null || this.getPerDocProcessingInfos().get(new Integer(updatedProcessingInfo.getSourceDocumentID())) != null) continue;
                this.getPerDocProcessingInfos().add(updatedProcessingInfo);
            }
            if (requireDestinations && updatedPublication.getSchedulingInfo().getDestinations() != null) {
                IDestinations updatedDestinations = updatedPublication.getSchedulingInfo().getDestinations();
                this.getSchedulingInfo().getDestinations().addAll(updatedDestinations);
            }
        }
        if (this.m_perDocProcessingInfos != null) {
            bwcProcessingInfo = this.getDocumentProcessingInfo(0);
        }
        if (bwcProcessingInfo != null && !this.getDocuments().isEmpty()) {
            Integer documentID = (Integer)this.getDocuments().iterator().next();
            this.setDocumentProcessingInfo(documentID, "FullClient", bwcProcessingInfo);
        }
        if (outputFormatProperty != null || bwcProcessingInfo != null) {
            int outputFormat = s_deprecatedToSupportedFormats[this.getOutputFormat()];
            if (!this.getDocuments().isEmpty()) {
                ProcessingPublicationInfoHelper publicationInfo;
                Integer documentID = (Integer)this.getDocuments().iterator().next();
                IPublicationPerDocProcessingInfo processingInfo = (IPublicationPerDocProcessingInfo)this.getPerDocProcessingInfos().get(documentID);
                if (processingInfo != null && (publicationInfo = new ProcessingPublicationInfoHelper(processingInfo.getDocProcessingInfo(), null)).getFormatInfos() != null && (outputFormatProperty != null || bwcProcessingInfo != null && publicationInfo.getFormatInfos().isEmpty())) {
                    publicationInfo.getFormatInfos().clear();
                    IFormatInfo formatInfo = publicationInfo.getFormatInfos().add();
                    formatInfo.setSourceDocumentKind("FullClient");
                    formatInfo.setFormat("FullClient", outputFormat);
                }
            }
        }
        if (this.m_targets != null) {
            PropertyBag targetBag = ((PropertyBag)this.properties()).getPropertyBag((Object)PropertyIDs.SI_PUBLICATION_DOCUMENTPROFILE_TARGETS);
            PropertyArrayHelper docProfileTargetsHelper = new PropertyArrayHelper(targetBag, PropertyIDs.SI_TOTAL, new Integer(0));
            boolean bBWCProfileMappingExist = false;
            PropertyBag bwcPfofileMapping = null;
            PublicationProfileTargets bmcProfileTargets = null;
            for (int i = 0; i < docProfileTargetsHelper.size(); ++i) {
                PropertyBag docProfileTargetBag = (PropertyBag)docProfileTargetsHelper.get(i);
                int docID = docProfileTargetBag.getInt((Object)PropertyIDs.SI_SOURCE_DOC_ID);
                if (docID != 0) continue;
                bBWCProfileMappingExist = true;
                bwcPfofileMapping = docProfileTargetBag.getPropertyBag((Object)PropertyIDs.SI_VARIABLE_MAPPINGS);
                bmcProfileTargets = new PublicationProfileTargets(bwcPfofileMapping);
            }
            if (bBWCProfileMappingExist && !this.getDocuments().isEmpty()) {
                int srcDocID = (Integer)this.getDocuments().iterator().next();
                SDKPropertyBag newBag = new SDKPropertyBag();
                newBag.setProperty(PropertyIDs.SI_SOURCE_DOC_ID, srcDocID);
                PropertyBag docProfileTargetVariableMappingsBag = newBag.getPropertyBag(PropertyIDs.SI_VARIABLE_MAPPINGS);
                if (docProfileTargetVariableMappingsBag == null) {
                    docProfileTargetVariableMappingsBag = newBag.addArray(PropertyIDs.SI_VARIABLE_MAPPINGS).getPropertyBag();
                }
                PublicationProfileTargets newProfileTargets = new PublicationProfileTargets(docProfileTargetVariableMappingsBag);
                for (int j = 0; j < bmcProfileTargets.size(); ++j) {
                    IPublicationProfileTarget bmcTarget = (IPublicationProfileTarget)bmcProfileTargets.get(j);
                    IPublicationProfileTarget newTarget = newProfileTargets.add();
                    newTarget.setProfileID(bmcTarget.getProfileID());
                    newTarget.setVariable(bmcTarget.getVariable());
                }
                docProfileTargetsHelper.add((Object)newBag);
            }
        }
    }

    private void checkSchedulableDocuments() throws SDKException {
        if (this.m_documents == null) {
            return;
        }
        Collection documents = this.getSchedulableDocuments();
        if (documents.size() >= 2) {
            Iterator documentsIter = documents.iterator();
            IInfoObject firstDocument = (IInfoObject)documentsIter.next();
            String firstKind = firstDocument.getKind();
            while (documentsIter.hasNext()) {
                IInfoObject document = (IInfoObject)documentsIter.next();
                String kind = document.getKind();
                if (firstKind.equals(kind)) continue;
                throw new SDKException.MultipleDocumentKinds();
            }
        }
    }

    private void checkProcessingInfos() throws SDKException {
        Iterator documentsIter = this.getSchedulableDocuments().iterator();
        while (documentsIter.hasNext()) {
            IInfoObject document = (IInfoObject)documentsIter.next();
            int documentID = document.getID();
            String documentKind = document.getKind();
            IProperties processingProperties = this.getDocumentProcessingInfo(documentID);
            if (processingProperties == null) {
                throw new SDKException.MissingProcessingInfo(documentID, documentKind);
            }
            ProcessingPublicationInfoHelper processingInfo = new ProcessingPublicationInfoHelper(processingProperties, null);
            IFormatInfos formatInfos = processingInfo.getFormatInfos();
            this.checkFormatInfos(formatInfos);
        }
    }

    private void checkDestinations() throws SDKException {
        IDestinations destinations = this.getSchedulingInfo().getDestinations();
        int numDestinations = destinations.size();
        for (int i = 0; i < numDestinations; ++i) {
            IDestination destination = (IDestination)destinations.get(i);
            this.checkDestination(destination);
        }
    }

    private void checkDestination(IDestination destination) throws SDKException {
        IDestinationFormats destinationFormats = destination.getDestinationFormats();
        int numDestinationFormats = destinationFormats.size();
        for (int i = 0; i < numDestinationFormats; ++i) {
            IDestinationFormat destinationFormat = (IDestinationFormat)destinationFormats.get(i);
            int documentID = destinationFormat.getSourceDocumentID();
            if (!this.getDocuments().contains(new Integer(documentID))) continue;
            Iterator schedulableDocuments = this.getSchedulableDocuments().iterator();
            boolean documentMatchFound = false;
            while (schedulableDocuments.hasNext()) {
                IInfoObject document = (IInfoObject)schedulableDocuments.next();
                if (documentID != document.getID()) continue;
                documentMatchFound = true;
            }
            if (!documentMatchFound) {
                throw new SDKException.InvalidDestinationDocument(documentID);
            }
            IFormatInfos destinationFormatInfos = destinationFormat.getFormatInfos();
            this.checkFormatInfos(destinationFormatInfos);
            IProperties processingProperties = this.getDocumentProcessingInfo(documentID);
            ProcessingPublicationInfoHelper processingInfo = new ProcessingPublicationInfoHelper(processingProperties, null);
            IFormatInfos processingFormatInfos = processingInfo.getFormatInfos();
            for (int j = 0; j < destinationFormatInfos.size(); ++j) {
                IFormatInfo destinationFormatInfo = (IFormatInfo)destinationFormatInfos.get(j);
                String kind = destinationFormatInfo.getSourceDocumentKind();
                int format = destinationFormatInfo.getFormat(kind);
                boolean formatMatchFound = false;
                for (int k = 0; k < processingFormatInfos.size(); ++k) {
                    IFormatInfo processingFormatInfo = (IFormatInfo)processingFormatInfos.get(k);
                    String processingKind = processingFormatInfo.getSourceDocumentKind();
                    int processingFormat = processingFormatInfo.getFormat(processingKind);
                    if (!kind.equals(processingKind) || format != processingFormat) continue;
                    formatMatchFound = true;
                    break;
                }
                if (formatMatchFound) continue;
                throw new SDKException.InvalidDestinationFormat(documentID, kind, format);
            }
        }
        IDestinationStaticDocuments destinationStaticDocuments = destination.getDestinationStaticDocuments();
        int numStaticDocuments = destinationStaticDocuments.size();
        HashSet<Integer> staticDocuments = new HashSet<Integer>();
        for (int i = 0; i < numStaticDocuments; ++i) {
            IDestinationStaticDocument destinationDocument = (IDestinationStaticDocument)destinationStaticDocuments.get(i);
            int documentID = destinationDocument.getStaticDocumentID();
            if (!this.getDocuments().contains(new Integer(documentID))) continue;
            Iterator schedulableDocuments = this.getSchedulableDocuments().iterator();
            boolean matchFound = false;
            while (schedulableDocuments.hasNext()) {
                IInfoObject document = (IInfoObject)schedulableDocuments.next();
                if (documentID != document.getID()) continue;
                matchFound = true;
            }
            if (matchFound) {
                throw new SDKException.InvalidDestinationStaticDocument(documentID);
            }
            if (staticDocuments.add(new Integer(documentID))) continue;
            throw new SDKException.DuplicateDestinationStaticDocument(documentID);
        }
    }

    private void checkFormatInfos(IFormatInfos formatInfos) throws SDKException {
        HashSet<Integer> formats = new HashSet<Integer>(formatInfos.size());
        for (int i = 0; i < formatInfos.size(); ++i) {
            IFormatInfo formatInfo = (IFormatInfo)formatInfos.get(i);
            String documentKind = formatInfo.getSourceDocumentKind();
            if (documentKind == null || !this.isSchedulableKind(documentKind)) {
                throw new SDKException.InvalidFormatKind(documentKind);
            }
            int format = formatInfo.getFormat(documentKind);
            if (formats.add(new Integer(formatInfo.getFormat(documentKind)))) continue;
            throw new SDKException.DuplicateFormatInfo(documentKind, format);
        }
    }

    public int getLogFileID() {
        IProperty prop = this.getProperty(PropertyIDs.SI_PUBLICATION_LOG_FILE_ID);
        if (prop == null || prop.getValue() == null || !(prop.getValue() instanceof Integer)) {
            return 0;
        }
        return (Integer)prop.getValue();
    }

    public void setLogFileID(int value) throws SDKException {
        if (value < 0) {
            throw new SDKException.InvalidArg();
        }
        this.setProperty((Object)PropertyIDs.SI_PUBLICATION_LOG_FILE_ID, new Integer(value));
    }

    public String getPublicationServerName() {
        IProperty prop = this.getProperty(PropertyIDs.SI_PUBLICATION_SERVER_NAME);
        if (prop == null || prop.getValue() == null) {
            return "";
        }
        return (String)prop.getValue();
    }

    public void setPublicationServerName(String value) {
        this.setProperty((Object)PropertyIDs.SI_PUBLICATION_SERVER_NAME, value);
    }

    public void checkPublicationIntegrity() throws SDKException {
        this.checkSchedulableDocuments();
        this.checkProcessingInfos();
        this.checkDestinations();
    }

    public int getDeliveryRuleOptions() {
        if (this.getProcessingInfo().properties().getProperty(PropertyIDs.SI_DELIVERY_RULE_OPTIONS) != null) {
            return this.getProcessingInfo().properties().getInt(PropertyIDs.SI_DELIVERY_RULE_OPTIONS);
        }
        return 2;
    }

    public void setDeliveryRuleOptions(int deliveryRuleOptions) throws SDKException {
        PropertyBag processingProps = (PropertyBag)this.getProcessingInfo().properties();
        processingProps.setProperty((Object)PropertyIDs.SI_DELIVERY_RULE_OPTIONS, deliveryRuleOptions);
    }

    public IDestinationPluginArtifactFormats getDefaultDestinationPluginArtifactFormats() {
        if (this.m_defaultDestinationPlugins == null) {
            PropertyBag formatsBag = ((PropertyBag)this.properties()).getPropertyBag((Object)PropertyIDs.SI_DEFAULT_DESTINATION_PLUGIN_FORMATS);
            if (formatsBag == null) {
                formatsBag = ((PropertyBag)this.properties()).addArray((Object)PropertyIDs.SI_DEFAULT_DESTINATION_PLUGIN_FORMATS).getPropertyBag();
            }
            this.m_defaultDestinationPlugins = new DestinationPluginArtifactFormats(formatsBag);
        }
        return this.m_defaultDestinationPlugins;
    }

    public void rerun() throws SDKException {
        this.getSchedulingInfo().setRightNow(true);
        int flag = 8;
        this.getSchedulingInfo().setFlags(flag);
        this.setProcessedRecipientCount(0);
        IInternalInfoStore infoStore = (IInternalInfoStore)InternalInfoStoreFactory.getFactory().makeOCCA(this.getSession().getAPSName(), this.getSession());
        IInfoObjects objs = infoStore.newInfoObjectCollection();
        objs.add(this);
        infoStore.schedule(objs, true, false);
    }

    public void setCleanupScopeBatch(boolean clean) {
        this.setProperty((Object)PropertyIDs.SI_CLEANUP_SCOPEBATCH, clean);
    }

    public boolean isCleanupScopeBatch() {
        if (this.properties().get(PropertyIDs.SI_CLEANUP_SCOPEBATCH) != null) {
            return this.properties().getBoolean(PropertyIDs.SI_CLEANUP_SCOPEBATCH);
        }
        return false;
    }

    public int getProcessedRecipientCount() {
        return this.properties().getInt(PropertyIDs.SI_NUM_PROCESSED_RECIPIENTS);
    }

    public void setProcessedRecipientCount(int numProcessedRecipients) {
        this.setProperty((Object)PropertyIDs.SI_NUM_PROCESSED_RECIPIENTS, numProcessedRecipients);
    }

    public int getSucceededRecipientCount() {
        return this.properties().getInt(PropertyIDs.SI_NUM_SUCCEEDED_RECIPIENTS);
    }

    public void setSucceededRecipientCount(int numSucceededRecipients) {
        this.setProperty((Object)PropertyIDs.SI_NUM_SUCCEEDED_RECIPIENTS, numSucceededRecipients);
    }

    public void setLastLogUploadPosition(String lastUpload) {
        this.setProperty((Object)PropertyIDs.SI_LAST_LOG_UPLOAD_POSITION, lastUpload);
    }

    public String getLastLogUploadPosition() {
        if (this.properties().get(PropertyIDs.SI_LAST_LOG_UPLOAD_POSITION) != null) {
            return this.properties().getString(PropertyIDs.SI_LAST_LOG_UPLOAD_POSITION);
        }
        return "";
    }

    public void setPreviousServerName(String previousApsName) {
        this.setProperty((Object)PropertyIDs.SI_PREVIOUS_SERVER_NAME, previousApsName);
    }

    public String getPreviousServerName() {
        if (this.properties().get(PropertyIDs.SI_PREVIOUS_SERVER_NAME) != null) {
            return this.properties().getString(PropertyIDs.SI_PREVIOUS_SERVER_NAME);
        }
        return "";
    }

    public static interface IEventHandlerChangeListener {
        public void pluginRemoved(Integer var1);
    }

    public static interface IProfileChangeListener {
        public void profileChanged();
    }
}

