/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.sdk.plugin.desktop.publication.internal;

import com.businessobjects.sdk.plugin.desktop.publication.IPublicationDocumentProfileTarget;
import com.businessobjects.sdk.plugin.desktop.publication.IPublicationDocumentProfileTargets;
import com.businessobjects.sdk.plugin.desktop.publication.internal.Publication;
import com.businessobjects.sdk.plugin.desktop.publication.internal.PublicationDocumentProfileTarget;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.internal.AbstractSDKSet;
import com.crystaldecisions.sdk.properties.internal.ISDKElement;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.AbstractSet;
import java.util.Iterator;

public class PublicationDocumentProfileTargets
extends AbstractSet
implements IPublicationDocumentProfileTargets {
    private final InnerSDKSet m_innerSet;
    private final Publication.IProfileChangeListener m_changeListener;

    public PublicationDocumentProfileTargets(PropertyBag bag, Publication.IProfileChangeListener changeListener) {
        this.m_innerSet = new InnerSDKSet(bag);
        this.m_changeListener = changeListener;
    }

    public IPublicationDocumentProfileTarget add(int docId) throws SDKException {
        PublicationDocumentProfileTarget target = new PublicationDocumentProfileTarget(this.m_changeListener);
        target.initialize();
        target.setSourceDocumentID(docId);
        this.m_innerSet.addNewObjectToCollection(target);
        return target;
    }

    public IPublicationDocumentProfileTarget getDocumentProfileTarget(int docId) throws SDKException {
        IPublicationDocumentProfileTarget pubDocProfileTarget = (IPublicationDocumentProfileTarget)this.m_innerSet.get(new Integer(docId));
        if (pubDocProfileTarget == null) {
            pubDocProfileTarget = this.add(docId);
        }
        return pubDocProfileTarget;
    }

    public boolean add(Object o) {
        boolean retVal = this.m_innerSet.add(o);
        if (this.m_changeListener != null) {
            this.m_changeListener.profileChanged();
        }
        return retVal;
    }

    public Iterator iterator() {
        return new WrappedIterator(this.m_innerSet.iterator());
    }

    public int size() {
        return this.m_innerSet.size();
    }

    public Object get(Object key) {
        return this.m_innerSet.get(key);
    }

    public boolean remove(Object o) {
        boolean retVal = this.m_innerSet.remove(o);
        if (this.m_changeListener != null) {
            this.m_changeListener.profileChanged();
        }
        return retVal;
    }

    private class WrappedIterator
    implements Iterator {
        private Iterator m_innerIterator;

        private WrappedIterator(Iterator it) {
            this.m_innerIterator = it;
        }

        public boolean hasNext() {
            return this.m_innerIterator.hasNext();
        }

        public Object next() {
            return this.m_innerIterator.next();
        }

        public void remove() {
            this.m_innerIterator.remove();
            if (PublicationDocumentProfileTargets.this.m_changeListener != null) {
                PublicationDocumentProfileTargets.this.m_changeListener.profileChanged();
            }
        }
    }

    private class InnerSDKSet
    extends AbstractSDKSet {
        private InnerSDKSet(PropertyBag bag) {
            super(bag, PropertyIDs.SI_TOTAL, PropertyIDs.SI_SOURCE_DOC_ID, false);
        }

        protected Object createCollectionObject(int index) {
            return new PublicationDocumentProfileTarget((IProperties)this.m_bag.get(index), PublicationDocumentProfileTargets.this.m_changeListener);
        }

        protected boolean addNewObjectToCollection(ISDKElement newObject) {
            return super.addNewObjectToCollection(newObject);
        }
    }
}

