/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.sdk.plugin.desktop.publication.internal;

import com.businessobjects.sdk.plugin.desktop.publication.IPublicationEventHandler;
import com.businessobjects.sdk.plugin.desktop.publication.IPublicationEventHandlers;
import com.businessobjects.sdk.plugin.desktop.publication.internal.Publication;
import com.businessobjects.sdk.plugin.desktop.publication.internal.PublicationEventHandler;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.IProperty;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.ArrayList;
import java.util.Iterator;

public class PublicationEventHandlers
implements IPublicationEventHandlers {
    private IProperties m_propBag;
    protected Publication.IEventHandlerChangeListener m_changeListener;

    public PublicationEventHandlers(IProperties bag, Publication.IEventHandlerChangeListener changeListener) {
        this.m_propBag = bag;
        this.m_changeListener = changeListener;
    }

    public String[] getPublicationEventHandlersName() throws SDKException {
        try {
            ArrayList<String> keyset = new ArrayList<String>();
            Iterator it = this.m_propBag.keySet().iterator();
            while (it.hasNext()) {
                Integer objId = (Integer)it.next();
                if ((this.m_propBag.getProperty(objId).getFlags() & 0x4000000) != 0) continue;
                keyset.add(PropertyIDs.idToName(objId));
            }
            return keyset.toArray(new String[keyset.size()]);
        }
        catch (Throwable e) {
            return new String[0];
        }
    }

    public IPublicationEventHandler addPublicationEventHandler(Integer eventNameID) throws SDKException {
        if (this.m_propBag.containsKey(eventNameID)) {
            return new PublicationEventHandler((PropertyBag)this.m_propBag.getProperty(eventNameID).getValue(), eventNameID, this.m_changeListener);
        }
        PropertyBag handlersBag = (PropertyBag)this.m_propBag.add(eventNameID, null, 0x8000000).getValue();
        return new PublicationEventHandler(handlersBag, eventNameID, this.m_changeListener);
    }

    public void setPublicationEventHandler(Integer eventNameID, PublicationEventHandler src) throws SDKException {
        src.m_changeListener = this.m_changeListener;
        if (this.m_propBag.containsKey(eventNameID)) {
            this.m_propBag.setProperty((Object)eventNameID, src);
        }
        IProperty newBag = this.m_propBag.add(eventNameID, null, 0x8000000);
        newBag.setValue(src);
    }

    public IPublicationEventHandler getPublicationEventHandler(Integer eventNameID) {
        IProperty prop = this.m_propBag.getProperty(eventNameID);
        if (prop == null || prop.getValue() == null) {
            return null;
        }
        return new PublicationEventHandler((PropertyBag)prop.getValue(), eventNameID, this.m_changeListener);
    }

    public void removePublicationEventHandler(Integer eventNameID) throws SDKException {
        if (this.m_propBag.containsKey(eventNameID)) {
            this.m_propBag.remove(eventNameID);
            if (this.m_changeListener != null) {
                this.m_changeListener.pluginRemoved(eventNameID);
            }
        }
    }
}

