/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.sdk.plugin.desktop.publication.internal;

import com.businessobjects.sdk.plugin.desktop.publication.IScope;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Scope
implements IScope {
    private Set m_principals;
    private Map m_profileValues;

    public static Scope emptyScope() {
        Map emptyMap = Collections.EMPTY_MAP;
        return new Scope(emptyMap);
    }

    Scope() {
        this(new HashMap());
    }

    private Scope(Scope other) {
        this(new HashMap(other.m_profileValues));
    }

    private Scope(Map profileValues) {
        this.m_profileValues = profileValues;
    }

    void initPrincipals() {
        this.m_principals = new HashSet();
    }

    Scope copyValues() {
        return new Scope(this);
    }

    void putProfileValue(int profileID, String formulaValue) {
        this.m_profileValues.put(new Integer(profileID), formulaValue);
    }

    void putPrincipal(int principalID) {
        this.m_principals.add(new Integer(principalID));
    }

    boolean conflicts(Scope other) {
        Iterator itr = this.m_profileValues.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry e1 = itr.next();
            Object otherValue = other.m_profileValues.get(e1.getKey());
            if (otherValue == null || otherValue.equals(e1.getValue())) continue;
            return true;
        }
        return false;
    }

    void merge(Scope other) {
        this.m_profileValues.putAll(other.m_profileValues);
    }

    public Set getPrincipals() {
        return Collections.unmodifiableSet(this.m_principals);
    }

    public Map getProfileValues() {
        return Collections.unmodifiableMap(this.m_profileValues);
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Scope s = (Scope)o;
        return ((Object)this.m_principals).equals(s.m_principals) && ((Object)this.m_profileValues).equals(s.m_profileValues);
    }

    public int hashCode() {
        return ((Object)this.m_principals).hashCode() ^ ((Object)this.m_profileValues).hashCode();
    }

    public String toString() {
        return "[principals=" + this.m_principals + ", profileValues=" + this.m_profileValues + "]";
    }
}

