/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.sdk.plugin.desktop.remotecluster.internal;

import com.businessobjects.sdk.plugin.desktop.remotecluster.ICleanupOptions;
import com.businessobjects.sdk.plugin.desktop.remotecluster.IRemoteCluster;
import com.businessobjects.sdk.plugin.desktop.remotecluster.internal.CleanupOptions;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.celib.stringhandler.StringHandler;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.ObjectID_Ex;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObject;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.properties.IProperty;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import com.crystaldecisions.sdk.properties.internal.SDKPropertyBag;

public class RemoteCluster
extends AbstractInfoObject
implements IRemoteCluster {
    private ICleanupOptions m_cleanupOptions;

    RemoteCluster() {
    }

    public void initialize(ISecuritySession session, IInfoObjects collection, ObjectID_Ex id, short type) throws SDKException {
        super.initialize(session, collection, id, type);
        this.setProperty((Object)PropertyIDs.SI_SYSTEM_OBJECT, Boolean.TRUE);
        this.setProperty((Object)PropertyIDs.SI_PARENT_CUID, "AVwSekNrtFxGqJ6Jp2rLwrI");
        ICleanupOptions cleanupOptions = this.getCleanupOptions();
        cleanupOptions.setCleanupInterval(24);
        cleanupOptions.setMaxCUIDsReturned(-1);
        cleanupOptions.setNextStartCUID("");
    }

    private Object getOption(Integer propId) throws SDKException {
        IProperty prop = this.getProperty(propId);
        if (prop == null) {
            return null;
        }
        return prop.getValue();
    }

    public void setClusterURI(String uri) {
        this.setProperty((Object)PropertyIDs.SI_CLUSTER_URI, uri);
    }

    public String getClusterURI() throws SDKException {
        return (String)this.getOption(PropertyIDs.SI_CLUSTER_URI);
    }

    public void setUserName(String userName) {
        this.setProperty((Object)PropertyIDs.SI_USERNAME, userName);
    }

    public String getUserName() throws SDKException {
        return (String)this.getOption(PropertyIDs.SI_USERNAME);
    }

    public void setPassword(String password) {
        this.addProperty(PropertyIDs.SI_CRED_KEY, password, 0x1800000);
    }

    public boolean isPasswordSet() {
        return this.getProperty(PropertyIDs.SI_CRED_KEY) != null;
    }

    public boolean isPasswordNotEmpty() {
        IProperty prop = this.getProperty(PropertyIDs.SI_CRED_KEY);
        StringHandler encrypter = ((PropertyBag)this.properties()).getStringHandler();
        return prop != null && !"".equals(encrypter.unpack((String)prop.getValue()));
    }

    public void setCMS(String cms) {
        this.setProperty((Object)PropertyIDs.SI_CLUSTER_NAME, cms);
    }

    public String getCMS() throws SDKException {
        return (String)this.getOption(PropertyIDs.SI_CLUSTER_NAME);
    }

    public void setAuthType(String authType) {
        this.setProperty((Object)PropertyIDs.SI_AUTH_TYPE, authType);
    }

    public String getAuthType() throws SDKException {
        return (String)this.getOption(PropertyIDs.SI_AUTH_TYPE);
    }

    public ICleanupOptions getCleanupOptions() throws SDKException {
        if (this.m_cleanupOptions == null) {
            PropertyBag cleanupOptions = ((PropertyBag)this.properties()).getPropertyBag((Object)PropertyIDs.SI_CLEANUP_OPTIONS);
            if (cleanupOptions == null) {
                cleanupOptions = new SDKPropertyBag();
                ((PropertyBag)this.properties()).setProperty((Object)PropertyIDs.SI_CLEANUP_OPTIONS, (Object)cleanupOptions);
            }
            this.m_cleanupOptions = new CleanupOptions(cleanupOptions);
        }
        return this.m_cleanupOptions;
    }
}

