/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.sdk.plugin.desktop.service.internal;

import com.businessobjects.sdk.plugin.desktop.common.IConfigProperties;
import com.businessobjects.sdk.plugin.desktop.common.IConfiguredContainer;
import com.businessobjects.sdk.plugin.desktop.common.IConfiguredServices;
import com.businessobjects.sdk.plugin.desktop.common.IInstalledObjects;
import com.businessobjects.sdk.plugin.desktop.common.IIntegerProps;
import com.businessobjects.sdk.plugin.desktop.common.internal.ConfigProperties;
import com.businessobjects.sdk.plugin.desktop.common.internal.ConfigProperty;
import com.businessobjects.sdk.plugin.desktop.common.internal.ConfiguredService;
import com.businessobjects.sdk.plugin.desktop.common.internal.ConfiguredServices;
import com.businessobjects.sdk.plugin.desktop.common.internal.InstalledObject;
import com.businessobjects.sdk.plugin.desktop.common.internal.InstalledObjects;
import com.businessobjects.sdk.plugin.desktop.common.internal.IntegerProps;
import com.businessobjects.sdk.plugin.desktop.service.internal.IInternalService;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.ObjectID_Ex;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObjectEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoObjectEvent;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoObjectEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoStore;
import com.crystaldecisions.sdk.occa.infostore.internal.ObjectRelatives;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.plugin.desktop.server.IServer;
import com.crystaldecisions.sdk.plugin.desktop.server.IServiceDeploymentConfig;
import com.crystaldecisions.sdk.plugin.desktop.server.internal.ServiceDeploymentConfig;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

class Service
extends AbstractInfoObject
implements IInternalService {
    private Set m_DepServiceIDSet;
    private Set m_ParentServiceIDSet;
    private Set m_containerIDs;
    protected PropertyArrayHelper m_deltaHelper;
    private ConfiguredServices m_configuredServices;
    private InstalledObjects m_installedServices;
    private Set m_svcCategories;
    private Set m_objRels = new HashSet();

    Service() {
    }

    public IInfoObjectEventListener getInfoObjectEventListener(int type) {
        final IInfoObjectEventListener superListener = super.getInfoObjectEventListener(type);
        if (type == 2) {
            return new AbstractInfoObjectEventListener(){

                protected void processEvent(IInfoObjectEvent event) throws SDKException {
                    PropertyBag configProps;
                    Property cp;
                    if (Service.this.isNew()) {
                        Service.this.getDependingServices();
                        Service.this.getParentService();
                    }
                    IInternalInfoStore infoStore = event.getInfoStore();
                    Property prop = (Property)Service.this.properties().get(PropertyIDs.SI_ADM_ADD_SI_SERVER);
                    if (prop != null && prop.isContainer()) {
                        PropertyBag bag = prop.getPropertyBag();
                        Iterator bagIter = bag.allIterator();
                        while (bagIter.hasNext()) {
                            Property edgeProp = (Property)bagIter.next();
                            if (!edgeProp.isContainer()) continue;
                            PropertyBag edgeContainer = edgeProp.getPropertyBag();
                            Service.this.checkServiceSupported(infoStore, edgeContainer);
                            Service.this.pushInstallProps(infoStore, edgeContainer);
                            Service.this.pushServiceProps(edgeContainer);
                        }
                    }
                    if ((cp = (Property)Service.this.properties().getProperty(PropertyIDs.SI_CONFIG)) != null && (configProps = cp.getPropertyBag()).isDirty()) {
                        IConfiguredServices css = Service.this.getServiceHosts();
                        Iterator cssIter = css.iterator();
                        while (cssIter.hasNext()) {
                            ConfiguredService cs = (ConfiguredService)cssIter.next();
                            if (!cs.isUsingServiceConfigProps()) continue;
                            cs.applyServiceConfigProps();
                        }
                    }
                    if (!Service.this.isNew()) {
                        Service.this.processObjectRelatives(Service.this.m_objRels);
                        Service.this.propagateInstalledServiceRemoval(infoStore);
                    }
                }

                protected IInfoObjectEventListener getSuperEventListener() {
                    return superListener;
                }
            };
        }
        return superListener;
    }

    private void checkServiceSupported(IInternalInfoStore infoStore, PropertyBag bag) throws SDKException {
        String serverQuery = "select SI_CONFIGURED_CONTAINERS from CI_SYSTEMOBJS where SI_PARENTID = 16 and SI_ID = ";
        int serverID = bag.getInt((Object)PropertyIDs.SI_ID);
        IInfoObjects objs = infoStore.query(serverQuery + serverID);
        if (objs == null || objs.size() != 1) {
            throw new SDKException.ServiceNotSupported(serverID, this.getID());
        }
        IServer server = (IServer)objs.get(0);
        IConfiguredContainer cc = server.getContainer();
        if (cc == null) {
            throw new SDKException.ServiceNotSupported(serverID, this.getID());
        }
        int ccID = cc.getID();
        if (!this.getContainers().contains(new Integer(ccID))) {
            throw new SDKException.ServiceNotSupported(serverID, this.getID());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void pushInstallProps(IInternalInfoStore istore, PropertyBag destBag) throws SDKException {
        int serverID = destBag.getInt((Object)PropertyIDs.SI_ID);
        String q = "SELECT SI_ID FROM CI_SYSTEMOBJECTS WHERE PARENTS(\"SI_NAME='EnterpriseNode-Server'\", \"SI_ID=" + serverID + "\")";
        IInfoObjects objs = istore.query(q);
        if (objs.size() <= 0) throw new SDKException.PropagationNotPossible("Enterprise Node", "Server", serverID);
        int enterpriseNodeID = ((IInfoObject)objs.get(0)).getID();
        String q2 = "SELECT SI_ID FROM CI_SYSTEMOBJECTS WHERE PARENTS(\"SI_NAME='Install-EnterpriseNode'\", \"SI_ID=" + enterpriseNodeID + "\")";
        IInfoObjects objs2 = istore.query(q2);
        if (objs2.size() <= 0) throw new SDKException.PropagationNotPossible("Install", "Enterprise Node", enterpriseNodeID);
        int installID = ((IInfoObject)objs2.get(0)).getID();
        InstalledObject instObj = (InstalledObject)this.getServiceInstalls().get(installID);
        if (instObj == null) {
            throw new SDKException.PropagationNotPossible("Install", "Service", this.getID());
        }
        PropertyBag origProps = instObj.getPropertyBag();
        Iterator origPropIter = origProps.allIterator();
        while (origPropIter.hasNext()) {
            PropertyBag origPropSubBag;
            Property origProp = (Property)origPropIter.next();
            Integer origPropID = origProp.getID();
            if (origPropID.equals(PropertyIDs.SI_ID) || origPropID.equals(PropertyIDs.SI_OBJ_VERSION)) continue;
            Property destProp = destBag.getItem((Object)origPropID);
            if (destProp == null || destProp.getValue() == null || destProp.getValue() == "") {
                destBag.addItem((Object)origPropID, origProp.getValue(), 0);
                continue;
            }
            if (!origProp.isContainer() || (origPropSubBag = origProp.getPropertyBag()).getItem((Object)PropertyIDs.SI_TOTAL) != null || !destProp.isContainer()) continue;
            PropertyBag destPropSubBag = destProp.getPropertyBag();
            Iterator origPropSubBagIter = origPropSubBag.allIterator();
            while (origPropSubBagIter.hasNext()) {
                Property prop = (Property)origPropSubBagIter.next();
                Property item = destPropSubBag.getItem((Object)prop.getID());
                if (item != null && item.getValue() != null && item.getValue() != "") continue;
                destPropSubBag.addItem((Object)prop.getID(), prop.getValue(), 0);
            }
        }
    }

    private void pushServiceProps(PropertyBag destBag) throws SDKException {
        ConfiguredService edge = new ConfiguredService(destBag, new PropertyBag());
        if (destBag.getItem((Object)PropertyIDs.SI_DEPLOYMENT_DESCRIPTOR) == null && this.properties().getProperty(PropertyIDs.SI_DEPLOYMENT_DESCRIPTOR) != null) {
            IServiceDeploymentConfig edgeDeploy = edge.getDeploymentConfig();
            ((ServiceDeploymentConfig)this.getDeploymentConfig()).copyTo(edgeDeploy);
        }
        edge.setCUID(this.getCUID());
        edge.setServiceVersion(this.getServiceVersion());
        edge.setType(this.getType());
        edge.useCustomConfigProps();
        IConfigProperties configProps = this.getConfigProps();
        if (configProps != null && !configProps.isEmpty()) {
            ConfigProperties edgeConfigProps = (ConfigProperties)edge.getConfigProps();
            String[] names = configProps.getPropNames();
            for (int i = 0; i < names.length; ++i) {
                if (edgeConfigProps.getProp(names[i]) != null) continue;
                ConfigProperty srcConfig = (ConfigProperty)configProps.get(names[i]);
                edgeConfigProps.addProp(srcConfig);
            }
        }
    }

    private void propagateInstalledServiceRemoval(IInternalInfoStore infoStore) throws SDKException {
        Property prop = (Property)this.properties().get(PropertyIDs.SI_ADM_DEL_SI_SERVICE_INSTALL);
        if (prop != null) {
            PropertyBag bag = prop.getPropertyBag();
            Iterator iter = bag.allIterator();
            HashSet<Integer> ids = new HashSet<Integer>();
            while (iter.hasNext()) {
                Property p = (Property)iter.next();
                if ((p.getFlags() & 0x8000000) == 0) continue;
                PropertyBag pb = p.getPropertyBag();
                ids.add(new Integer(pb.getInt((Object)PropertyIDs.SI_ID)));
            }
            Iterator iter2 = ids.iterator();
            while (iter2.hasNext()) {
                Integer installID = (Integer)iter2.next();
                String query = "select SI_HOSTED_SERVICES from CI_SYSTEMOBJECTS where CHILDREN(\"SI_NAME='EnterpriseNode-Server'\",\"CHILDREN('SI_NAME=''Install-EnterpriseNode''', 'SI_ID=" + installID + "')\")";
                IInfoObjects infoObjs = infoStore.query(query);
                if (infoObjs.size() != 1) continue;
                throw new SDKException.ServiceInUse(this.getID());
            }
        }
    }

    public void initialize(ISecuritySession session, IInfoObjects collection, ObjectID_Ex id, short type) throws SDKException {
        super.initialize(session, collection, id, type);
        this.setProperty((Object)PropertyIDs.SI_SYSTEM_OBJECT, Boolean.TRUE);
        this.setProperty((Object)PropertyIDs.SI_PARENT_CUID, "AYHAA_QSVttBrtqoWXCsDso");
        this.setProperty((Object)PropertyIDs.SI_PARENTID, 52);
    }

    public Set getDependingServices() throws SDKException {
        if (this.m_DepServiceIDSet == null) {
            this.m_DepServiceIDSet = new ObjectRelatives();
            ((ObjectRelatives)this.m_DepServiceIDSet).initialize(PropertyIDs.SI_DEPENDENT_SERVICES, "SI_SERVICE_DEPCHILD", this.properties(), false, this.isNew());
        }
        return this.m_DepServiceIDSet;
    }

    public Set getParentService() throws SDKException {
        if (this.m_ParentServiceIDSet == null) {
            this.m_ParentServiceIDSet = new ObjectRelatives();
            ((ObjectRelatives)this.m_ParentServiceIDSet).initialize(PropertyIDs.SI_SERVICE_DEPENDENCIES, "SI_SERVICE_DEPPARENT", this.properties(), false, this.isNew());
        }
        return this.m_ParentServiceIDSet;
    }

    public IConfigProperties getConfigProps() {
        PropertyBag propertyBag = (PropertyBag)this.properties();
        PropertyBag bag = propertyBag.getPropertyBag((Object)PropertyIDs.SI_CONFIG);
        if (bag == null) {
            return null;
        }
        return new ConfigProperties(bag);
    }

    public IConfigProperties addConfigProps() {
        PropertyBag propertyBag = (PropertyBag)this.properties();
        PropertyBag bag = propertyBag.getPropertyBag((Object)PropertyIDs.SI_CONFIG);
        if (bag == null) {
            String name = PropertyIDs.idToName(PropertyIDs.SI_CONFIG);
            bag = propertyBag.addItem((Object)name, null, 0x8000000).getPropertyBag();
        }
        return new ConfigProperties(bag);
    }

    public IServiceDeploymentConfig getDeploymentConfig() throws SDKException {
        return new ServiceDeploymentConfig((PropertyBag)this.properties());
    }

    public IConfiguredServices getServiceHosts() throws SDKException {
        if (this.m_configuredServices == null) {
            this.m_configuredServices = new ConfiguredServices();
            Property configProp = (Property)this.properties().getProperty(PropertyIDs.SI_CONFIG);
            if (configProp == null) {
                configProp = (Property)this.properties().add(PropertyIDs.SI_CONFIG, new Integer(0), 0x8000000);
            }
            PropertyBag configProps = configProp.getPropertyBag();
            this.m_configuredServices.initialize((Object)PropertyIDs.SI_SERVICE_HOSTS, "SI_SERVER", (AbstractInfoObject)this, configProps);
        }
        return this.m_configuredServices;
    }

    public IInstalledObjects getServiceInstalls() throws SDKException {
        if (this.m_installedServices == null) {
            this.m_installedServices = new InstalledObjects();
            this.m_installedServices.initialize(PropertyIDs.SI_SERVICE_INSTALLS, "SI_SERVICE_INSTALL", this);
        }
        return this.m_installedServices;
    }

    public Set getContainers() throws SDKException {
        if (this.m_containerIDs == null) {
            this.m_containerIDs = new ObjectRelatives();
            ((ObjectRelatives)this.m_containerIDs).initialize((Object)PropertyIDs.SI_SERVICEC4SERVICE, this.properties(), false, this.isNew());
        }
        return this.m_containerIDs;
    }

    public void setServiceVersion(int version) {
        this.properties().setProperty((Object)PropertyIDs.SI_SERVICE_VERSION, version);
    }

    public int getServiceVersion() {
        return this.properties().getInt(PropertyIDs.SI_SERVICE_VERSION);
    }

    public void setType(String type) {
        this.properties().setProperty((Object)PropertyIDs.SI_SERVICE_TYPE, type);
    }

    public String getType() {
        return this.properties().getString(PropertyIDs.SI_SERVICE_TYPE);
    }

    public IIntegerProps getSupportedAuditEvents() {
        PropertyBag propertyBag = (PropertyBag)this.properties();
        PropertyBag bag = propertyBag.getPropertyBag((Object)PropertyIDs.SI_SUPPORTED_AUDIT_EVENTS);
        if (bag == null) {
            bag = propertyBag.addItem((Object)PropertyIDs.SI_SUPPORTED_AUDIT_EVENTS, null, 0x8000000).getPropertyBag();
        }
        return new IntegerProps(bag, true);
    }

    public String getDescription(Locale locale) throws SDKException {
        PropertyBag bag = (PropertyBag)this.properties().getProperties(PropertyIDs.SI_ML_DESCRIPTION);
        if (bag != null) {
            try {
                return bag.getString(locale);
            }
            catch (Exception e) {
                throw new SDKException.PropertyNotFound(PropertyIDs.SI_ML_DESCRIPTION);
            }
        }
        throw new SDKException.PropertyNotFound(PropertyIDs.SI_ML_DESCRIPTION);
    }

    public void setDescription(String description, Locale locale) {
        PropertyBag propertyBag = (PropertyBag)this.properties();
        PropertyBag bag = propertyBag.getPropertyBag((Object)PropertyIDs.SI_ML_DESCRIPTION);
        if (bag == null) {
            bag = propertyBag.addItem((Object)PropertyIDs.SI_ML_DESCRIPTION, null, 0x8000000).getPropertyBag();
        }
        bag.setString(locale, description);
    }

    public int getServiceClass() {
        return this.properties().getInt(PropertyIDs.SI_SERVICE_CLASS);
    }

    public Set getServiceCategories() {
        PropertyBag propBag;
        PropertyBag bag;
        if (this.m_svcCategories == null && (bag = (propBag = (PropertyBag)this.properties()).getPropertyBag((Object)PropertyIDs.SI_SERVICE_CATEGORIES)) != null) {
            this.m_svcCategories = new IntegerProps(bag, true);
        }
        return this.m_svcCategories;
    }

    public Set getObjectRelatives() {
        return this.m_objRels;
    }
}

