/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.enterprise.ocaframework;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.collections.EmptyCollections;
import com.crystaldecisions.celib.parser.Driver;
import com.crystaldecisions.celib.parser.Operator;
import com.crystaldecisions.celib.parser.ParseException;
import com.crystaldecisions.celib.properties.CaseInsensComparator;
import com.crystaldecisions.celib.properties.IDHelper;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.celib.properties.QBSet;
import com.crystaldecisions.celib.properties.QueryEngine;
import com.crystaldecisions.enterprise.ocaframework.APSComparator;
import com.crystaldecisions.enterprise.ocaframework.IDirectory;
import com.crystaldecisions.enterprise.ocaframework.IPropertyBag;
import com.crystaldecisions.enterprise.ocaframework.IServerHandler;
import com.crystaldecisions.enterprise.ocaframework.OCAFrameworkException;
import com.crystaldecisions.enterprise.ocaframework.PropertyIDs;
import com.crystaldecisions.enterprise.ocaframework.ServerController;
import com.crystaldecisions.enterprise.ocaframework.ServerSpec;
import com.crystaldecisions.enterprise.ocaframework.ServiceMgr;
import com.crystaldecisions.enterprise.ocaframework.ServiceMgrFactory;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;
import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractServerHandler
implements IServerHandler {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.enterprise.ocaframework.AbstractServerHandler");
    protected static final Integer APS_NAME = PropertyIDs.define("APS_NAME");
    protected static final Integer SERVER_NAME = ServerController.SERVER_NAME;
    protected static final Integer SERVER_VALID = ServerController.SERVER_VALID;
    protected static final Integer SERVER_TIMESTAMP = PropertyIDs.define("SERVER_TIMESTAMP");
    protected static final Integer SI_TIMESTAMP = PropertyIDs.SI_TIMESTAMP;
    protected static final String MAGIC_URI = "osca:iiop://;BYPASSSEC=true";
    protected static final String MAGIC_URI2 = "osca:iiop://;S2SDSCVRY=true";
    protected static final Integer VALID = ServerController.VALID;
    protected static final Integer INVALID = ServerController.INVALID;
    protected static final Integer INVALID_FAILED = ServerController.INVALID_FAILED;
    protected QBSet m_servers;
    protected static final int MATCH = 0;
    protected static final int NOT_MATCH = 1;
    private static final String DEFAULT_QUERY_IDS = IDHelper.toQueryString((Integer[])new Integer[]{PropertyIDs.SI_SERVER_NAME, PropertyIDs.SI_SERVER_KIND, PropertyIDs.SI_SERVER_IS_ALIVE, PropertyIDs.SI_SERVER_IOR, PropertyIDs.SI_TIMESTAMP, PropertyIDs.SI_DISABLED});
    protected String m_queryIDsString = DEFAULT_QUERY_IDS;
    protected static final int TRUE = 1;
    private static final Comparator m_defaultComparator = new CaseInsensComparator();

    protected AbstractServerHandler() {
        Integer[] indexes = new Integer[]{PropertyIDs.SI_CLUSTER_NAME, APS_NAME, SERVER_NAME, PropertyIDs.SI_NAME, PropertyIDs.SI_SERVER_KIND, PropertyIDs.GROUP_ID};
        Comparator[] comparators = new Comparator[]{m_defaultComparator, new APSComparator(), m_defaultComparator, m_defaultComparator, m_defaultComparator, null};
        this.m_servers = new QBSet(indexes, comparators);
    }

    protected AbstractServerHandler(Integer[] indexes, Comparator[] comparators) {
        LOG.assertTrue(indexes.length == comparators.length, "length should be equal");
        this.m_servers = new QBSet(indexes, comparators);
    }

    protected void addIndexProperty(Integer id, Comparator comparator) {
        if (comparator == null) {
            comparator = m_defaultComparator;
        }
        this.m_servers.addIndex(id, comparator);
    }

    protected void addQueryProperty(Integer id) {
        this.m_queryIDsString = this.m_queryIDsString + ',' + IDHelper.idToName((Integer)id);
    }

    public void manageCache() {
        Iterator iter = this.m_servers.bags().iterator();
        long now = System.currentTimeMillis();
        while (iter.hasNext()) {
            PropertyBag bag = (PropertyBag)iter.next();
            Property validProp = bag.getItem((Object)SERVER_VALID);
            if (validProp == null || !VALID.equals(validProp.getValue()) || bag.getLong((Object)SERVER_TIMESTAMP) + 60000L >= now) continue;
            bag.setProperty((Object)SERVER_VALID, (Object)INVALID);
        }
    }

    public void invalidateServer(ServerSpec spec) {
        Set results = this.getServerPropertyBag(spec);
        Iterator iterator = results.iterator();
        while (iterator.hasNext()) {
            IPropertyBag bag = (IPropertyBag)iterator.next();
            bag.setProperty((Object)SERVER_VALID, INVALID_FAILED);
        }
    }

    public void buildServerInfo(ServerSpec spec, String uri, IDirectory directory) throws OCAFrameworkException {
        IPropertyBag[] found = directory.find(spec, uri, this.m_queryIDsString, 0);
        Long now = new Long(System.currentTimeMillis());
        for (int i = 0; i < found.length; ++i) {
            IPropertyBag bag = found[i];
            bag.setProperty((Object)SERVER_TIMESTAMP, now);
            bag.setProperty((Object)PropertyIDs.SI_CLUSTER_NAME, spec.getCluster());
            bag.setProperty((Object)APS_NAME, spec.getAPS());
            bag.setProperty((Object)SERVER_NAME, bag.getString(PropertyIDs.SI_NAME));
            if (bag.getInt(PropertyIDs.SI_SERVER_IS_ALIVE) == 1 && !bag.getBoolean(PropertyIDs.SI_DISABLED)) {
                bag.setProperty((Object)SERVER_VALID, this.checkServerAliveness(bag));
            } else {
                bag.setProperty((Object)SERVER_VALID, INVALID);
            }
            this.clearServerInfo(new ServerSpec(bag.getString(SERVER_NAME), bag.getString(PropertyIDs.SI_SERVER_KIND), spec.getAPS(), spec.getCluster()));
            String svrKind = bag.getString(PropertyIDs.SI_SERVER_KIND);
            if (!svrKind.equals("INVALID")) {
                spec.setKind(svrKind);
            }
            LOG.assertTrue(this.m_servers.add((PropertyBag)bag), "buildServerInfo(): adding to cache should succeed");
        }
    }

    public void buildClusterInfo(ServerSpec spec, String uri, IDirectory directory) throws OCAFrameworkException {
        this.buildServerInfo(this.getClusterSpec(spec), uri, directory);
    }

    private ServerSpec getClusterSpec(ServerSpec spec) {
        ServerSpec clusterSpec = new ServerSpec(spec);
        clusterSpec.setName("");
        return clusterSpec;
    }

    public Set queryServer(ServerSpec spec, boolean validOnly) {
        boolean bUnpreferServer;
        ServerSpec svr = spec;
        boolean bl = bUnpreferServer = 2 == svr.getAdditionalConfig().getInt((Object)PropertyIDs.define("SI_SERVER_PREF"));
        if (bUnpreferServer) {
            svr = new ServerSpec(spec);
            svr.setName("");
        }
        QBSet.Query svrQuery = this.buildServerQuery(svr);
        this.processCriteria(svr, svrQuery);
        Set results = this.m_servers.query(svrQuery);
        if (validOnly) {
            this.filterServers(results, SERVER_VALID, 0, VALID);
        }
        if (bUnpreferServer && !"".equals(spec.getName()) && results.size() > 1) {
            this.filterServers(results, SERVER_NAME, 1, spec.getName());
        }
        return results;
    }

    protected QBSet.Query buildServerQuery(ServerSpec spec) {
        String name = spec.getName();
        String kind = spec.getKind();
        String cluster = spec.getCluster();
        String aps = spec.getAPS();
        QBSet.Query svrQuery = new QBSet.Query();
        if (!name.equals("")) {
            svrQuery.addTerm(SERVER_NAME, (Object)name);
            if (!kind.equals("") && !kind.equals("INVALID")) {
                svrQuery.addTerm(PropertyIDs.SI_SERVER_KIND, (Object)kind);
            }
        } else {
            if (kind.equals("")) {
                LOG.assertTrue(false, "queryServer(): either name or kind must be specified");
            } else {
                svrQuery.addTerm(PropertyIDs.SI_SERVER_KIND, (Object)kind);
            }
            if (spec.getGroupMode() != 0) {
                svrQuery.addTerm(PropertyIDs.GROUP_ID, (Object)new Integer(spec.getGroup()));
            }
        }
        if (!"".equals(aps)) {
            svrQuery.addTerm(APS_NAME, (Object)aps);
        }
        if (!"".equals(cluster)) {
            svrQuery.addTerm(PropertyIDs.SI_CLUSTER_NAME, (Object)cluster);
        }
        return svrQuery;
    }

    protected void processCriteria(ServerSpec spec, QBSet.Query svrQuery) {
        String criteria = spec.getCriteria();
        if (criteria != null && criteria.length() != 0) {
            Operator op = spec.getOperator();
            if (op == null) {
                StringReader sr = new StringReader(criteria);
                BufferedReader r = new BufferedReader(sr);
                Driver dr = new Driver((Reader)r);
                try {
                    op = dr.SQLExpression();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    return;
                }
                spec.setOperator(op);
            }
            QueryEngine.execute((QBSet.Query)svrQuery, (Operator)op);
        }
    }

    public Iterator serversIterator(ServerSpec spec, String uri, IDirectory directory) throws OCAFrameworkException {
        if (spec.getGroupMode() == 1) {
            ServerSpec noGroup = new ServerSpec(spec);
            noGroup.setGroupMode(0);
            return Arrays.asList(noGroup).iterator();
        }
        return EmptyCollections.SET.iterator();
    }

    public Set queryCluster(ServerSpec spec, boolean validOnly) {
        ServerSpec copy = new ServerSpec(spec);
        copy.setName("");
        Set servers = this.queryServer(copy, validOnly);
        return servers;
    }

    public IPropertyBag selectServer(Collection servers) {
        int randomChoice = (int)(Math.random() * (double)servers.size());
        Iterator iter = servers.iterator();
        IPropertyBag server = null;
        for (int i = 0; i <= randomChoice && iter.hasNext(); ++i) {
            server = (IPropertyBag)iter.next();
        }
        return server;
    }

    protected Integer checkServerAliveness(IPropertyBag bag) {
        Integer valid;
        String name = bag.getString(SERVER_NAME);
        String aps = bag.getString(APS_NAME);
        String cluster = bag.getString(PropertyIDs.SI_CLUSTER_NAME);
        String kind = bag.getString(PropertyIDs.SI_SERVER_KIND);
        Set failedServers = this.queryServer(new ServerSpec(name, kind, aps, cluster), false);
        this.filterServers(failedServers, SERVER_VALID, 0, INVALID_FAILED);
        if (failedServers.size() != 0) {
            valid = INVALID_FAILED;
            String ior = bag.getString(PropertyIDs.SI_SERVER_IOR);
            if (ior != null) {
                try {
                    ServiceMgr serviceMgr = (ServiceMgr)ServiceMgrFactory.getServiceMgr();
                    com.crystaldecisions.thirdparty.org.omg.CORBA.Object object = serviceMgr.getORB().string_to_object(ior);
                    object = serviceMgr.setTimeoutPolicy(object);
                    if (!object._non_existent()) {
                        valid = VALID;
                    }
                }
                catch (SystemException t) {
                    LOG.warn((Object)("buildServerInfo() 307: server probably has crashed, aps=" + aps + ",name=" + name), (Throwable)t);
                }
            }
        } else {
            valid = VALID;
        }
        return valid;
    }

    protected void filterServers(Set servers, Object filteredName, int mode, Object filteredValue) {
        Iterator iter = servers.iterator();
        while (iter.hasNext()) {
            PropertyBag bag = (PropertyBag)iter.next();
            Property prop = bag.getItem(filteredName);
            if (prop != null) {
                switch (mode) {
                    case 0: {
                        if (filteredValue.equals(prop.getValue())) break;
                        iter.remove();
                        break;
                    }
                    case 1: {
                        if (!filteredValue.equals(prop.getValue())) break;
                        iter.remove();
                    }
                }
                continue;
            }
            iter.remove();
        }
    }

    public void clearServerInfo(ServerSpec spec) {
        Set results = this.getServerPropertyBag(spec);
        this.m_servers.removeAll((Collection)results);
    }

    protected Set getServerPropertyBag(ServerSpec spec) {
        String name = spec.getName();
        String kind = spec.getKind();
        String cluster = spec.getCluster();
        String aps = spec.getAPS();
        QBSet.Query svrQuery = new QBSet.Query();
        if (!name.equals("")) {
            svrQuery.addTerm(SERVER_NAME, (Object)name);
        }
        if (!kind.equals("") && !kind.equals("INVALID")) {
            svrQuery.addTerm(PropertyIDs.SI_SERVER_KIND, (Object)kind);
        }
        if (!"".equals(aps)) {
            svrQuery.addTerm(APS_NAME, (Object)aps);
        }
        if (!"".equals(cluster)) {
            svrQuery.addTerm(PropertyIDs.SI_CLUSTER_NAME, (Object)cluster);
        }
        this.processCriteria(spec, svrQuery);
        Set results = this.m_servers.query(svrQuery);
        return results;
    }

    public void fillServerSpec(IPropertyBag bag, ServerSpec spec) {
        spec.setName(bag.getString(SERVER_NAME));
        if ("".equals(spec.getKind())) {
            spec.setKind(bag.getString(PropertyIDs.SI_SERVER_KIND));
        }
        spec.setCluster(bag.getString(PropertyIDs.SI_CLUSTER_NAME));
        spec.setAPS(bag.getString(APS_NAME));
    }

    protected Set query(Map map) {
        QBSet.Query query = new QBSet.Query();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry term = iterator.next();
            if (!(term.getKey() instanceof Integer) || term.getValue() == null) continue;
            query.addTerm((Integer)term.getKey(), term.getValue());
        }
        return this.m_servers.query(query);
    }

    protected void addServer(IPropertyBag serverInfo) {
        this.m_servers.add((PropertyBag)serverInfo);
    }

    QBSet getServers() {
        return this.m_servers;
    }

    void setServers(QBSet servers) {
        this.m_servers = servers;
    }

    public String toString() {
        return "AbstractServerHandler: servers=" + this.m_servers;
    }

    public void pingServers() {
    }

    public String getServerIOR(IPropertyBag server, ServerSpec spec) {
        return server.getString(PropertyIDs.SI_SERVER_IOR);
    }
}

