/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.enterprise.ocaframework;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.holder.StringHolder;
import com.crystaldecisions.celib.synchronization.RWLock;
import com.crystaldecisions.celib.synchronization.SynchronizationException;
import com.crystaldecisions.enterprise.ocaframework.FailoverLogonService;
import com.crystaldecisions.enterprise.ocaframework.IManagedService;
import com.crystaldecisions.enterprise.ocaframework.ManagedService;
import com.crystaldecisions.enterprise.ocaframework.ManagedSessions;
import com.crystaldecisions.enterprise.ocaframework.OCAFrameworkException;
import com.crystaldecisions.enterprise.ocaframework.PropertyIDs;
import com.crystaldecisions.enterprise.ocaframework.ServerSpec;
import com.crystaldecisions.enterprise.ocaframework.ServiceKey;
import com.crystaldecisions.enterprise.ocaframework.ServiceMgr;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

class ManagedSession {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.enterprise.ocaframework.ManagedSession");
    private static final Set IGNORED_IDs = new HashSet(4);
    private static final int OK = 1;
    private static final int INVALID = 2;
    private static final int EXPIRED = 3;
    private static final int LOGGED_OFF = 4;
    private RWLock m_rwlock;
    private ServiceMgr m_mgr;
    private ManagedSessions m_sessions;
    private int m_state;
    private String m_aps;
    private String m_uri;
    private String m_token;
    private Map m_services;
    private int m_lastID;
    private Integer SI_SERVER_PREF = PropertyIDs.define("SI_SERVER_PREF");
    private static final int NUM_RECONNECT_RETRIES = 5;
    private static final String FAILEDOVER_CMS_STARTID = "try <";
    private static final int FAILEDOVER_CMS_STARTID_LENGTH;
    private static final String FAILEDOVER_CMS_ENDID = ">";

    ManagedSession(ServiceMgr mgr, ManagedSessions sessions, String aps, String uri, String token) throws OCAFrameworkException {
        this.m_mgr = mgr;
        this.m_sessions = sessions;
        this.m_aps = aps;
        this.m_uri = uri;
        this.m_token = token;
        this.m_state = 1;
        this.m_services = new HashMap();
        this.m_rwlock = new RWLock();
    }

    String getAPS() {
        return this.m_aps;
    }

    String getURI() {
        return this.m_uri;
    }

    String getToken() {
        return this.m_token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ManagedService get(String id, String svc, ServerSpec spec, IManagedService.IHelperFactory helper) throws OCAFrameworkException {
        this.validate();
        if (this.m_sessions.canRedirectServer(spec) && "LB_ID".equals(id)) {
            this.redirectServer(spec);
        }
        ManagedService service = null;
        if ("NEW_ID".equals(id)) {
            this.lockModify();
            try {
                id = this.m_lastID++ + "und";
                ManagedService managedService = this.newService(spec, id, svc, helper);
                return managedService;
            }
            finally {
                this.releaseLock();
            }
        }
        String name = spec.getName();
        String serverkind = spec.getKind();
        this.lock();
        try {
            service = this.getService(id, svc, name, spec.getGroup(), spec.getGroupMode(), serverkind, spec.getCriteria());
        }
        finally {
            this.releaseLock();
        }
        if (service != null) {
            return service;
        }
        this.lockModify();
        try {
            service = this.getService(id, svc, name, spec.getGroup(), spec.getGroupMode(), serverkind, spec.getCriteria());
            if (service != null) {
                ManagedService managedService = service;
                return managedService;
            }
            service = this.newService(spec, id, svc, helper);
        }
        finally {
            this.releaseLock();
        }
        LOG.assertNotNull((Object)service, "service is null.");
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validate() throws OCAFrameworkException {
        this.lock();
        try {
            if (this.isLoggedOff()) {
                throw new OCAFrameworkException.LogonFailover(this.m_aps, null);
            }
            if (!this.isExpired()) {
                return;
            }
        }
        finally {
            this.releaseLock();
        }
        this.lockModify();
        try {
            this.m_state = 1;
        }
        finally {
            this.releaseLock();
        }
    }

    private void redirectServer(ServerSpec spec) throws OCAFrameworkException {
        try {
            this.m_mgr.redirectServer(spec, this.m_uri);
            this.m_sessions.setServerRedirected(true);
        }
        catch (OCAFrameworkException e) {
            if (!"aps".equals(spec.getKind())) {
                this.lockModify();
                try {
                    if (!this.m_aps.equals(spec.getAPS()) && this.m_state == 1) {
                        spec.setAPS(this.m_aps);
                        this.m_mgr.redirectServer(spec, this.m_uri);
                    } else {
                        this.ensureAPS(spec);
                        spec.setAPS(this.m_aps);
                        this.m_mgr.redirectServer(spec, this.m_uri);
                    }
                    this.m_sessions.setServerRedirected(true);
                }
                catch (OCAFrameworkException ex) {
                    LOG.warn((Object)"(redirectServer:316): best effort", (Throwable)((Object)ex));
                    throw ex;
                }
                finally {
                    this.releaseLock();
                }
            }
            LOG.warn((Object)"(redirectServer:322): this will happen only if all the CMSes dies. Ignore since it is best effort", (Throwable)((Object)e));
        }
    }

    private void ensureAPS(ServerSpec spec) throws OCAFrameworkException {
        ServerSpec apsSpec = new ServerSpec(spec.getAPS(), "aps", spec.getAPS(), spec.getCluster());
        if (!this.m_mgr.isServerValid(apsSpec)) {
            this.invalidate(apsSpec);
            String oldAPS = this.m_aps;
            this.validateServer(apsSpec, this.m_uri);
            this.m_state = 1;
            this.m_sessions.validate(this);
            if (!oldAPS.equals(this.m_aps)) {
                this.updateServiceMap();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidate(ServerSpec spec) {
        this.lockModify();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Invalidating");
            }
            String name = spec.getName();
            String aps = spec.getAPS();
            Iterator iter = this.m_services.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                ManagedService m = (ManagedService)entry.getValue();
                if (!name.equals(m.getSvr().getName()) && (!"aps".equals(spec.getKind()) || !m.getAPS().equals(aps))) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Invalidated " + m));
                }
                m.invalidate();
            }
            this.m_state = 2;
            this.m_sessions.invalidate(spec, this);
        }
        finally {
            this.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newStatefulService(ManagedService managed) throws OCAFrameworkException {
        this.lockModify();
        try {
            this.remove(managed);
            try {
                managed.validate();
            }
            catch (Exception e) {
                LOG.warn((Object)("(newStatefulService:397): fail to validate server, spec:" + managed.getSvr()), (Throwable)e);
                this.validateStatefulService(managed);
            }
            this.putService(managed);
        }
        finally {
            this.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateStatefulService(ManagedService managed) throws OCAFrameworkException {
        ServerSpec spec = managed.getSvr();
        this.m_mgr.verifyServerStatus(spec, this.m_uri);
        this.lockModify();
        try {
            this.removeService(managed);
            managed.validate();
            this.putService(managed);
        }
        catch (Exception e) {
            this.handleConnectionError(spec, e);
        }
        finally {
            this.releaseLock();
        }
    }

    private void handleConnectionError(ServerSpec spec, Exception e) throws OCAFrameworkException.CommunicationError {
        LOG.warn((Object)("(handleConnectionError:1): validation failed, spec:" + spec), (Throwable)e);
        String name = spec.getName();
        Iterator iter = this.m_services.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ManagedService m = (ManagedService)entry.getValue();
            if (!name.equals(m.getSvr().getName())) continue;
            if (m.getHelper().isStateful()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("(handleConnectionError:2):killing " + m));
                }
                m.kill(e);
                iter.remove();
                continue;
            }
            if (m.getSvr().isReplaceable()) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("(handleConnectionError:3):suspending " + m));
            }
            m.suspend(e);
        }
        this.m_mgr.invalidateServer(spec, this.getURI());
        throw new OCAFrameworkException.CommunicationError(spec.getName(), e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validate(ManagedService managed, boolean enforceLB) throws OCAFrameworkException {
        ServerSpec svr = managed.getSvr();
        String oldName = this.m_aps;
        if (enforceLB) {
            try {
                svr.getAdditionalConfig().setProperty((Object)this.SI_SERVER_PREF, 2);
                String server = this.m_mgr.validateServer(svr, managed.getURI());
                svr.setName(server);
                this.m_aps = server;
                if ("aps".equals(svr.getKind())) {
                    svr.setAPS(server);
                }
            }
            finally {
                svr.getAdditionalConfig().removeLocal((Object)this.SI_SERVER_PREF);
            }
        }
        if ("aps".equals(svr.getKind())) {
            this.validateStatelessService(managed);
        } else if (managed.getHelper().isStateful()) {
            this.validateStatefulService(managed);
        } else {
            this.validateStatelessService(managed);
        }
        if ("aps".equals(svr.getKind()) && !oldName.equals(this.m_aps)) {
            this.updateServiceMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateStatelessService(ManagedService managed) throws OCAFrameworkException {
        ServerSpec spec = managed.getSvr();
        this.lockModify();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Validating: " + managed));
            }
            boolean wasOK = this.m_state == 1;
            boolean invalidatedAPS = false;
            while (true) {
                try {
                    while (this.m_state == 2 || !"aps".equals(spec.getKind()) && !this.m_mgr.isServerValid(spec)) {
                        String name;
                        String uri = managed.getURI();
                        String oldName = spec.getName();
                        if (!oldName.equals(name = this.validateServer(new ServerSpec(spec), uri))) {
                            if ("aps".equals(spec.getKind())) {
                                this.updateServiceMap();
                            } else {
                                this.removeService(managed);
                                spec.setName(name);
                            }
                        }
                        if (spec == managed.getSvr()) break;
                        spec = managed.getSvr();
                    }
                    if (this.m_state == 2) {
                        this.m_state = 1;
                        this.m_sessions.validate(this);
                    }
                    managed.validate();
                    this.putService(managed);
                }
                catch (OCAFrameworkException e) {
                    if (wasOK) {
                        this.invalidate(spec);
                        wasOK = false;
                        continue;
                    }
                    if ("aps".equals(spec.getKind()) || invalidatedAPS) {
                        throw e;
                    }
                    spec = new ServerSpec(spec.getAPS(), "aps", spec.getAPS(), spec.getCluster());
                    this.invalidate(spec);
                    invalidatedAPS = true;
                    continue;
                }
                break;
            }
        }
        finally {
            this.releaseLock();
        }
    }

    private void updateServiceMap() {
        Iterator iter = new ArrayList(this.m_services.values()).iterator();
        while (iter.hasNext()) {
            ManagedService m = (ManagedService)iter.next();
            ServerSpec serverSpec = m.getSvr();
            serverSpec.setAPS(this.m_aps);
            if (!serverSpec.getKind().equals("aps")) continue;
            this.removeService(m);
            serverSpec.setName(this.m_aps);
            this.putService(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(ManagedService managed) {
        this.lockModify();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("remove(): removing " + managed));
            }
            Iterator itr = this.m_services.values().iterator();
            while (itr.hasNext()) {
                ManagedService service = (ManagedService)itr.next();
                if (!managed.equals(service)) continue;
                itr.remove();
            }
        }
        finally {
            this.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(String id, String svc, ServerSpec spec) {
        ManagedService service;
        String name = spec.getName();
        String serverkind = spec.getKind();
        this.lock();
        try {
            service = this.getService(id, svc, name, spec.getGroup(), spec.getGroupMode(), serverkind, spec.getCriteria());
            if (service == null) {
                return;
            }
        }
        finally {
            this.releaseLock();
        }
        this.lockModify();
        try {
            service = this.getService(id, svc, name, spec.getGroup(), spec.getGroupMode(), serverkind, spec.getCriteria());
            if (service != null) {
                this.remove(service);
            }
        }
        finally {
            this.releaseLock();
        }
    }

    private String validateServer(ServerSpec spec, String uri) throws OCAFrameworkException {
        String newServer = this.m_mgr.validateServer(spec, uri);
        if (spec.getKind().equals("aps")) {
            this.m_aps = newServer;
            if (!this.m_token.equals("")) {
                this.reconnectCMS(spec, this.m_aps, 5, true);
                newServer = this.m_aps;
            }
        }
        return newServer;
    }

    private void reconnectCMS(ServerSpec spec, String cms, int numRetries, boolean tryCluster) throws OCAFrameworkException {
        try {
            FailoverLogonService ls = new FailoverLogonService();
            StringHolder uriHolder = new StringHolder(this.m_uri);
            StringHolder tokenHolder = new StringHolder(this.m_token);
            ls.logonWithToken(cms, this.m_token, uriHolder, tokenHolder);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Reconnecting: " + this));
            }
            this.m_sessions.invalidateSession(this, true);
            this.m_uri = uriHolder.get();
            this.m_token = tokenHolder.get();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Reconnected: " + this));
            }
            this.m_aps = cms;
            spec.setName(cms);
            spec.setAPS(cms);
        }
        catch (OCAFrameworkException.LogonFailover e) {
            if (numRetries <= 0) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)"reconnectCMS(): Failed to reconnectCMS, no more retries", (Throwable)((Object)e));
                }
                throw e;
            }
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof oca_abuse && ((oca_abuse)cause).errCode == 10521) {
                String failoverCMS;
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)"reconnectCMS(): ERR_RETRY_FAILOVER_LOGON", (Throwable)((Object)e));
                }
                if ((failoverCMS = this.getFailedOverCMS(cause)) != null && !failoverCMS.equals("")) {
                    this.reconnectCMS(spec, failoverCMS, numRetries - 1, tryCluster);
                } else {
                    String[] servers;
                    boolean retrySameCMS = true;
                    if (tryCluster && (servers = this.m_mgr.getActiveClusterMembers(spec)) != null && servers.length > 0) {
                        retrySameCMS = false;
                        for (int i = 0; i < servers.length; ++i) {
                            String newAPS = servers[i];
                            this.reconnectCMS(spec, newAPS, numRetries - 1, false);
                        }
                    }
                    if (retrySameCMS) {
                        this.reconnectCMS(spec, cms, numRetries - 1, tryCluster);
                    }
                }
            }
            throw e;
        }
    }

    private String getFailedOverCMS(Throwable t) {
        oca_abuse e = (oca_abuse)t;
        if (e.details != null) {
            int beginIndex = e.details.lastIndexOf(FAILEDOVER_CMS_STARTID);
            int endIndex = e.details.lastIndexOf(FAILEDOVER_CMS_ENDID);
            if (beginIndex >= 0 && endIndex >= 0 && beginIndex < endIndex) {
                return e.details.substring(beginIndex + FAILEDOVER_CMS_STARTID_LENGTH, endIndex);
            }
        }
        return "";
    }

    void lock() {
        try {
            this.m_rwlock.forReading();
        }
        catch (SynchronizationException e) {
            LOG.error((Object)"lock(): should never happen", (Throwable)e);
        }
    }

    void lockModify() {
        try {
            this.m_rwlock.forWriting();
        }
        catch (SynchronizationException e) {
            LOG.error((Object)"lockModify(): should never happen", (Throwable)e);
        }
    }

    void releaseLock() {
        try {
            this.m_rwlock.release();
        }
        catch (SynchronizationException e) {
            LOG.error((Object)"releaseLock(): should never happen", (Throwable)e);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ManagedSession) {
            ManagedSession other = (ManagedSession)obj;
            return this.m_aps.equals(other.m_aps) && this.m_uri.equals(other.m_uri);
        }
        return false;
    }

    public int hashCode() {
        return this.m_aps.hashCode() + this.m_uri.hashCode();
    }

    private void putService(ManagedService service) {
        this.m_services.put(new ServiceKey(service.getID(), service.getSvc(), service.getSvr().getName(), "", "", service.getSvr().getGroup(), service.getSvr().getGroupMode(), service.getSvr().getKind(), service.getSvr().getCriteria()), service);
    }

    void putService(ServerSpec spec, ManagedService service) {
        this.m_services.put(new ServiceKey(service.getID(), service.getSvc(), spec.getName(), "", "", spec.getGroup(), spec.getGroupMode(), spec.getKind(), spec.getCriteria()), service);
    }

    ManagedService removeService(ManagedService service) {
        return (ManagedService)this.m_services.remove(new ServiceKey(service.getID(), service.getSvc(), service.getSvr().getName(), "", "", service.getSvr().getGroup(), service.getSvr().getGroupMode(), service.getSvr().getKind(), service.getSvr().getCriteria()));
    }

    private ManagedService getService(String id, String svc, String name, int group, int groupMode, String serverkind, String criteria) {
        return (ManagedService)this.m_services.get(new ServiceKey(id, svc, name, "", "", group, groupMode, serverkind, criteria));
    }

    private ManagedService newService(ServerSpec spec, String id, String svc, IManagedService.IHelperFactory helper) throws OCAFrameworkException {
        ServerSpec original = new ServerSpec(spec);
        if (this.m_sessions.canRedirectServer(spec)) {
            this.redirectServer(spec);
        }
        ManagedService service = new ManagedService(this.m_mgr, this, id, svc, new ServerSpec(spec), helper.makeHelper());
        this.putService(service);
        try {
            this.validateStatelessService(service);
            this.putService(original, service);
        }
        catch (Throwable t) {
            this.remove(service);
            if (t instanceof OCAFrameworkException) {
                LOG.warn((Object)("get(): failed to validate new service, svc=" + svc + ",spec=" + spec + ",aps=" + this.m_aps + ",uri=" + this.m_uri), t);
                throw (OCAFrameworkException)((Object)t);
            }
            if (t instanceof RuntimeException) {
                LOG.warn((Object)("get(): failed to validate new service, svc=" + svc + ",spec=" + spec + ",aps=" + this.m_aps + ",uri=" + this.m_uri), t);
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                LOG.warn((Object)("get(): failed to validate new service, svc=" + svc + ",spec=" + spec + ",aps=" + this.m_aps + ",uri=" + this.m_uri), t);
                throw (Error)t;
            }
            t.printStackTrace();
            LOG.error((Object)("get(): should never happen, msg=" + t.getMessage()), t);
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void expire() {
        this.lock();
        try {
            if (this.isExpired()) {
                return;
            }
        }
        finally {
            this.releaseLock();
        }
        Iterator iter = null;
        this.lockModify();
        try {
            if (this.m_state != 3) {
                iter = new LinkedList(this.m_services.values()).iterator();
                this.m_state = 3;
            }
        }
        finally {
            this.releaseLock();
        }
        if (iter != null) {
            while (iter.hasNext()) {
                ManagedService service = (ManagedService)iter.next();
                service.expire();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logoff() {
        this.lock();
        try {
            if (this.isLoggedOff()) {
                return;
            }
        }
        finally {
            this.releaseLock();
        }
        Iterator iter = null;
        this.lockModify();
        try {
            if (this.m_state != 4) {
                iter = new LinkedList(this.m_services.values()).iterator();
                this.m_state = 4;
            }
        }
        finally {
            this.releaseLock();
        }
        if (iter != null) {
            while (iter.hasNext()) {
                ManagedService service = (ManagedService)iter.next();
                service.release();
            }
        }
    }

    boolean isExpired() {
        return this.m_state == 3;
    }

    boolean isLoggedOff() {
        return this.m_state == 4;
    }

    boolean isValid() {
        return this.m_state == 1;
    }

    void checkValidity() throws OCAFrameworkException {
        if (this.isExpired() || this.isLoggedOff()) {
            throw new OCAFrameworkException.LogonFailover(this.m_aps, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getServiceInfo(Map serviceInfoMap) {
        this.lock();
        try {
            Iterator iter = this.m_services.entrySet().iterator();
            while (iter.hasNext()) {
                String server;
                Map.Entry entry = iter.next();
                ManagedService m = (ManagedService)entry.getValue();
                String cookie = m.getCookie();
                if (cookie == null || cookie.length() == 0 || !serviceInfoMap.containsKey(server = m.getSvr().getName())) continue;
                HashSet serviceInfo = (HashSet)serviceInfoMap.get(server);
                serviceInfo.add(cookie);
            }
        }
        finally {
            this.releaseLock();
        }
    }

    static {
        IGNORED_IDs.add("");
        IGNORED_IDs.add("NEW_ID");
        IGNORED_IDs.add("NO_ID");
        IGNORED_IDs.add("LB_ID");
        FAILEDOVER_CMS_STARTID_LENGTH = FAILEDOVER_CMS_STARTID.length();
    }
}

