/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.enterprise.ocaframework;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.synchronization.RWLock;
import com.crystaldecisions.celib.synchronization.SynchronizationException;
import com.crystaldecisions.enterprise.ocaframework.IManagedService;
import com.crystaldecisions.enterprise.ocaframework.ManagedService;
import com.crystaldecisions.enterprise.ocaframework.ManagedSession;
import com.crystaldecisions.enterprise.ocaframework.OCAFrameworkException;
import com.crystaldecisions.enterprise.ocaframework.ServerSpec;
import com.crystaldecisions.enterprise.ocaframework.ServiceKey;
import com.crystaldecisions.enterprise.ocaframework.ServiceMgr;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ManagedSessions {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.enterprise.ocaframework.ManagedSessions");
    private static final long PING_INTERVAL = 60000L;
    static final long CACHEMGR_INTERVAL = 120000L;
    static final long PINGSERVERS_INTERVAL = 288000L;
    static final long DEFAULT_REFRESH_INTERVAL = 180000L;
    private ServiceMgr m_mgr;
    private final Map m_sessions;
    private final Map m_failoverPingers;
    private final Set m_rootSessions;
    private long m_pingTimestamp;
    private long m_cacheTimestamp;
    private long m_pingServerstamp;
    private long m_refreshClusterTimestamp;
    private long m_refreshInterval;
    private ReferenceQueue m_refqueue;
    private RWLock m_rwlock;
    private static ThreadLocal s_tl_serverredirected = new ThreadLocal();
    private static boolean s_sessLogging = false;

    ManagedSessions(ServiceMgr mgr) {
        this.m_mgr = mgr;
        this.m_rwlock = new RWLock();
        this.m_sessions = new HashMap();
        this.m_refqueue = new ReferenceQueue();
        this.m_rootSessions = new HashSet();
        this.m_failoverPingers = new HashMap();
        this.m_pingTimestamp = System.currentTimeMillis();
        this.m_cacheTimestamp = System.currentTimeMillis();
        this.m_pingServerstamp = System.currentTimeMillis();
        try {
            this.m_refreshInterval = Long.parseLong(System.getProperties().getProperty("businessobjects.clusterinfo_refresh_interval", Long.toString(180000L)));
        }
        catch (NumberFormatException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"ManagedSessions.ManagedSessions(): incorrect system property for cluster refresh interval", (Throwable)e);
            }
            this.m_refreshInterval = 180000L;
        }
    }

    private ServiceKey createSessionKey(ServerSpec spec, String uri) {
        return new ServiceKey("", "", "", spec.getAPS(), uri, 0, 0, "", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ManagedService get(String id, String svc, ServerSpec spec, String uri, String token, IManagedService.IHelperFactory helper) throws OCAFrameworkException {
        if (uri.equals("") && spec.isReplaceable()) {
            this.m_mgr.redirectServer(spec, "");
            this.setServerRedirected(true);
        }
        try {
            ManagedSession session;
            block15: {
                ServiceKey k = this.createSessionKey(spec, uri);
                this.lock();
                try {
                    session = this.getSession(k);
                }
                finally {
                    this.releaseLock();
                }
                if (session == null) {
                    this.lockModify();
                    try {
                        session = this.getSession(k);
                        if (session != null) break block15;
                        if (!this.m_mgr.isServerValid(spec)) {
                            try {
                                this.m_mgr.validateServer(spec, uri);
                            }
                            catch (OCAFrameworkException e) {
                                LOG.warn((Object)"(get:226): this could be caused by the CMS is down. It will be handled later", (Throwable)((Object)e));
                            }
                        }
                        session = new ManagedSession(this.m_mgr, this, spec.getAPS(), uri, token);
                        this.putSession(k, session);
                    }
                    finally {
                        this.releaseLock();
                    }
                }
            }
            LOG.assertNotNull((Object)session, "session is null.");
            ManagedService managedService = session.get(id, svc, spec, helper);
            return managedService;
        }
        finally {
            this.setServerRedirected(false);
        }
    }

    boolean canRedirectServer(ServerSpec spec) {
        return !this.isServerRedirected() && !"aps".equalsIgnoreCase(spec.getKind()) && (spec.isReplaceable() || "".equalsIgnoreCase(spec.getName()));
    }

    void setServerRedirected(boolean redirected) {
        s_tl_serverredirected.set(redirected);
    }

    boolean isServerRedirected() {
        Boolean redirected = (Boolean)s_tl_serverredirected.get();
        if (redirected != null) {
            return redirected;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void expireSession(String uri, ServerSpec spec) {
        ManagedSession session;
        ServiceKey key = this.createSessionKey(spec, uri);
        this.lockModify();
        try {
            session = this.getSession(key);
            if (session == null) {
                return;
            }
            this.m_sessions.remove(new ServiceKey(session));
        }
        finally {
            this.releaseLock();
        }
        session.expire();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isSessionExpired(String uri, ServerSpec spec) {
        ManagedSession session;
        ServiceKey key = this.createSessionKey(spec, uri);
        this.lock();
        try {
            session = this.getSession(key);
            if (session == null) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.releaseLock();
        }
        return session.isExpired();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logoffSession(String uri, ServerSpec spec) {
        ManagedSession session;
        ServiceKey key = this.createSessionKey(spec, uri);
        this.lock();
        try {
            session = this.getSession(key);
            if (session == null) {
                return;
            }
        }
        finally {
            this.releaseLock();
        }
        session.logoff();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(String id, String svc, ServerSpec spec, String uri) throws OCAFrameworkException {
        ManagedSession session;
        ServiceKey k = this.createSessionKey(spec, uri);
        this.lock();
        try {
            session = this.getSession(k);
            if (session == null) {
                return;
            }
        }
        finally {
            this.releaseLock();
        }
        session.remove(id, svc, spec);
    }

    void invalidate(ServerSpec svr, ManagedSession session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Invalidating");
        }
        ServerSpec specCopy = new ServerSpec(svr);
        this.m_mgr.invalidateServer(specCopy, session.getURI());
        this.invalidateSession(session, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invalidateSession(ManagedSession session, boolean bRemoveWeakRef) {
        this.lockModify();
        try {
            if (s_sessLogging) {
                LOG.error((Object)("Invalidate remove session:" + session.getURI()));
            }
            if (bRemoveWeakRef) {
                this.m_sessions.remove(new ServiceKey(session));
            }
            if (session.getURI().length() == 0) {
                this.m_rootSessions.remove(session);
            }
        }
        finally {
            this.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validate(ManagedSession session) throws OCAFrameworkException {
        this.lockModify();
        try {
            this.putSession(new ServiceKey(session), session);
        }
        finally {
            this.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pulse(boolean bRefreshCluster) {
        boolean refreshCluster;
        boolean pingServers;
        boolean cacheMgr;
        block33: {
            SessionRef ref = (SessionRef)this.m_refqueue.poll();
            if (ref != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Cleanup queued refs");
                }
                this.lockModify();
                try {
                    do {
                        if (s_sessLogging) {
                            LOG.error((Object)("Pulse, remove session:" + ref.getKey().toString()));
                        }
                        this.m_sessions.remove(ref.getKey());
                    } while ((ref = (SessionRef)this.m_refqueue.poll()) != null);
                }
                finally {
                    this.releaseLock();
                }
            }
            boolean ping = false;
            cacheMgr = false;
            pingServers = false;
            refreshCluster = false;
            ManagedSessions managedSessions = this;
            synchronized (managedSessions) {
                long now = System.currentTimeMillis();
                if (now > this.m_pingTimestamp + 60000L) {
                    ping = true;
                    this.m_pingTimestamp = now;
                }
                if (now > this.m_cacheTimestamp + 120000L) {
                    cacheMgr = true;
                    this.m_cacheTimestamp = now;
                }
                if (bRefreshCluster && cacheMgr && now > this.m_refreshClusterTimestamp + this.m_refreshInterval) {
                    refreshCluster = true;
                    this.m_refreshClusterTimestamp = now;
                }
                if (now > this.m_pingServerstamp + 288000L) {
                    pingServers = true;
                    this.m_pingServerstamp = now;
                }
            }
            if (!ping) break block33;
            this.lock();
            HashMap<String, String> effectiveFOPingers = new HashMap<String, String>();
            try {
                Map.Entry entry;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Pinging");
                }
                Iterator itr = new ArrayList(this.m_sessions.entrySet()).iterator();
                HashMap<String, LinkedList<String>> pingmap = new HashMap<String, LinkedList<String>>();
                while (itr.hasNext()) {
                    LinkedList<String> ids;
                    int eq;
                    entry = itr.next();
                    WeakReference wr = (WeakReference)entry.getValue();
                    ManagedSession session = (ManagedSession)wr.get();
                    if (session == null || session.isLoggedOff() || session.isExpired()) continue;
                    String apsname = session.getAPS();
                    String id = session.getURI();
                    if (id.length() <= 0 || id.equals("osca:iiop://;BYPASSSEC=true") || id.equals("osca:iiop://;S2SDSCVRY=true") || (id = id.substring((eq = id.lastIndexOf(61)) + 1)).length() <= 0) continue;
                    String pingerCMS = (String)this.m_failoverPingers.get(id);
                    if (pingerCMS != null) {
                        apsname = pingerCMS;
                        effectiveFOPingers.put(id, apsname);
                    }
                    if ((ids = (LinkedList<String>)pingmap.get(apsname)) == null) {
                        ids = new LinkedList<String>();
                        pingmap.put(apsname, ids);
                    }
                    ids.add(id);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("(pulse:390): id=" + id));
                }
                itr = pingmap.entrySet().iterator();
                while (itr.hasNext()) {
                    List sessionIDs;
                    entry = itr.next();
                    String apsname = (String)entry.getKey();
                    Map newFailoverPingers = this.m_mgr.ping(apsname, (sessionIDs = (List)entry.getValue()).toArray(new String[sessionIDs.size()]));
                    if (newFailoverPingers == null) continue;
                    effectiveFOPingers.putAll(newFailoverPingers);
                }
                Object var19_21 = null;
                if (!((Object)this.m_failoverPingers).equals(effectiveFOPingers)) {
                    this.releaseLock();
                    this.lockModify();
                    this.m_failoverPingers.clear();
                    if (effectiveFOPingers != null) {
                        this.m_failoverPingers.putAll(effectiveFOPingers);
                    }
                }
                this.releaseLock();
            }
            catch (Throwable throwable) {
                Object var19_22 = null;
                if (!((Object)this.m_failoverPingers).equals(effectiveFOPingers)) {
                    this.releaseLock();
                    this.lockModify();
                    this.m_failoverPingers.clear();
                    if (effectiveFOPingers != null) {
                        this.m_failoverPingers.putAll(effectiveFOPingers);
                    }
                }
                this.releaseLock();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"ManagedSessions.pulse: effective failover pingers cached");
                    Iterator iter = effectiveFOPingers.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry entry = iter.next();
                        LOG.debug((Object)("session " + entry.getKey() + " failed over to ping cms " + entry.getValue()));
                    }
                }
                throw throwable;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"ManagedSessions.pulse: effective failover pingers cached");
                Iterator iter = effectiveFOPingers.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    LOG.debug((Object)("session " + entry.getKey() + " failed over to ping cms " + entry.getValue()));
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"(pulse:408): done");
            }
        }
        if (cacheMgr) {
            this.m_mgr.manageCache(refreshCluster);
        }
        if (pingServers) {
            this.m_mgr.pingServers();
        }
    }

    void lock() {
        try {
            this.m_rwlock.forReading();
        }
        catch (SynchronizationException e) {
            LOG.error((Object)"lock(): should never happen", (Throwable)e);
        }
    }

    void lockModify() {
        try {
            this.m_rwlock.forWriting();
        }
        catch (SynchronizationException e) {
            LOG.error((Object)"lockModifiy(): should never happen", (Throwable)e);
        }
    }

    void releaseLock() {
        try {
            this.m_rwlock.release();
        }
        catch (SynchronizationException e) {
            LOG.error((Object)"releaseLock(): should never happen", (Throwable)e);
        }
    }

    private ManagedSession getSession(ServiceKey key) {
        ManagedSession session = null;
        WeakReference wr = (WeakReference)this.m_sessions.get(key);
        if (wr != null) {
            session = (ManagedSession)wr.get();
        }
        return session;
    }

    private void putSession(ServiceKey key, ManagedSession session) {
        this.m_sessions.put(key, new SessionRef(session, key, this.m_refqueue));
        if (s_sessLogging) {
            LOG.error((Object)("putSession(): add session " + key));
        }
        if (session.getURI().length() == 0 && !this.m_rootSessions.add(session)) {
            this.m_rootSessions.remove(session);
            this.m_rootSessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getServiceInfo(Map serviceInfoMap) {
        LinkedList<ManagedSession> sessions = new LinkedList<ManagedSession>();
        this.lock();
        try {
            Iterator itr = new ArrayList(this.m_sessions.entrySet()).iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                WeakReference wr = (WeakReference)entry.getValue();
                ManagedSession session = (ManagedSession)wr.get();
                if (session == null || !session.isValid()) continue;
                sessions.add(session);
            }
        }
        finally {
            this.releaseLock();
        }
        Iterator sessionIter = sessions.iterator();
        while (sessionIter.hasNext()) {
            ManagedSession session = (ManagedSession)sessionIter.next();
            session.getServiceInfo(serviceInfoMap);
        }
    }

    static {
        try {
            String sessLogging = System.getenv("SESSION_LOGGING");
            if (sessLogging != null && sessLogging.trim().equals("1")) {
                s_sessLogging = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class SessionRef
    extends WeakReference {
        private ServiceKey m_key;

        public SessionRef(Object referent, ServiceKey key, ReferenceQueue q) {
            super(referent, q);
            this.m_key = key;
        }

        public ServiceKey getKey() {
            return this.m_key;
        }
    }
}

