/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.enterprise.ocaframework;

import com.crystaldecisions.celib.exception.AbstractException;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.message_id;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.message_union;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuse;
import com.crystaldecisions.sdk.exception.SDKExceptionCode;

public class OCAFrameworkException
extends AbstractException {
    private int m_messageID = -1;

    public OCAFrameworkException(String[] message, Throwable cause, int errorId) {
        super(message, cause, errorId);
    }

    public OCAFrameworkException(String[] message, Throwable cause, int errorId, int messageID) {
        super(message, cause, errorId);
        this.m_messageID = messageID;
    }

    oca_abuse convertToOcaAbuse() {
        oca_abuse abuse = new oca_abuse();
        abuse.errCode = (short)this.getExceptionCode();
        String[] params = this.getMessageParams();
        message_union[] messages = new message_union[params.length + 1];
        message_union msg_id = new message_union();
        int messageID = this.m_messageID;
        if (messageID != -1) {
            message_id id = new message_id(messageID, (short)params.length);
            msg_id.msgId(id);
            messages[0] = msg_id;
            for (int i = 0; i < params.length; ++i) {
                message_union msg_string = new message_union();
                msg_string.msgString(params[i]);
                messages[i + 1] = msg_string;
            }
            abuse.messages = messages;
            return abuse;
        }
        return null;
    }

    public static class ErrorCode {
        public static final int Error_Unknown = 0;
        public static final int Error_LogonFailover = 1;
        public static final int Error_NotFoundInDirectory = 2;
        public static final int Error_InvalidCMSPort = 3;
        public static final int Error_CMSSocket = 4;
        public static final int Error_ServiceConnection = 5;
        public static final int Error_ServiceListing = 6;
        public static final int Error_ClusterDown = 7;
        public static final int Error_CMSNotUnique = 8;
        public static final int Error_AllServersDown = 9;
        public static final int Error_CommunicationError = 10;
        public static final int Error_ServerGroupNotFound = 11;
        public static final int Error_ServiceNotFound = 12;
        public static final int Error_SSLMissingArgument = 13;
        public static final int Error_SSLFileOpenError = 14;
        public static final int Error_ServerError = 15;
        public static final int Error_AllServicesDown = 16;
    }

    public static class SSLFileOpenError
    extends OCAFrameworkException {
        public SSLFileOpenError(String filename, Exception ex) {
            super(new String[]{filename, ex.getMessage()}, ex, SSLFileOpenError.getExceptionCode((Throwable)ex, (int)SDKExceptionCode.Error_SSLFileOpenError));
        }
    }

    public static class SSLMissingArgument
    extends OCAFrameworkException {
        public SSLMissingArgument(String name) {
            super(new String[]{name}, null, SDKExceptionCode.Error_SSLMissingArgument);
        }
    }

    public static class ServiceNotFound
    extends OCAFrameworkException {
        public ServiceNotFound(String svc, String server) {
            super(new String[]{svc, server}, null, SDKExceptionCode.Error_ServiceNotFound, 61302);
        }
    }

    public static class ServerGroupNotFound
    extends OCAFrameworkException {
        public ServerGroupNotFound(String groupIDs, String server, Exception cause) {
            super(new String[]{groupIDs, server}, cause, ServerGroupNotFound.getExceptionCode((Throwable)cause, (int)SDKExceptionCode.Error_ServerGroupNotFound), 61305);
        }
    }

    public static class CommunicationError
    extends OCAFrameworkException {
        public CommunicationError(String server, Throwable cause) {
            super(new String[]{server}, cause, CommunicationError.getExceptionCode((Throwable)cause, (int)SDKExceptionCode.Error_CommunicationError), 61301);
        }
    }

    public static class AllServicesDown
    extends OCAFrameworkException {
        public AllServicesDown(String aps, String cluster, String kind, String service, Exception cause) {
            super(new String[]{aps, cluster, kind, service}, cause, AllServicesDown.getExceptionCode((Throwable)cause, (int)SDKExceptionCode.Error_AllServicesDown), 65034);
        }
    }

    public static class AllServersDown
    extends OCAFrameworkException {
        public AllServersDown(String aps, String cluster, String kind, String criteria, Exception cause) {
            super(new String[]{aps, cluster, kind, criteria}, cause, AllServersDown.getExceptionCode((Throwable)cause, (int)SDKExceptionCode.Error_AllServersDown), 61307);
        }
    }

    public static class ServiceListing
    extends OCAFrameworkException {
        public ServiceListing(String svr, String aps, String uri, Exception e) {
            super(new String[]{svr, aps}, e, ServiceListing.getExceptionCode((Throwable)e, (int)SDKExceptionCode.Error_ServiceListing), 61309);
        }
    }

    public static class ServiceConnection
    extends OCAFrameworkException {
        public ServiceConnection(String svc, String svr, String aps, String uri, Exception e) {
            super(new String[]{svc, svr, aps}, e, ServiceConnection.getExceptionCode((Throwable)e, (int)SDKExceptionCode.Error_ServiceConnection), 61306);
        }

        public ServiceConnection(String svc, String svr, String aps, String uri) {
            super(new String[]{svc, svr, aps}, null, SDKExceptionCode.Error_ServiceConnection, 61306);
        }
    }

    public static class CMSSocket
    extends OCAFrameworkException {
        public CMSSocket(String server, Exception e) {
            super(new String[]{server}, e, CMSSocket.getExceptionCode((Throwable)e, (int)SDKExceptionCode.Error_CMSSocket));
        }
    }

    public static class InvalidCMSPort
    extends OCAFrameworkException {
        public InvalidCMSPort(String server, Exception e) {
            super(new String[]{server}, e, InvalidCMSPort.getExceptionCode((Throwable)e, (int)SDKExceptionCode.Error_InvalidCMSPort), 61308);
        }
    }

    public static class NotFoundInDirectory
    extends OCAFrameworkException {
        public NotFoundInDirectory(String server, Exception e) {
            super(new String[]{server}, e, NotFoundInDirectory.getExceptionCode((Throwable)e, (int)SDKExceptionCode.Error_NotFoundInDirectory), 61303);
        }
    }

    public static class LogonFailover
    extends OCAFrameworkException {
        public LogonFailover(String server, Exception e) {
            super(new String[]{server}, e, LogonFailover.getExceptionCode((Throwable)e, (int)SDKExceptionCode.Error_LogonFailover), 61300);
        }
    }

    public static class ServerError
    extends OCAFrameworkException {
        public ServerError(String server, Exception e) {
            super(new String[]{server}, e, ServerError.getExceptionCode((Throwable)e, (int)SDKExceptionCode.Error_ServerError), 61304);
        }
    }
}

