/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.enterprise.ocaframework;

import com.crystaldecisions.celib.commandline.ArgsWriter;
import com.crystaldecisions.enterprise.ocaframework.OCAFrameworkException;
import java.io.File;
import java.util.Properties;

class OCIParameters {
    private Properties m_props;
    private boolean m_bSSLServer = false;
    private boolean m_bSSLClient = false;
    private String m_certDir;
    private String m_trustedCertificate;
    private String m_myCertificate;
    private String m_myKey;
    private String m_myKeyPassphrase;

    public OCIParameters(Properties props) throws OCAFrameworkException {
        this.m_props = props;
        String protocol = this.m_props.getProperty("businessobjects.orb.oci.protocol");
        if (protocol != null) {
            this.m_bSSLClient = this.m_bSSLServer = protocol.equalsIgnoreCase("ssl");
        }
        if (this.isSSLClient() || this.isSSLServer()) {
            this.m_certDir = this.getValue("certDir", "");
            if (this.m_certDir.length() > 0 && !this.m_certDir.endsWith(File.separator)) {
                this.m_certDir = this.m_certDir + File.separator;
            }
            StringBuffer missingArgument = new StringBuffer();
            this.m_trustedCertificate = this.getValue("trustedCert", null);
            if (this.m_trustedCertificate == null) {
                missingArgument.append("trustedCert");
            }
            if (this.isSSLServer()) {
                this.m_myCertificate = this.getValue("sslCert", null);
                if (this.m_myCertificate == null) {
                    if (missingArgument.length() != 0) {
                        missingArgument.append(',');
                    }
                    missingArgument.append("sslCert");
                }
                this.m_myKey = this.getValue("sslKey", null);
                if (this.m_myKey == null) {
                    if (missingArgument.length() != 0) {
                        missingArgument.append(',');
                    }
                    missingArgument.append("sslKey");
                }
                this.m_myKeyPassphrase = this.getValue("passphrase", null);
                if (this.m_myKeyPassphrase == null) {
                    if (missingArgument.length() != 0) {
                        missingArgument.append(',');
                    }
                    missingArgument.append("passphrase");
                }
            }
            if (missingArgument.length() != 0) {
                throw new OCAFrameworkException.SSLMissingArgument(missingArgument.toString());
            }
        }
        this.setOCIInitOptions(this.isIIOPClient(), this.isIIOPServer(), "ooc.orb.init_iiop");
        this.setOCIInitOptions(this.isSSLClient(), this.isSSLServer(), "ooc.fssl.init_oci");
        if (this.isIIOPClient() && (this.isSSLClient() || this.isSSLServer())) {
            this.m_props.setProperty("ooc.fssl.add_protocol_policy", "false");
        }
        if (this.isSSLClient() || this.isSSLServer()) {
            String iiop_host;
            String iiop_bindipv6;
            String iiop_bind;
            String iiop_port;
            String iiop_numeric = this.m_props.getProperty("ooc.iiop.numeric");
            if (iiop_numeric != null) {
                this.m_props.setProperty("ooc.fssl.numeric", iiop_numeric);
            }
            if ((iiop_port = this.m_props.getProperty("ooc.iiop.port")) != null) {
                this.m_props.setProperty("ooc.fssl.port", iiop_port);
            }
            if ((iiop_bind = this.m_props.getProperty("ooc.iiop.bind")) != null) {
                this.m_props.setProperty("ooc.fssl.bind", iiop_bind);
            }
            if ((iiop_bindipv6 = this.m_props.getProperty("ooc.iiop.bindipv6")) != null) {
                this.m_props.setProperty("ooc.fssl.bindipv6", iiop_bindipv6);
            }
            if ((iiop_host = this.m_props.getProperty("ooc.iiop.host")) != null) {
                this.m_props.setProperty("ooc.fssl.host", iiop_host);
            }
        }
    }

    private String getValue(String propName, String defValue) {
        String result = this.m_props.getProperty(propName);
        if (result != null) {
            return result;
        }
        return defValue;
    }

    private void setOCIInitOptions(boolean bClient, boolean bServer, String key) {
        if (bClient && bServer) {
            this.m_props.setProperty(key, "both");
        } else if (bClient) {
            this.m_props.setProperty(key, "client");
        } else if (bServer) {
            this.m_props.setProperty(key, "server");
        } else {
            this.m_props.setProperty(key, "none");
        }
    }

    public Properties getSystemProperties() {
        return this.m_props;
    }

    boolean isSSLServer() {
        return this.m_bSSLServer;
    }

    boolean isIIOPServer() {
        return !this.m_bSSLServer;
    }

    boolean isSSLClient() {
        return this.m_bSSLClient;
    }

    boolean isIIOPClient() {
        return !this.m_bSSLClient;
    }

    public String getCertDir() {
        return this.m_certDir;
    }

    public String getMyCertificate() {
        return this.m_myCertificate;
    }

    public String getMyKey() {
        return this.m_myKey;
    }

    public String getMyKeyPassphrase() {
        return this.m_myKeyPassphrase;
    }

    public String getTrustedCertificate() {
        return this.m_trustedCertificate;
    }

    public String getCommandLineOptions() {
        ArgsWriter writer = new ArgsWriter();
        if (this.isSSLClient() || this.isSSLServer()) {
            writer.setArg("protocol", "ssl");
            writer.setArg("ssl_certdir", this.m_certDir);
            writer.setArg("ssl_trustedcertificate", this.m_trustedCertificate);
            if (this.isSSLServer()) {
                writer.setArg("ssl_mycertificate", this.m_myCertificate);
                writer.setArg("ssl_mykey", this.m_myKey);
                writer.setArg("ssl_mykey_passphrase", this.m_myKeyPassphrase);
            }
        }
        return writer.getCommandLine();
    }
}

