/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.enterprise.ocaframework;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.collections.CaseInsensHashMap;
import com.crystaldecisions.enterprise.ocaframework.IOSCASimpleFactoryMgrListener;
import com.crystaldecisions.enterprise.ocaframework.ServiceMgrFactory;
import com.crystaldecisions.enterprise.ocaframework.idl.ImplServ.OSCAFactory;
import com.crystaldecisions.enterprise.ocaframework.idl.ImplServ.OSCAFactoryHelper;
import com.crystaldecisions.thirdparty.org.omg.CORBA.ORB;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class OSCAUnmanagedSimpleFactoryMgr {
    private static final ILogger LOG = LoggerManager.getLogger((Class)OSCAUnmanagedSimpleFactoryMgr.class);
    private ORB m_orb = ServiceMgrFactory.getServiceMgr().getORB();
    private String m_serverkind;
    private MapMachPorts m_mapMachPorts;
    private Map m_serverIndex;
    private IOSCASimpleFactoryMgrListener m_serverMgrListener;

    public OSCAUnmanagedSimpleFactoryMgr(String i_kind) {
        this.m_serverkind = i_kind;
        this.m_mapMachPorts = new MapMachPorts();
        this.m_serverIndex = Collections.synchronizedMap(new CaseInsensHashMap());
    }

    public void setMachPorts(String i_mach, int i_arrPort) {
        this.m_mapMachPorts.putPort(i_mach, i_arrPort);
    }

    public void start(IOSCASimpleFactoryMgrListener i_facListener) {
        this.m_serverMgrListener = i_facListener;
        this.discoverServers();
        OSCAUnmanagedSimpleFactoryMgrThreadManager.setupMgrThread(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverServers() {
        LinkedList<ServerToPing> serversToPing = new LinkedList<ServerToPing>();
        Map map = this.m_mapMachPorts.m_mapMachPorts;
        synchronized (map) {
            Set s = this.m_mapMachPorts.m_mapMachPorts.entrySet();
            Iterator iter = s.iterator();
            while (iter.hasNext()) {
                Map.Entry ent = iter.next();
                String sMachName = (String)ent.getKey();
                Iterator iterPorts = ((Map)ent.getValue()).keySet().iterator();
                while (iterPorts.hasNext()) {
                    int iPort = (Integer)iterPorts.next();
                    ServDesc svrDesc = this.resolveSocket(sMachName, iPort);
                    if (svrDesc == null) continue;
                    serversToPing.add(new ServerToPing(svrDesc, false));
                }
            }
        }
        if (serversToPing.size() > 0) {
            this.pingServers(serversToPing);
            Iterator iter = serversToPing.iterator();
            while (iter.hasNext()) {
                ServerToPing serverToPing = (ServerToPing)iter.next();
                ServDesc currServDesc = serverToPing.m_servDesc;
                if (!serverToPing.m_isUp || !this.isUpServer(currServDesc) || this.m_serverMgrListener != null && !this.m_serverMgrListener.update(currServDesc.m_serverName, currServDesc.m_server, IOSCASimpleFactoryMgrListener.ServerState.ServerStateUp)) continue;
                this.m_serverIndex.put(currServDesc.m_serverName, currServDesc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPingToAllServers() {
        ServDesc currServDesc;
        LinkedList<ServerToPing> serversToPing = new LinkedList<ServerToPing>();
        Map map = this.m_serverIndex;
        synchronized (map) {
            Iterator iter = this.m_serverIndex.values().iterator();
            while (iter.hasNext()) {
                currServDesc = (ServDesc)iter.next();
                if (this.hasSOCKSconnection(currServDesc.m_server)) {
                    if (!this.isUpServer(currServDesc) || this.m_serverMgrListener == null) continue;
                    this.m_serverMgrListener.update(currServDesc.m_serverName, currServDesc.m_server, IOSCASimpleFactoryMgrListener.ServerState.ServerStateDown);
                    continue;
                }
                serversToPing.add(new ServerToPing(currServDesc, false));
            }
        }
        if (serversToPing.size() > 0) {
            this.pingServers(serversToPing);
            Iterator iter = serversToPing.iterator();
            while (iter.hasNext()) {
                ServerToPing serverToPing = (ServerToPing)iter.next();
                currServDesc = serverToPing.m_servDesc;
                boolean bServerUp = false;
                if (serverToPing.m_isUp && this.isUpServer(currServDesc)) {
                    bServerUp = true;
                }
                if (bServerUp) {
                    if (this.m_serverMgrListener == null) continue;
                    this.m_serverMgrListener.update(currServDesc.m_serverName, currServDesc.m_server, IOSCASimpleFactoryMgrListener.ServerState.ServerStateUp);
                    continue;
                }
                if (this.m_serverMgrListener == null) continue;
                this.m_serverMgrListener.update(currServDesc.m_serverName, currServDesc.m_server, IOSCASimpleFactoryMgrListener.ServerState.ServerStateDown);
            }
        }
    }

    private boolean isUpServer(ServDesc i_servDesc) {
        boolean bRet = false;
        try {
            bRet = i_servDesc.m_server == null ? false : !i_servDesc.m_server._non_existent();
        }
        catch (SystemException e) {
            LOG.warn((Object)("isUpServer() " + e.getMessage()));
            bRet = false;
        }
        return bRet;
    }

    private ServDesc resolveSocket(String i_sMachName, int i_portNum) {
        String[] arrStrings = new String[2];
        boolean bRet = this.getIOR(this.m_serverkind, i_sMachName, i_portNum, arrStrings);
        if (!bRet) {
            int idxDot = i_sMachName.indexOf(".");
            if (idxDot == -1) {
                return null;
            }
            String shortName = i_sMachName.substring(0, idxDot);
            bRet = this.getIOR(this.m_serverkind, shortName, i_portNum, arrStrings);
            if (!bRet) {
                return null;
            }
        }
        String sIOR = arrStrings[0];
        String sServerName = arrStrings[1];
        if (sServerName == null || sIOR == null || !sIOR.startsWith("IOR")) {
            return null;
        }
        ServDesc svrDesc = new ServDesc(OSCAFactoryHelper.narrow((com.crystaldecisions.thirdparty.org.omg.CORBA.Object)this.m_orb.string_to_object(sIOR)), sServerName, i_sMachName, i_portNum);
        return svrDesc;
    }

    private boolean hasSOCKSconnection(OSCAFactory i_serverFac) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean getIOR(String kind, String i_hostName, int i_hostPort, String[] o_arrStrings) {
        block27: {
            Socket iorSocket = null;
            try {
                iorSocket = new Socket(i_hostName, i_hostPort);
            }
            catch (UnknownHostException e) {
                LOG.warn((Object)("getIOR() 001 " + e.getMessage()));
                return false;
            }
            catch (IOException e) {
                LOG.warn((Object)("getIOR() 002 " + e.getMessage()));
                return false;
            }
            DataOutputStream out = null;
            DataInputStream in = null;
            try {
                iorSocket.setSoTimeout(10000);
                out = new DataOutputStream(iorSocket.getOutputStream());
                in = new DataInputStream(iorSocket.getInputStream());
            }
            catch (IOException e) {
                try {
                    iorSocket.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                LOG.warn((Object)("getIOR() 003 " + e.getMessage()));
                return false;
            }
            out.write(kind.getBytes());
            out.flush();
            int inLen = in.readInt();
            byte[] inBytes = new byte[inLen];
            in.readFully(inBytes, 0, inLen);
            o_arrStrings[0] = new String(inBytes);
            inBytes = null;
            inLen = in.readInt();
            inBytes = new byte[inLen];
            in.readFully(inBytes, 0, inLen);
            o_arrStrings[1] = new String(inBytes);
            inBytes = null;
            Object var11_15 = null;
            try {
                in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                out.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                iorSocket.close();
            }
            catch (IOException e) {}
            break block27;
            {
                catch (IOException ioe) {
                    LOG.warn((Object)("getIOR() 004 " + ioe.getMessage()));
                    Object var11_16 = null;
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    try {
                        iorSocket.close();
                    }
                    catch (IOException e) {}
                }
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                try {
                    in.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    out.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    iorSocket.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return true;
    }

    private void pingServers(List serversToPing) {
        Iterator iter = serversToPing.iterator();
        block7: while (iter.hasNext()) {
            ServerToPing serverToPing = (ServerToPing)iter.next();
            int numRetries = 3;
            for (int currAttempt = 0; currAttempt < 3; ++currAttempt) {
                Socket socket = null;
                serverToPing.m_isUp = false;
                try {
                    socket = new Socket(serverToPing.m_servDesc.m_host, serverToPing.m_servDesc.m_port);
                    serverToPing.m_isUp = true;
                }
                catch (UnknownHostException e) {
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (serverToPing.m_isUp) {
                    if (socket == null) continue block7;
                    try {
                        socket.close();
                    }
                    catch (IOException e) {}
                    continue block7;
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
    }

    private static class OSCAUnmanagedSimpleFactoryMgrThread
    implements Runnable {
        private List m_WeakListOfMgrs = Collections.synchronizedList(new LinkedList());

        public void addMgr(OSCAUnmanagedSimpleFactoryMgr i_mgr) {
            this.m_WeakListOfMgrs.add(new WeakReference<OSCAUnmanagedSimpleFactoryMgr>(i_mgr));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int numMgrs = this.m_WeakListOfMgrs.size();
            while (numMgrs > 0) {
                long sleepMs = 60000L;
                try {
                    Thread.sleep(sleepMs);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                List list = this.m_WeakListOfMgrs;
                synchronized (list) {
                    Iterator iter = this.m_WeakListOfMgrs.iterator();
                    while (iter.hasNext()) {
                        WeakReference weakRef = (WeakReference)iter.next();
                        OSCAUnmanagedSimpleFactoryMgr mgr = (OSCAUnmanagedSimpleFactoryMgr)weakRef.get();
                        if (mgr != null) {
                            mgr.discoverServers();
                            mgr.sendPingToAllServers();
                            continue;
                        }
                        iter.remove();
                    }
                    numMgrs = this.m_WeakListOfMgrs.size();
                }
            }
            OSCAUnmanagedSimpleFactoryMgrThreadManager.clearSingleton();
        }
    }

    private static class OSCAUnmanagedSimpleFactoryMgrThreadManager {
        private static final Object s_mutex = new Object();
        private static OSCAUnmanagedSimpleFactoryMgrThread s_singleton;

        private OSCAUnmanagedSimpleFactoryMgrThreadManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void setupMgrThread(OSCAUnmanagedSimpleFactoryMgr mgr) {
            Object object = s_mutex;
            synchronized (object) {
                if (s_singleton == null) {
                    s_singleton = new OSCAUnmanagedSimpleFactoryMgrThread();
                    s_singleton.addMgr(mgr);
                    new Thread(s_singleton).start();
                } else {
                    s_singleton.addMgr(mgr);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void clearSingleton() {
            Object object = s_mutex;
            synchronized (object) {
                s_singleton = null;
            }
        }
    }

    private class ServerToPing {
        public ServDesc m_servDesc;
        public boolean m_isUp;

        public ServerToPing(ServDesc i_servDesc, boolean i_isUp) {
            this.m_servDesc = i_servDesc;
            this.m_isUp = i_isUp;
        }
    }

    private class ServDesc {
        public OSCAFactory m_server;
        public String m_serverName;
        public String m_host;
        public int m_port;

        public ServDesc(OSCAFactory i_fac, String i_serverName, String i_host, int i_port) {
            this.m_server = i_fac;
            this.m_serverName = i_serverName;
            this.m_host = i_host;
            this.m_port = i_port;
        }
    }

    private class MapMachPorts {
        public Map m_mapMachPorts = Collections.synchronizedMap(new CaseInsensHashMap());

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putPort(String i_machName, int i_port) {
            Map map = this.m_mapMachPorts;
            synchronized (map) {
                TreeMap<Integer, Integer> mapPorts = (TreeMap<Integer, Integer>)this.m_mapMachPorts.get(i_machName);
                if (mapPorts == null) {
                    mapPorts = new TreeMap<Integer, Integer>();
                }
                mapPorts.put(new Integer(i_port), new Integer(i_port));
                this.m_mapMachPorts.put(i_machName, mapPorts);
            }
        }
    }
}

